package io.github.dennisochulor.tickrate;

import io.github.dennisochulor.tickrate.api_impl.TickRateAPIImpl;
import io.github.dennisochulor.tickrate.test.Test;
import net.fabricmc.api.ModInitializer;

import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerEntityEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_8915;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TickRate implements ModInitializer {

	public static final String MOD_ID = "tickrate";
	public static final Logger LOGGER = LoggerFactory.getLogger(MOD_ID);
	public static final float MAX_SOUND_PITCH = 4.0F;
	public static final float MIN_SOUND_PITCH = 0.25F;


	@Override
	public void onInitialize() {
		LOGGER.info("Initializing tickrate!");
		PayloadTypeRegistry.playS2C().register(TickRateHelloPayload.ID, TickRateHelloPayload.CODEC);
		PayloadTypeRegistry.playC2S().register(TickRateHelloPayload.ID, TickRateHelloPayload.CODEC);
		PayloadTypeRegistry.playS2C().register(TickRateS2CUpdatePayload.ID, TickRateS2CUpdatePayload.CODEC);

		ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> {
			LOGGER.debug("send tickrate Hello");
			sender.sendPacket(new TickRateHelloPayload());
		});

		ServerPlayConnectionEvents.DISCONNECT.register((handler, server) -> {
			LOGGER.debug("disconnect tickrate");
			server.method_54833().tickRate$removePlayerWithMod(handler.method_32311());
		});

		ServerPlayNetworking.registerGlobalReceiver(TickRateHelloPayload.ID, ((payload, context) -> {
			LOGGER.debug("received TickRate Hello");
			class_8915 tickManager = context.server().method_54833();
			tickManager.tickRate$addPlayerWithMod(context.player());
			tickManager.tickRate$sendUpdatePacket();
		}));

		ServerLifecycleEvents.SERVER_STARTING.register(server -> server.method_54833().tickRate$serverStarted());

		ServerLifecycleEvents.SERVER_STARTED.register(TickRateAPIImpl::init);

		ServerLifecycleEvents.SERVER_STOPPING.register(server -> TickRateAPIImpl.uninit());

		ServerLifecycleEvents.AFTER_SAVE.register((server, flush, force) -> { // for autosaves and when server stops
			server.method_54833().tickRate$saveData();
		});

		// called when entity's chunk level becomes ACCESSIBLE (at least FULL) if it was previously INACCESSIBLE
		ServerEntityEvents.ENTITY_LOAD.register((entity,serverWorld) -> {
			class_8915 tickManager = (class_8915) serverWorld.method_54719();
			tickManager.tickRate$updateEntityLoad(entity,true);
		});

		// called when entity's chunk level becomes INACCESSIBLE
		ServerEntityEvents.ENTITY_UNLOAD.register((entity,serverWorld) -> {
			class_8915 tickManager = (class_8915) serverWorld.method_54719();
			tickManager.tickRate$updateEntityLoad(entity,false);
		});

		// TickRate testing command
		if(FabricLoader.getInstance().isDevelopmentEnvironment()) {
			CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> {
				dispatcher.register(class_2170.method_9247("tickratetest").then(class_2170.method_9244("entity", class_2186.method_9309()).executes(context -> {
					Test.test(class_2186.method_9313(context, "entity"));
					return 1;
				}))
				.then(class_2170.method_9247("server").executes(context -> {
					Test.test(context.getSource().method_9211());
					return 1;
				})));
			});
		}

	}


}