package io.github.dennisochulor.tickrate;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_310;
import net.minecraft.class_8921;
import net.minecraft.class_9779;

public class TickRateClientManager {

    private TickRateClientManager() {}

    private static boolean serverHasMod = false;
    private static TickState serverState;
    private static final Map<Integer,TickState> entities = new HashMap<>(); // only has entities for current client world
    private static final Map<Long,TickState> chunks = new HashMap<>(); // only has chunks for current client world
    private static final Map<Integer,TickDeltaInfo> entityCache = new HashMap<>();
    private static final Map<Long,TickDeltaInfo> chunkCache = new HashMap<>();

    public static void update(TickRateS2CUpdatePayload payload) {
        serverState = payload.server();
        entities.clear();
        chunks.clear();
        entities.putAll(payload.entities());
        chunks.putAll(payload.chunks());
    }

    // called in RenderTickCounterDynamicMixin
    public static void clearCache() {
        entityCache.clear();
        chunkCache.clear();
    }

    public static void setServerHasMod(boolean serverHasMod) {
        TickRateClientManager.serverHasMod = serverHasMod;
        if(!serverHasMod) {
            serverState = null;
            entities.clear();
            chunks.clear();
        }
    }

    public static boolean serverHasMod() {
        return serverHasMod;
    }

    public static float getMillisPerServerTick() {
        return 1000.0f / serverState.rate();
    }

    public static TickDeltaInfo getEntityTickDelta(class_1297 entity) {
        TickDeltaInfo info = entityCache.get(entity.method_5628());
        if(info != null) return info;

        class_9779 renderTickCounter = class_310.method_1551().method_61966();
        if(!serverHasMod) info = TickDeltaInfo.ofServer(false);
        else if(class_310.method_1551().method_1493()) info = TickDeltaInfo.NO_ANIMATE;
        else if(entity instanceof class_1657 && serverState.frozen()) info = TickDeltaInfo.ofServer(true); // tick freeze doesn't affect players
        else if(entity.method_5765()) info = getEntityTickDelta(entity.method_5668());
        else {
            // client's own player OR entities where client player is a passenger can go above 20TPS limit
            boolean cappedAt20TPS = !(entity==class_310.method_1551().field_1724) && !entity.method_5626(class_310.method_1551().field_1724);
            TickState state = getEntityState(entity); // this also handles passenger entities
            if(state.sprinting()) // animate at max 20 TPS but for client player we don't know the TPS, so just say 100 :P
                info = cappedAt20TPS ? renderTickCounter.tickRate$getSpecificTickDeltaInfo(20) : renderTickCounter.tickRate$getClientPlayerTickDeltaInfo(100);
            else if(state.frozen() && !state.stepping()) info = TickDeltaInfo.NO_ANIMATE;
            else if(!cappedAt20TPS) info = renderTickCounter.tickRate$getClientPlayerTickDeltaInfo((int) state.rate());
            else info = renderTickCounter.tickRate$getSpecificTickDeltaInfo((int) state.rate());
        }

        entityCache.put(entity.method_5628(), info);
        return info;
    }

    public static TickDeltaInfo getChunkTickDelta(long chunkPos) {
        TickDeltaInfo info = chunkCache.get(chunkPos);
        if(info != null) return info;

        class_9779 renderTickCounter = class_310.method_1551().method_61966();
        if(!serverHasMod) info = TickDeltaInfo.ofServer(false);
        else if(class_310.method_1551().method_1493()) info = TickDeltaInfo.NO_ANIMATE;
        else {
            TickState state = getChunkState(chunkPos);
            if(state.sprinting()) info = renderTickCounter.tickRate$getSpecificTickDeltaInfo(20); // animate at max 20 TPS
            else if(state.frozen() && !state.stepping()) info = TickDeltaInfo.NO_ANIMATE;
            else info = renderTickCounter.tickRate$getSpecificTickDeltaInfo((int) state.rate());
        }

        chunkCache.put(chunkPos, info);
        return info;
    }

    public static TickState getEntityState(class_1297 entity) {
        if(entity.method_5765()) return getEntityState(entity.method_5668()); // all passengers will follow TPS of the root entity
        TickState state = entities.get(entity.method_5628());
        if(state == null) return getChunkState(entity.method_31476().method_8324());

        float rate = state.rate();
        if(rate == -1.0f) rate = getChunkState(entity.method_31476().method_8324()).rate();
        if(serverState.frozen() || serverState.sprinting() || serverState.stepping())
            return new TickState(serverState.stepping() ? serverState.rate() : rate,serverState.frozen(),serverState.stepping(),serverState.sprinting());
        return new TickState(rate,state.frozen(),state.stepping(),state.sprinting());
    }

    /**
     * World is assumed to be the {@link class_310#field_1687}
     */
    public static TickState getChunkState(long chunkPos) {
        if(!serverHasMod) return getServerState();
        TickState state = chunks.get(chunkPos);
        if(state == null) return serverState;

        float rate = state.rate();
        if(state.rate() == -1.0f) rate = serverState.rate();
        if(serverState.frozen() || serverState.sprinting() || serverState.stepping())
            return new TickState(serverState.stepping() ? serverState.rate() : rate,serverState.frozen(),serverState.stepping(),serverState.sprinting());
        return new TickState(rate,state.frozen(),state.stepping(),state.sprinting());
    }

    public static TickState getServerState() {
        if(!serverHasMod) {
            class_8921 tickManager = class_310.method_1551().field_1687.method_54719();
            return new TickState(tickManager.method_54748(),tickManager.method_54754(),tickManager.method_54752(),false); // Client does not have any sprint info
        }
        return serverState;
    }

}
