package io.github.dennisochulor.tickrate.mixin.chunk;

import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1676;
import net.minecraft.class_1923;
import net.minecraft.class_3194;
import net.minecraft.class_3218;
import net.minecraft.class_3231;
import net.minecraft.class_3898;
import net.minecraft.class_8915;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_3898.class)
public class ServerChunkLoadingManagerMixin {

    @Shadow @Final class_3218 world;

    @Unique private boolean bl;

    // this is done instead of CHUNK_LOAD/CHUNK_UNLOAD because CHUNK_UNLOAD only fires around chunk level 45 (11 after inaccessible)
    @Inject(method = "onChunkStatusChange", at = @At("TAIL"))
    void onChunkStatusChange(class_1923 chunkPos, class_3194 levelType, CallbackInfo ci) {
        class_8915 tickManager = (class_8915) world.method_54719();
        // consider chunk LOADED if FULL, BLOCK_TICKING, ENTITY_TICKING
        // consider chunk UNLOADED if INACCESSIBLE
        tickManager.tickRate$updateChunkLoad(world, chunkPos.method_8324(), levelType.method_14014(class_3194.field_44855));
    }

    @ModifyVariable(method = "tickEntityMovement", at = @At("STORE"))
    boolean tickEntityMovement$getBl(boolean bl) {
        this.bl = bl;
        return bl;
    }

    /**
     * This relates to MC-76973
     * Logically, this should apply uniformly to all entities, but for some unknown reason only projectiles/items
     * work properly with this. Other entities will become noticeably less smooth at low TPS. Hence the
     * distinction below is required. Sigh.
     */
    @Redirect(method = "tickEntityMovement", at = @At(value = "INVOKE", target = "Lnet/minecraft/server/network/EntityTrackerEntry;tick()V"))
    void tickEntityMovement$tickEntityTrackerEntry(class_3231 entry) {
        class_1297 entity = entry.tickRate$getEntity();
        if(entity instanceof class_1676 || entity instanceof class_1542) {
            class_8915 tickManager = (class_8915) world.method_54719();
            if(this.bl || tickManager.tickRate$shouldTickEntity(entity)) entry.method_18756();
        }
        else entry.method_18756();
    }

}
