package io.github.dennisochulor.tickrate.mixin.chunk;

import io.github.dennisochulor.tickrate.injected_interface.TickRateWorldTickScheduler;
import io.github.dennisochulor.tickrate.TickState;
import it.unimi.dsi.fastutil.longs.Long2LongMap;
import it.unimi.dsi.fastutil.longs.Long2LongMaps;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import org.spongepowered.asm.mixin.*;

import java.util.List;
import java.util.Queue;
import java.util.function.LongPredicate;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import net.minecraft.class_6755;
import net.minecraft.class_6757;
import net.minecraft.class_6760;
import net.minecraft.class_8915;

@Mixin(class_6757.class)
public class WorldTickSchedulerMixin<T> implements TickRateWorldTickScheduler {

    @Shadow @Final private Long2ObjectMap<class_6755<T>> chunkTickSchedulers;
    @Shadow @Final private Queue<class_6760<T>> tickableTicks;
    @Shadow @Final private LongPredicate tickingFutureReadyPredicate;
    @Shadow @Final private Long2LongMap nextTriggerTickByChunkPos;
    @Shadow @Final private Queue<class_6755<T>> tickableChunkTickSchedulers;
    @Unique private class_1937 world;

    /**
     * @author Ninjaking312
     * @reason Because there is no other good way to do this damn it (continuing the while loop)
     */
    @Overwrite
    @SuppressWarnings("unchecked")
    private void collectTickableChunkTickSchedulers(long time) {
        ObjectIterator<Long2LongMap.Entry> objectIterator = Long2LongMaps.fastIterator(nextTriggerTickByChunkPos);

        while (objectIterator.hasNext()) {
            Long2LongMap.Entry entry = objectIterator.next();
            long l = entry.getLongKey();
            long m = entry.getLongValue();

            class_6755<T> chunkTickScheduler = chunkTickSchedulers.get(l);
            class_8915 tickManager = (class_8915) world.method_54719();
            chunkTickScheduler.tickRate$setServerTime(time);
            TickState tickState = tickManager.tickRate$getChunkTickStateShallow(world,l);
            if(tickState.rate() == -1.0f && !tickState.frozen() && !tickState.sprinting()) {
                chunkTickScheduler.tickRate$toggleMode(true);
            }
            else {
                chunkTickScheduler.tickRate$toggleMode(false);
                if(tickManager.tickRate$shouldTickChunk(world,l)) {
                    List<class_6760<T>> list = chunkTickScheduler.tickRate$tick();
                    this.tickableTicks.addAll(list);
                }
                continue; // this is your fault
            }

            if (m <= time) {
                class_6755<T> chunkTickScheduler1 = this.chunkTickSchedulers.get(l);
                if (chunkTickScheduler1 == null) {
                    objectIterator.remove();
                } else {
                    class_6760<T> orderedTick = chunkTickScheduler1.method_39369();
                    if (orderedTick == null) {
                        objectIterator.remove();
                    } else if (orderedTick.comp_254() > time) {
                        entry.setValue(orderedTick.comp_254());
                    } else if (this.tickingFutureReadyPredicate.test(l)) {
                        objectIterator.remove();
                        this.tickableChunkTickSchedulers.add(chunkTickScheduler1);
                    }
                }
            }
        }
    }

    @Unique
    public void tickRate$setWorld(class_3218 world) {
        this.world = world;
    }

}
