package io.github.dennisochulor.tickrate.mixin.client.misc;

import io.github.dennisochulor.tickrate.TickRateClientManager;
import net.minecraft.class_1923;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_702;
import net.minecraft.class_703;
import net.minecraft.class_733;
import net.minecraft.class_9779;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(class_702.class)
public class ParticleManagerMixin {

    @Redirect(method = "tickParticle", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/particle/Particle;tick()V"))
    private void tickParticle(class_703 particle) {
        if(TickRateClientManager.serverHasMod()) {
            class_9779 renderTickCounter = class_310.method_1551().method_61966();
            if(renderTickCounter.tickRate$getMovingI() < TickRateClientManager.getChunkTickDelta(class_1923.method_37232(particle.tickRate$getBlockPos())).i()) {
                particle.method_3070();
            }
        }
        else particle.method_3070();
    }

    @Redirect(method = "tick", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/particle/EmitterParticle;tick()V"))
    public void tick$emitters(class_733 particle) {
        if(TickRateClientManager.serverHasMod()) {
            class_9779 renderTickCounter = class_310.method_1551().method_61966();
            if(renderTickCounter.tickRate$getMovingI() < TickRateClientManager.getChunkTickDelta(class_1923.method_37232(particle.tickRate$getBlockPos())).i()) {
                particle.method_3070();
            }
        }
        else particle.method_3070();
    }

    @Redirect(method = "renderParticles(Lnet/minecraft/client/render/Camera;FLnet/minecraft/client/render/VertexConsumerProvider$Immediate;Lnet/minecraft/client/particle/ParticleTextureSheet;Ljava/util/Queue;)V", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/particle/Particle;render(Lnet/minecraft/client/render/VertexConsumer;Lnet/minecraft/client/render/Camera;F)V"))
    private static void renderParticles(class_703 particle, class_4588 vertexConsumer, class_4184 camera, float tickDelta) {
        particle.method_3074(vertexConsumer, camera, TickRateClientManager.getChunkTickDelta(class_1923.method_37232(particle.tickRate$getBlockPos())).tickDelta());
    }

    @Redirect(method = "renderCustomParticles", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/particle/Particle;renderCustom(Lnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumerProvider;Lnet/minecraft/client/render/Camera;F)V"))
    private static void renderParticles(class_703 particle, class_4587 matrices, class_4597 vertexConsumers, class_4184 camera, float tickDelta) {
        particle.method_65198(matrices, vertexConsumers, camera, TickRateClientManager.getChunkTickDelta(class_1923.method_37232(particle.tickRate$getBlockPos())).tickDelta());
    }

}
