package io.github.dennisochulor.tickrate.mixin.core;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.tree.LiteralCommandNode;
import io.github.dennisochulor.tickrate.api.TickRateEvents;
import org.spongepowered.asm.mixin.*;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import java.util.*;
import net.minecraft.class_1297;
import net.minecraft.class_1923;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2186;
import net.minecraft.class_2245;
import net.minecraft.class_2262;
import net.minecraft.class_2264;
import net.minecraft.class_2265;
import net.minecraft.class_2561;
import net.minecraft.class_2806;
import net.minecraft.class_2818;
import net.minecraft.class_3194;
import net.minecraft.class_3222;
import net.minecraft.class_4076;
import net.minecraft.class_4802;
import net.minecraft.class_5250;
import net.minecraft.class_8012;
import net.minecraft.class_8915;
import net.minecraft.class_8916;

@Mixin(class_8916.class)
public class TickCommandMixin {

    @Shadow @Final private static String DEFAULT_TICK_RATE_STRING;
    @Shadow private static String format(long nanos) { return ""; }

    // the requires lambda
    @ModifyConstant(method = "method_54709", constant = @Constant(intValue = 3))
    private static int modifyPermissionLevel(int permissionLevel) {
        return 2;
    }

    // register the subcommands by modifying literal("tick") return value
    @ModifyExpressionValue(method = "register", at = @At(value = "INVOKE", target = "Lnet/minecraft/server/command/CommandManager;literal(Ljava/lang/String;)Lcom/mojang/brigadier/builder/LiteralArgumentBuilder;", args = "ldc=tick", ordinal = 0))
    private static LiteralArgumentBuilder<class_2168> register(LiteralArgumentBuilder<class_2168> builder) {
        LiteralCommandNode<class_2168> chunkQuery = class_2170.method_9247("query")
                .executes(context -> executeChunkQuery(context.getSource(), getChunks(context,1))).build();

        LiteralCommandNode<class_2168> chunkRate = class_2170.method_9247("rate")
                .then(class_2170.method_9247("reset").executes(context -> executeChunkRate(context.getSource(), getChunks(context,2), 0.0f)))
                .then(class_2170.method_9244("rate", FloatArgumentType.floatArg(1.0F, 10000.0F))
                        .suggests((context, suggestionsBuilder) -> class_2172.method_9253(new String[]{DEFAULT_TICK_RATE_STRING,"reset"}, suggestionsBuilder))
                        .executes(context -> executeChunkRate(context.getSource(), getChunks(context,2), FloatArgumentType.getFloat(context, "rate")))).build();

        LiteralCommandNode<class_2168> chunkUnfreeze = class_2170.method_9247("unfreeze")
                .executes(context -> executeChunkFreeze(context.getSource(), getChunks(context,1), false)).build();

        LiteralCommandNode<class_2168> chunkFreeze = class_2170.method_9247("freeze")
                .executes(context -> executeChunkFreeze(context.getSource(), getChunks(context,1), true)).build();

        LiteralCommandNode<class_2168> chunkStep = class_2170.method_9247("step")
                .executes(context -> executeChunkStep(context.getSource(), getChunks(context,1), 1))
                .then(class_2170.method_9247("stop").executes(context -> executeChunkStep(context.getSource(), getChunks(context,2), 0)))
                .then(class_2170.method_9244("time", class_2245.method_48287(1))
                        .suggests((context, suggestionsBuilder) -> class_2172.method_9253(new String[]{"1t", "1s"}, suggestionsBuilder))
                        .executes(context -> executeChunkStep(context.getSource(), getChunks(context,2), IntegerArgumentType.getInteger(context, "time")))).build();

        LiteralCommandNode<class_2168> chunkSprint = class_2170.method_9247("sprint")
                .then(class_2170.method_9247("stop").executes(context -> executeChunkSprint(context.getSource(), getChunks(context,2), 0)))
                .then(class_2170.method_9244("time", class_2245.method_48287(1))
                        .suggests((context, suggestionsBuilder) -> class_2172.method_9253(new String[]{"60s", "1d", "3d"}, suggestionsBuilder))
                        .executes(context -> executeChunkSprint(context.getSource(), getChunks(context,2), IntegerArgumentType.getInteger(context, "time")))).build();

        builder.then(
                class_2170.method_9247("entity")
                        .then(class_2170.method_9244("entities", class_2186.method_9306())
                                .then(class_2170.method_9247("query")
                                        .executes(context -> executeEntityQuery(context.getSource(), class_2186.method_9317(context, "entities")))
                                )
                                .then(class_2170.method_9247("rate")
                                        .then(class_2170.method_9247("reset").executes(context -> executeEntityRate(context.getSource(), class_2186.method_9317(context, "entities"), 0.0f)))
                                        .then(class_2170.method_9244("rate", FloatArgumentType.floatArg(1.0F, 10000.0F))
                                                .suggests((context, suggestionsBuilder) -> class_2172.method_9253(new String[]{DEFAULT_TICK_RATE_STRING,"reset"}, suggestionsBuilder))
                                                .executes(context -> executeEntityRate(context.getSource(), class_2186.method_9317(context, "entities"), FloatArgumentType.getFloat(context, "rate"))))
                                )
                                .then(class_2170.method_9247("unfreeze")
                                        .executes(context -> executeEntityFreeze(context.getSource(), class_2186.method_9317(context, "entities"), false))
                                )
                                .then(class_2170.method_9247("freeze")
                                        .executes(context -> executeEntityFreeze(context.getSource(), class_2186.method_9317(context, "entities"), true))
                                )
                                .then(class_2170.method_9247("step")
                                        .executes(context -> executeEntityStep(context.getSource(), class_2186.method_9317(context,"entities"), 1))
                                        .then(class_2170.method_9247("stop").executes(context -> executeEntityStep(context.getSource(), class_2186.method_9317(context, "entities"), 0)))
                                        .then(class_2170.method_9244("time", class_2245.method_48287(1))
                                                .suggests((context, suggestionsBuilder) -> class_2172.method_9253(new String[]{"1t", "1s"}, suggestionsBuilder))
                                                .executes(context -> executeEntityStep(context.getSource(), class_2186.method_9317(context, "entities"), IntegerArgumentType.getInteger(context, "time"))))
                                )
                                .then(class_2170.method_9247("sprint")
                                        .then(class_2170.method_9247("stop").executes(context -> executeEntitySprint(context.getSource(), class_2186.method_9317(context, "entities"),0)))
                                        .then(class_2170.method_9244("time", class_2245.method_48287(1))
                                                .suggests((context, suggestionsBuilder) -> class_2172.method_9253(new String[]{"60s", "1d", "3d"}, suggestionsBuilder))
                                                .executes(context -> executeEntitySprint(context.getSource(), class_2186.method_9317(context, "entities"), IntegerArgumentType.getInteger(context, "time"))))
                                )
                        )
        )
                .then(
                        class_2170.method_9247("chunk")
                                .then(class_2170.method_9244("from", class_2264.method_9701())
                                        .then(chunkQuery)
                                        .then(chunkRate)
                                        .then(chunkUnfreeze)
                                        .then(chunkFreeze)
                                        .then(chunkStep)
                                        .then(chunkSprint)
                                        .then(class_2170.method_9244("to", class_2264.method_9701())
                                                .then(chunkQuery)
                                                .then(chunkRate)
                                                .then(chunkUnfreeze)
                                                .then(chunkFreeze)
                                                .then(chunkStep)
                                                .then(chunkSprint)
                                        )
                                        .then(class_2170.method_9247("radius")
                                                .then(class_2170.method_9244("radius", FloatArgumentType.floatArg(1))
                                                        .then(chunkQuery)
                                                        .then(chunkRate)
                                                        .then(chunkUnfreeze)
                                                        .then(chunkFreeze)
                                                        .then(chunkStep)
                                                        .then(chunkSprint)
                                                )
                                        )
                                )
                );
        return builder;
    }

    /**
     * @author Ninjaking312
     * @reason To round the rate and set server (not mainloop) rate
     */
    @Overwrite
    private static int executeRate(class_2168 source, float rate) {
        int roundRate = Math.round(rate); // can't actually accept decimals
        class_8915 tickManager = source.method_9211().method_54833();
        tickManager.tickRate$setServerRate(roundRate);
        tickManager.tickRate$sendUpdatePacket();
        send(source, () -> TickRateEvents.SERVER_RATE.invoker().onServerRate(roundRate));
        source.method_9226(() -> class_2561.method_43469("commands.tick.rate.success", roundRate), true);
        return roundRate;
    }

    /**
     * @author Ninjaking312
     * @reason To add distinction between mainloop and server tick rate
     */
    @Overwrite
    private static int executeQuery(class_2168 source) {
        class_8915 serverTickManager = source.method_9211().method_54833();
        if (serverTickManager.method_54670()) {
            source.method_9226(() -> class_2561.method_43471("commands.tick.status.sprinting"), false);
        }
        else {
            if (serverTickManager.method_54754()) {
                source.method_9226(() -> class_2561.method_43471("commands.tick.status.frozen"), false);
            } else if (serverTickManager.method_54750() < source.method_9211().method_54834()) {
                source.method_9226(() -> class_2561.method_43471("commands.tick.status.lagging"), false);
            } else {
                source.method_9226(() -> class_2561.method_43471("commands.tick.status.running"), false);
            }
        }

        source.method_9226(() -> class_2561.method_43470("Server's target tick rate: " + serverTickManager.tickRate$getServerRate() + " per second (" + format((long)((double) class_4802.field_33868 / (double)serverTickManager.tickRate$getServerRate())) + " mspt)"), false);
        source.method_9226(() -> class_2561.method_43470("Mainloop's target tick rate: " + serverTickManager.method_54748() + " per second (" + format((long)((double) class_4802.field_33868 / (double)serverTickManager.method_54748())) + " mspt)"), false);

        long[] ls = Arrays.copyOf(source.method_9211().method_54835(), source.method_9211().method_54835().length);
        Arrays.sort(ls);
        String p50 = format(ls[ls.length / 2]);
        String p95 = format(ls[(int)((double)ls.length * 0.95)]);
        String p99 = format(ls[(int)((double)ls.length * 0.99)]);
        float avg = source.method_9211().method_54832();
        source.method_9226(() -> class_2561.method_43470("Avg: %.1fms P50: %sms P95: %sms P99: %sms, sample: %s".formatted(avg,p50,p95,p99,ls.length)), false);
        return (int) serverTickManager.tickRate$getServerRate();
    }

    @Inject(method = "executeSprint", at = @At("TAIL"))
    private static void executeSprint(class_2168 source, int ticks, CallbackInfoReturnable<Integer> cir) {
        source.method_9211().method_54833().tickRate$sendUpdatePacket();
        send(source, () -> TickRateEvents.SERVER_SPRINT.invoker().onServerSprint(ticks));
    }

    @Inject(method = "executeFreeze", at = @At("TAIL"))
    private static void executeFreeze(class_2168 source, boolean frozen, CallbackInfoReturnable<Integer> cir) {
        source.method_9211().method_54833().tickRate$sendUpdatePacket();
        send(source, () -> TickRateEvents.SERVER_FREEZE.invoker().onServerFreeze(frozen));
    }

    @Inject(method = "executeStep", at = @At("TAIL"))
    private static void executeStep(class_2168 source, int ticks, CallbackInfoReturnable<Integer> cir) {
        source.method_9211().method_54833().tickRate$sendUpdatePacket();
        send(source, () -> TickRateEvents.SERVER_STEP.invoker().onServerStep(ticks));
    }

    @Inject(method = "executeStopStep", at = @At("RETURN"))
    private static void executeStopStep(class_2168 source, CallbackInfoReturnable<Integer> cir) {
        source.method_9211().method_54833().tickRate$sendUpdatePacket();
    }

    @Inject(method = "executeStopSprint", at = @At("RETURN"))
    private static void executeStopSprint(class_2168 source, CallbackInfoReturnable<Integer> cir) {
        source.method_9211().method_54833().tickRate$sendUpdatePacket();
    }


    @Unique
    private static int executeChunkRate(class_2168 source, List<class_1923> chunks, float rate) {
        if(chunkCheck(chunks, source)) return 0;

        int roundRate = Math.round(rate); // can't actually accept decimals
        class_8915 tickManager = source.method_9211().method_54833();
        tickManager.tickRate$setChunkRate(roundRate, source.method_9225(), chunks);
        tickManager.tickRate$sendUpdatePacket();

        send(source, () -> chunks.forEach(chunkPos -> TickRateEvents.CHUNK_RATE.invoker().onChunkRate(source.method_9225(), chunkPos, rate)));
        if(roundRate != 0) {
            source.method_9226(() -> class_2561.method_30163("Set tick rate of " + chunks.size() + " chunks to " + roundRate + " TPS."), false);
            return roundRate;
        }
        else {
            source.method_9226(() -> class_2561.method_43470("Reset the target rate of " + chunks.size() + " chunks."), false);
            return (int) tickManager.tickRate$getServerRate();
        }
    }

    @Unique
    private static int executeChunkQuery(class_2168 source, List<class_1923> chunks) {
        if(chunkCheck(chunks, source)) return 0;

        class_8915 tickManager = source.method_9211().method_54833();
        class_5250 text = class_2561.method_43470("The tick rates of the specified chunks are as follows:\n");
        float firstRate = tickManager.tickRate$getChunkRate(source.method_9225(), chunks.stream().findFirst().orElseThrow().method_8324());
        chunks.forEach(chunk -> text.method_27693("Chunk ").method_27693(chunk.toString()).method_27693(" - ").method_27693(String.valueOf(tickManager.tickRate$getChunkRate(source.method_9225(), chunk.method_8324()))).method_27693(" TPS").method_27693("\n"));
        text.method_10855().removeLast(); // to remove last \n
        source.method_9226(() -> text, false);
        return (int) firstRate;
    }

    @Unique
    private static int executeChunkFreeze(class_2168 source, List<class_1923> chunks, boolean frozen) {
        if(chunkCheck(chunks, source)) return 0;

        class_8915 tickManager = source.method_9211().method_54833();
        tickManager.tickRate$setChunkFrozen(frozen, source.method_9225(), chunks);
        if(frozen) source.method_9226(() -> class_2561.method_43470(chunks.size() + " chunks have been frozen."), false);
        else source.method_9226(() -> class_2561.method_43470(chunks.size() + " chunks have been unfrozen."), false);
        tickManager.tickRate$sendUpdatePacket();
        send(source, () -> chunks.forEach(chunkPos -> TickRateEvents.CHUNK_FREEZE.invoker().onChunkFreeze(source.method_9225(), chunkPos, frozen)));
        return 1;
    }

    @Unique
    private static int executeChunkStep(class_2168 source, List<class_1923> chunks, int steps) {
        if(chunkCheck(chunks, source)) return 0;

        class_8915 tickManager = source.method_9211().method_54833();
        boolean success = tickManager.tickRate$stepChunk(steps, source.method_9225(), chunks);
        if(success) {
            if(steps != 0) {
                source.method_9226(() -> class_2561.method_43470(chunks.size() + " chunks will step " + steps + " ticks."), false);
                send(source, () -> chunks.forEach(chunkPos -> TickRateEvents.CHUNK_STEP.invoker().onChunkStep(source.method_9225(), chunkPos, steps)));
            }
            else source.method_9226(() -> class_2561.method_43470(chunks.size() + " chunks have stopped stepping."), false);
        }
        else source.method_9226(() -> class_2561.method_43470("All of the specified chunks must be frozen first and cannot be sprinting!").method_54663(class_8012.field_46652), false);
        tickManager.tickRate$sendUpdatePacket();
        return success ? 1 : 0;
    }

    @Unique
    private static int executeChunkSprint(class_2168 source, List<class_1923> chunks, int ticks) {
        if(chunkCheck(chunks, source)) return 0;

        class_8915 tickManager = source.method_9211().method_54833();
        boolean success = tickManager.tickRate$sprintChunk(ticks, source.method_9225(), chunks);
        if(success) {
            if(ticks != 0) {
                source.method_9226(() -> class_2561.method_43470(chunks.size() + " chunks will sprint for " + ticks + " ticks."), false);
                send(source, () -> chunks.forEach(chunkPos -> TickRateEvents.CHUNK_SPRINT.invoker().onChunkSprint(source.method_9225(), chunkPos, ticks)));
            }
            else source.method_9226(() -> class_2561.method_43470(chunks.size() + " chunks have stopped sprinting."), false);
        }
        else source.method_9226(() -> class_2561.method_43470("All of the specified chunks must not be stepping!").method_54663(class_8012.field_46652), false);
        tickManager.tickRate$sendUpdatePacket();
        return success ? 1 : 0;
    }

    @Unique
    private static int executeEntityRate(class_2168 source, Collection<? extends class_1297> entities, float rate) {
        int roundRate = Math.round(rate); // can't actually accept decimals
        if(entityCheck(entities,source)) return 0;

        class_8915 tickManager = source.method_9211().method_54833();
        tickManager.tickRate$setEntityRate(roundRate, entities);
        tickManager.tickRate$sendUpdatePacket();
        send(source, () -> entities.forEach(entity -> TickRateEvents.ENTITY_RATE.invoker().onEntityRate(entity, rate)));
        if(roundRate != 0) {
            source.method_9226(() -> class_2561.method_30163("Set tick rate of " + entities.size() + " entities to " + roundRate + " TPS."), false);
            return roundRate;
        }
        else {
            source.method_9226(() -> class_2561.method_43470("Reset the tick rate of " + entities.size() + " entities."), false);
            return 0; // entities could be in different chunks, no reasonabe single int value can be returned, so 0 i guess.
        }
    }

    @Unique
    private static int executeEntityQuery(class_2168 source, Collection<? extends class_1297> entities) {
        class_8915 tickManager = source.method_9211().method_54833();
        class_5250 text = class_2561.method_43470("The tick rates of the specified entities are as follows:\n");
        float firstRate = tickManager.tickRate$getEntityRate(entities.stream().findFirst().orElseThrow());
        entities.forEach(entity -> text.method_10852(entity.method_5864().method_5897()).method_27693(" ").method_27693(entity.method_5820()).method_27693(" - ").method_27693(String.valueOf(tickManager.tickRate$getEntityRate(entity))).method_27693(" TPS").method_27693("\n"));
        text.method_10855().removeLast(); // to remove last \n
        source.method_9226(() -> text, false);
        return (int) firstRate;
    }

    @Unique
    private static int executeEntityFreeze(class_2168 source, Collection<? extends class_1297> entities, boolean frozen) {
        if(entityCheck(entities,source)) return 0;

        class_8915 tickManager = source.method_9211().method_54833();
        tickManager.tickRate$setEntityFrozen(frozen, entities);
        if(frozen) source.method_9226(() -> class_2561.method_43470(entities.size() + " entities have been frozen."), false);
        else source.method_9226(() -> class_2561.method_43470(entities.size() + " entities have been unfrozen."), false);
        tickManager.tickRate$sendUpdatePacket();
        send(source, () -> entities.forEach(entity -> TickRateEvents.ENTITY_FREEZE.invoker().onEntityFreeze(entity, frozen)));
        return 1;
    }

    @Unique
    private static int executeEntityStep(class_2168 source, Collection<? extends class_1297> entities, int steps) {
        if(entityCheck(entities,source)) return 0;

        class_8915 tickManager = source.method_9211().method_54833();
        boolean success = tickManager.tickRate$stepEntity(steps,entities);
        if(success) {
            if(steps != 0) {
                source.method_9226(() -> class_2561.method_43470(entities.size() + " entities will step " + steps + " ticks."), false);
                send(source, () -> entities.forEach(entity -> TickRateEvents.ENTITY_STEP.invoker().onEntityStep(entity, steps)));
            }
            else source.method_9226(() -> class_2561.method_43470(entities.size() + " entities have stopped stepping."), false);
        }
        else source.method_9226(() -> class_2561.method_43470("All of the specified entities must be frozen first and cannot be sprinting!").method_54663(class_8012.field_46652), false);
        tickManager.tickRate$sendUpdatePacket();
        return success ? 1 : 0;
    }

    @Unique
    private static int executeEntitySprint(class_2168 source, Collection<? extends class_1297> entities, int ticks) {
        if(entityCheck(entities,source)) return 0;

        class_8915 tickManager = source.method_9211().method_54833();
        boolean success = tickManager.tickRate$sprintEntity(ticks,entities);
        if(success) {
            if(ticks != 0) {
                source.method_9226(() -> class_2561.method_43470(entities.size() + " entities will sprint for " + ticks + " ticks."), false);
                send(source, () -> entities.forEach(entity -> TickRateEvents.ENTITY_SPRINT.invoker().onEntitySprint(entity, ticks)));
            }
            else source.method_9226(() -> class_2561.method_43470(entities.size() + " entities have stopped sprinting."), false);
        }
        else source.method_9226(() -> class_2561.method_43470("All of the specified entities must not be stepping!").method_54663(class_8012.field_46652), false);
        tickManager.tickRate$sendUpdatePacket();
        return success ? 1 : 0;
    }

    @Unique
    // returns true if any of the entities cannot be the command's target
    private static boolean entityCheck(Collection<? extends class_1297> entities, class_2168 source) {
        class_8915 tickManager = source.method_9211().method_54833();
        boolean match = entities.stream().anyMatch(e -> {
            if(e instanceof class_3222 player) return !tickManager.tickRate$hasClientMod(player);
            else return false;
        });
        if(match) source.method_9226(() -> class_2561.method_43470("Some of the specified entities are players that do not have TickRate mod installed on their client, so their tick rate cannot be manipulated.").method_54663(class_8012.field_46652), false);
        return match;
    }

    @Unique
    // returns true if any of the chunks cannot be the command's target (meaning they are unloaded)
    private static boolean chunkCheck(List<class_1923> chunks, class_2168 source) {
        boolean match = chunks.stream().anyMatch(chunkPos -> {
            class_2818 worldChunk = (class_2818) source.method_9225().method_8402(chunkPos.field_9181,chunkPos.field_9180,class_2806.field_12803,false);
            return worldChunk==null || worldChunk.method_12225() == class_3194.field_19334;
        });
        if(match) source.method_9226(() -> class_2561.method_43470("Some of the specified chunks are not loaded!").method_54663(class_8012.field_46652), false);
        return match;
    }

    /**
     * @param depth number of steps back up the command tree to get to the node right before the chunkOperations
     */
    @Unique
    private static List<class_1923> getChunks(CommandContext<class_2168> context, int depth) throws CommandSyntaxException {
        // CommandContext#getArgument is not used because it throws an Exception when not found, which is not great for performance
        String lastNode = context.getNodes().get(context.getNodes().size() - depth - 1).getNode().getName();
        return switch(lastNode) {
            case "from" -> {
                class_2265 from = class_2264.method_9702(context, "from");
                if (from.comp_638() < -30000000 || from.comp_639() < -30000000 || from.comp_638() >= 30000000 || from.comp_639() >= 30000000)
                    throw class_2262.field_10704.create();
                yield List.of(from.method_34873());
            }
            case "to" -> {
                // logic taken from ForceLoadCommand :)
                class_2265 from = class_2264.method_9702(context, "from");
                class_2265 to = class_2264.method_9702(context, "to");
                int minX = Math.min(from.comp_638(), to.comp_638());
                int minZ = Math.min(from.comp_639(), to.comp_639());
                int maxX = Math.max(from.comp_638(), to.comp_638());
                int maxZ = Math.max(from.comp_639(), to.comp_639());
                if (minX < -30000000 || minZ < -30000000 || maxX >= 30000000 || maxZ >= 30000000)
                    throw class_2262.field_10704.create();

                int chunkMinX = class_4076.method_18675(minX);
                int chunkMinZ = class_4076.method_18675(minZ);
                int chunkMaxX = class_4076.method_18675(maxX);
                int chunkMaxZ = class_4076.method_18675(maxZ);
                List<class_1923> chunks = new ArrayList<>();
                for(int chunkX = chunkMinX; chunkX <= chunkMaxX; chunkX++) {
                    for(int chunkZ = chunkMinZ; chunkZ <= chunkMaxZ; chunkZ++) {
                        chunks.add(new class_1923(chunkX, chunkZ));
                    }
                }
                yield chunks;
            }
            case "radius" -> {
                // logic taken from ForceLoadCommand :)
                class_2265 circleCentre = class_2264.method_9702(context, "from");
                float radius = FloatArgumentType.getFloat(context, "radius");
                float minX = circleCentre.comp_638() - radius;
                float minZ = circleCentre.comp_639() - radius;
                float maxX = circleCentre.comp_638() + radius;
                float maxZ = circleCentre.comp_639() + radius;
                if (minX < -30000000 || minZ < -30000000 || maxX >= 30000000 || maxZ >= 30000000)
                    throw class_2262.field_10704.create();

                int chunkMinX = class_4076.method_32204(minX);
                int chunkMinZ = class_4076.method_32204(minZ);
                int chunkMaxX = class_4076.method_32204(maxX);
                int chunkMaxZ = class_4076.method_32204(maxZ);
                List<class_1923> chunks = new ArrayList<>();
                for(int chunkX = chunkMinX; chunkX <= chunkMaxX; chunkX++) {
                    for(int chunkZ = chunkMinZ; chunkZ <= chunkMaxZ; chunkZ++) {
                        // https://www.geeksforgeeks.org/check-if-any-point-overlaps-the-given-circle-and-rectangle/
                        class_1923 chunkPos = new class_1923(chunkX, chunkZ);
                        class_4076 chunkSectionPos = class_4076.method_18681(chunkPos,0);
                        int X1 = chunkSectionPos.method_19527();
                        int X2 = chunkSectionPos.method_19530();
                        int Z1 = chunkSectionPos.method_19529();
                        int Z2 = chunkSectionPos.method_19532();
                        int Xc = circleCentre.comp_638();
                        int Zc = circleCentre.comp_639();

                        // find closest point of chunk to centre of circle
                        int Xn = Math.max(X1, Math.min(Xc, X2));
                        int Yn = Math.max(Z1, Math.min(Zc, Z2));

                        // find distance between nearest point and circle centre
                        int Dx = Xn - Xc;
                        int Dz = Yn - Zc;
                        if((Dx * Dx + Dz * Dz) <= radius * radius) chunks.add(chunkPos); // if overlap, add it
                    }
                }
                yield chunks;
            }
            default -> throw new IllegalStateException("Unexpected value: " + lastNode);
        };
    }

    @Unique
    private static void send(class_2168 source, Runnable runnable) {
        source.method_9211().method_63588(source.method_9211().method_16209(runnable));
    }

}
