package io.github.dennisochulor.tickrate.mixin.networking;

import net.minecraft.class_3248;
import net.minecraft.server.MinecraftServer;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.ModifyConstant;

@Mixin(class_3248.class)
public class ServerLoginNetworkHandlerMixin {

    @Shadow @Final MinecraftServer server;

    @ModifyConstant(method = "tick", constant = @Constant(intValue = 600))
    public int tick$tookTooLongToLogin(int constant) {
        // 30 seconds
        return (int) server.method_54833().method_54748() * 30;
    }

}
