package io.github.dennisochulor.tickrate.mixin.sound;

import io.github.dennisochulor.tickrate.TickRate;
import io.github.dennisochulor.tickrate.TickState;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_8915;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;

@Mixin(class_1297.class)
public class EntityMixin {

    @Shadow private class_1937 world;

    @ModifyVariable(method = "playSound", at = @At("HEAD"), argsOnly = true, ordinal = 1)
    public float playSound(float pitch) {
        if(world.method_8608()) return pitch;

        class_1297 entity = (class_1297) (Object) this;
        class_8915 tickManager = entity.method_5682().method_54833();
        TickState state = tickManager.tickRate$getEntityTickStateDeep(entity);
        if(state.sprinting()) return TickRate.MAX_SOUND_PITCH;
        else return pitch * (state.rate() / 20.0F);
    }

}
