package io.github.dennisochulor.tickrate.test;

import io.github.dennisochulor.tickrate.api.TickRateAPI;
import io.github.dennisochulor.tickrate.api.TickRateEvents;
import net.minecraft.class_1297;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.server.MinecraftServer;

import static io.github.dennisochulor.tickrate.TickRate.LOGGER;

/**
 * Set rate, then query it
 * Freeze, then step 5 secs
 * Step again and step stop
 * Sprint for 5 secs, then sprint stop
 * Unfreeze, then reset rate
 */
public final class Test {
    private Test() {}

    private static boolean registered = false;

    public static void test(MinecraftServer server) {
        register();

        Thread.ofVirtual().name("TickRateTest Thread").start(() -> {
            TickRateAPI api = TickRateAPI.getInstance();
            class_2168 src = server.method_3739();
            class_2170 commander = server.method_3734();

            LOGGER.info("STARTING TICKRATE **API** SERVER TEST");
            sleep(5);

            api.rateServer(10);
            LOGGER.info("{} TPS", api.queryServer());
            sleep(2);
            api.freezeServer(true);
            sleep(2);

            api.stepServer(50);
            sleep(7);
            api.stepServer(10000);
            sleep(2);
            api.stepServer(0);
            sleep(2);

            api.sprintServer(1000000);
            sleep(5);
            api.sprintServer(0);
            sleep(2);
            api.freezeServer(false);
            sleep(2);
            api.rateServer(20);
            sleep(2);
            LOGGER.info("FINISH TICKRATE **API** SERVER TEST");

            sleep(2);

            LOGGER.info("STARTING TICKRATE **COMMAND** SERVER TEST");
            sleep(5);

            commander.method_44252(src, "tick rate 10");
            commander.method_44252(src, "tick query");
            sleep(2);
            commander.method_44252(src, "tick freeze");
            sleep(2);

            commander.method_44252(src, "tick step 50");
            sleep(7);
            commander.method_44252(src, "tick step 10000");
            sleep(2);
            commander.method_44252(src, "tick step stop");
            sleep(2);

            commander.method_44252(src, "tick sprint 1000000");
            sleep(5);
            commander.method_44252(src, "tick sprint stop");
            sleep(2);
            commander.method_44252(src, "tick unfreeze");
            sleep(2);
            commander.method_44252(src, "tick rate 20");
            sleep(2);
            LOGGER.info("FINISH TICKRATE **COMMAND** SERVER TEST");
        });
    }

    public static void test(class_1297 testEntity) {
        register();

        Thread.ofVirtual().name("TickRateTest Thread").start(() -> {
            TickRateAPI api = TickRateAPI.getInstance();
            String uuid = testEntity.method_5845();
            class_2168 src = testEntity.method_5682().method_3739();
            class_2170 commander = testEntity.method_5682().method_3734();
            class_1937 world = testEntity.method_37908();
            class_1923 chunkPos = testEntity.method_31476();
            String strChunkPos = chunkPos.method_33940() + " " + chunkPos.method_33942();

            LOGGER.info("STARTING TICKRATE **API** TEST");
            sleep(5);

            LOGGER.info("ENTITY TEST");
            api.rateEntity(testEntity, 10);
            LOGGER.info("{} TPS", api.queryEntity(testEntity));
            sleep(2);
            api.freezeEntity(testEntity, true);
            sleep(2);

            api.stepEntity(testEntity, 50);
            sleep(7);
            api.stepEntity(testEntity, 10000);
            sleep(2);
            api.stepEntity(testEntity, 0);
            sleep(2);

            api.sprintEntity(testEntity, 1000000);
            sleep(5);
            api.sprintEntity(testEntity, 0);
            sleep(2);
            api.freezeEntity(testEntity, false);
            sleep(2);
            api.rateEntity(testEntity, 0.0f);
            sleep(5);

            LOGGER.info("CHUNK TESTS");
            api.rateChunk(world, chunkPos, 50);
            LOGGER.info("{} TPS", api.queryChunk(world, chunkPos));
            sleep(2);
            api.freezeChunk(world, chunkPos, true);
            sleep(2);

            api.stepChunk(world, chunkPos, 250);
            sleep(7);
            api.stepChunk(world, chunkPos, 10000);
            sleep(2);
            api.stepChunk(world, chunkPos, 0);
            sleep(2);

            api.sprintChunk(world, chunkPos, 1000000);
            sleep(5);
            api.sprintChunk(world, chunkPos, 0);
            sleep(2);
            api.freezeChunk(world, chunkPos, false);
            sleep(2);
            api.rateChunk(world, chunkPos, 0.0f);
            sleep(2);
            LOGGER.info("FINISH TICKRATE **API** TEST");

            sleep(2);

            LOGGER.info("STARTING TICKRATE **COMMAND** TEST");
            sleep(5);

            LOGGER.info("ENTITY TEST");
            commander.method_44252(src, "tick entity " + uuid + " rate 10");
            commander.method_44252(src, "tick entity " + uuid + " query");
            sleep(2);
            commander.method_44252(src, "tick entity " + uuid + " freeze");
            sleep(2);

            commander.method_44252(src, "tick entity " + uuid + " step 50");
            sleep(7);
            commander.method_44252(src, "tick entity " + uuid + " step 10000");
            sleep(2);
            commander.method_44252(src, "tick entity " + uuid + " step stop");
            sleep(2);

            commander.method_44252(src, "tick entity " + uuid + " sprint 1000000");
            sleep(5);
            commander.method_44252(src, "tick entity " + uuid + " sprint stop");
            sleep(2);
            commander.method_44252(src, "tick entity " + uuid + " unfreeze");
            sleep(2);
            commander.method_44252(src, "tick entity " + uuid + " rate reset");
            sleep(5);

            LOGGER.info("CHUNK TESTS");
            commander.method_44252(src, "tick chunk " + strChunkPos + " rate 50");
            commander.method_44252(src, "tick chunk " + strChunkPos + " query");
            sleep(2);
            commander.method_44252(src, "tick chunk " + strChunkPos + " freeze");
            sleep(2);

            commander.method_44252(src, "tick chunk " + strChunkPos + " step 250");
            sleep(7);
            commander.method_44252(src, "tick chunk " + strChunkPos + " step 10000");
            sleep(2);
            commander.method_44252(src, "tick chunk " + strChunkPos + " step stop");
            sleep(2);

            commander.method_44252(src, "tick chunk " + strChunkPos + " sprint 1000000");
            sleep(5);
            commander.method_44252(src, "tick chunk " + strChunkPos + " sprint stop");
            sleep(2);
            commander.method_44252(src, "tick chunk " + strChunkPos + " unfreeze");
            sleep(2);
            commander.method_44252(src, "tick chunk " + strChunkPos + " rate reset");
            sleep(2);
            LOGGER.info("FINISH TICKRATE **COMMAND** TEST");
        });
    }

    private static void sleep(int seconds) {
        try {
            Thread.sleep(seconds * 1000L);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private static void register() {
        if(!registered) { // only do it once
            TickRateEvents.SERVER_RATE.register(rate -> LOGGER.info("server rate {}", rate));
            TickRateEvents.SERVER_FREEZE.register(freeze -> LOGGER.info("server freeze {}", freeze));
            TickRateEvents.SERVER_STEP.register(stepTicks -> LOGGER.info("server step {}", stepTicks));
            TickRateEvents.SERVER_SPRINT.register(sprintTicks -> LOGGER.info("server sprint {}", sprintTicks));

            TickRateEvents.ENTITY_RATE.register((entity, rate) -> LOGGER.info("{} rate {}", entity.method_5845(), rate));
            TickRateEvents.ENTITY_FREEZE.register((entity, freeze) -> LOGGER.info("{} freeze {}", entity.method_5845(), freeze));
            TickRateEvents.ENTITY_STEP.register((entity, stepTicks) -> LOGGER.info("{} step {}", entity.method_5845(), stepTicks));
            TickRateEvents.ENTITY_SPRINT.register((entity, sprintTicks) -> LOGGER.info("{} sprint {}", entity.method_5845(), sprintTicks));

            TickRateEvents.CHUNK_RATE.register((world, chunkPos, rate) -> LOGGER.info("{} {} rate {}", world.method_27983().method_29177(), chunkPos, rate));
            TickRateEvents.CHUNK_FREEZE.register((world, chunkPos, freeze) -> LOGGER.info("{} {} freeze {}", world.method_27983().method_29177(), chunkPos, freeze));
            TickRateEvents.CHUNK_STEP.register((world, chunkPos, stepTicks) -> LOGGER.info("{} {} step {}", world.method_27983().method_29177(), chunkPos, stepTicks));
            TickRateEvents.CHUNK_SPRINT.register((world, chunkPos, sprintTicks) -> LOGGER.info("{} {} sprint {}", world.method_27983().method_29177(), chunkPos, sprintTicks));
            registered = true;
        }
    }

}
