package io.github.dennisochulor.tickrate;

import net.minecraft.class_2561;
import net.minecraft.class_310;

public class TickIndicator {

    private TickIndicator() {}

    private static boolean enabled = false;

    public static boolean toggle() {
        enabled = !enabled;
        return enabled;
    }

    public static boolean isEnabled() {
        return enabled;
    }

    public static void tick() {
        if(!TickIndicator.isEnabled() || !TickRateClientManager.serverHasMod()) return;
        class_310 client = class_310.method_1551();
        TickState chunkState = TickRateClientManager.getChunkState(client.field_1724.method_31476());
        int chunkRate = chunkState.rate();
        TickState entityState = client.field_1692!=null ? TickRateClientManager.getEntityState(client.field_1692) : null;
        int entityRate = (entityState!=null ? entityState.rate() : 0);

        String chunkStateStr = "";
        String entityStateStr = "";
        if(chunkState.sprinting())
            chunkStateStr = " (Sprinting)";
        else if(chunkState.stepping())
            chunkStateStr = " (Stepping)";
        else if(chunkState.frozen())
            chunkStateStr = " (Frozen)";

        if(entityState != null) {
            if(entityState.sprinting())
                entityStateStr = " (Sprinting)";
            else if(entityState.stepping())
                entityStateStr = " (Stepping)";
            else if(entityState.frozen())
                entityStateStr = " (Frozen)";
        }

        client.field_1724.method_7353(class_2561.method_43470("Entity: " + entityRate + " TPS" + entityStateStr + "       Chunk: " + chunkRate + " TPS" + chunkStateStr), true);
    }

}
