package io.github.dennisochulor.tickrate;

import static io.github.dennisochulor.tickrate.TickRateAttachments.*;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1923;
import net.minecraft.class_310;
import net.minecraft.class_8921;
import net.minecraft.class_9779;

public class TickRateClientManager {

    private TickRateClientManager() {}

    private static boolean serverHasMod = false;
    private static final Map<Integer, TickDeltaInfo> entityCache = new HashMap<>();
    private static final Map<Long, TickDeltaInfo> chunkCache = new HashMap<>();

    // called in RenderTickCounterDynamicMixin
    public static void clearCache() {
        entityCache.clear();
        chunkCache.clear();
    }

    public static void setServerHasMod(boolean serverHasMod) {
        TickRateClientManager.serverHasMod = serverHasMod;
    }

    public static boolean serverHasMod() {
        return serverHasMod;
    }

    public static float getMillisPerServerTick() {
        return 1000.0f / getServerState().rate();
    }

    public static TickDeltaInfo getEntityTickDelta(class_1297 entity) {
        TickDeltaInfo info = entityCache.get(entity.method_5628());
        if(info != null) return info;

        class_9779 renderTickCounter = class_310.method_1551().method_60646();
        TickState serverState = getServerState();

        if(!serverHasMod) info = TickDeltaInfo.ofServer(false);
        else if(class_310.method_1551().method_1493()) info = TickDeltaInfo.NO_ANIMATE;
        else if(entity instanceof class_1657 && serverState.frozen()) info = TickDeltaInfo.ofServer(true); // tick freeze doesn't affect players
        else if(entity.method_5765()) info = getEntityTickDelta(entity.method_5668());
        else {
            // client's own player OR entities where client player is a passenger can go above 20TPS limit
            boolean cappedAt20TPS = !(entity==class_310.method_1551().field_1724) && !entity.method_5626(class_310.method_1551().field_1724);
            TickState state = getEntityState(entity); // this also handles passenger entities
            if(state.sprinting()) // animate at max 20 TPS but for client player we don't know the TPS, so just say 100 :P
                info = cappedAt20TPS ? renderTickCounter.tickRate$getSpecificTickDeltaInfo(20) : renderTickCounter.tickRate$getClientPlayerTickDeltaInfo(100);
            else if(state.frozen() && !state.stepping()) info = TickDeltaInfo.NO_ANIMATE;
            else if(!cappedAt20TPS) info = renderTickCounter.tickRate$getClientPlayerTickDeltaInfo(state.rate());
            else info = renderTickCounter.tickRate$getSpecificTickDeltaInfo(state.rate());
        }

        entityCache.put(entity.method_5628(), info);
        return info;
    }

    public static TickDeltaInfo getChunkTickDelta(class_1923 chunkPos) {
        TickDeltaInfo info = chunkCache.get(chunkPos.method_8324());
        if(info != null) return info;

        class_9779 renderTickCounter = class_310.method_1551().method_60646();
        if(!serverHasMod) info = TickDeltaInfo.ofServer(false);
        else if(class_310.method_1551().method_1493()) info = TickDeltaInfo.NO_ANIMATE;
        else {
            TickState state = getChunkState(chunkPos);
            if(state.sprinting()) info = renderTickCounter.tickRate$getSpecificTickDeltaInfo(20); // animate at max 20 TPS
            else if(state.frozen() && !state.stepping()) info = TickDeltaInfo.NO_ANIMATE;
            else info = renderTickCounter.tickRate$getSpecificTickDeltaInfo(state.rate());
        }

        chunkCache.put(chunkPos.method_8324(), info);
        return info;
    }

    public static TickState getEntityState(class_1297 entity) {
        if(entity.method_5765()) return getEntityState(entity.method_5668()); // all passengers will follow TPS of the root entity
        TickState state = entity.getAttached(TICK_STATE);
        if(state == null) return getChunkState(entity.method_31476());

        int rate = state.rate();
        TickState serverState = getServerState();
        if(rate == -1) rate = getChunkState(entity.method_31476()).rate();
        if(serverState.frozen() || serverState.sprinting() || serverState.stepping())
            return serverState.withRate(serverState.stepping() ? serverState.rate() : rate);
        return state.withRate(rate);
    }

    /**
     * World is assumed to be the {@link class_310#field_1687}
     */
    public static TickState getChunkState(class_1923 chunkPos) {
        if(!serverHasMod) return getServerState();
        TickState state = class_310.method_1551().field_1687.method_8497(chunkPos.field_9181, chunkPos.field_9180).getAttached(TICK_STATE);
        if(state == null) return getServerState();

        int rate = state.rate();
        TickState serverState = getServerState();
        if(state.rate() == -1) rate = serverState.rate();
        if(serverState.frozen() || serverState.sprinting() || serverState.stepping())
            return serverState.withRate(serverState.stepping() ? serverState.rate() : rate);
        return state.withRate(rate);
    }

    public static TickState getServerState() {
        if(!serverHasMod) {
            class_8921 tickManager = class_310.method_1551().field_1687.method_54719();
            return new TickState((int) tickManager.method_54748(),tickManager.method_54754(),tickManager.method_54752(),false); // Client does not have any sprint info
        }
        return class_310.method_1551().field_1687.getAttached(TICK_STATE_SERVER);
    }

}
