package io.github.dennisochulor.tickrate.injected_interface;

import io.github.dennisochulor.tickrate.TickState;
import net.fabricmc.fabric.api.attachment.v1.AttachmentTarget;
import net.minecraft.class_1297;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2818;
import java.util.Collection;

public interface TickRateTickManager {

    default void tickRate$serverStarting() {}
    default void tickRate$serverStarted() {}
    default void tickRate$saveData() {}

    default boolean tickRate$shouldTickEntity(class_1297 entity) {return false;}
    default boolean tickRate$shouldTickChunk(class_1937 world, class_1923 chunkPos) {return false;}
    default boolean tickRate$shouldTickChunk(class_2818 chunk) {return false;}
    default boolean tickRate$shouldTickServer() {return false;}

    default void tickRate$updateLoad(AttachmentTarget attachmentTarget, boolean loaded) {}
    default void tickRate$setServerRate(int rate) {}
    default int tickRate$getServerRate() {return 0;}
    default void tickRate$ticked() {}
    default boolean tickRate$isIndividualSprint() {return false;}
    default boolean tickRate$isServerSprint() {return false;}

    default void tickRate$setRate(int rate, Collection<? extends AttachmentTarget> targets) {}
    default void tickRate$setFrozen(boolean frozen, Collection<? extends AttachmentTarget> targets) {}
    default boolean tickRate$step(int steps, Collection<? extends AttachmentTarget> targets) {return false;}
    default boolean tickRate$sprint(int ticks, Collection<? extends AttachmentTarget> targets) {return false;}

    default int tickRate$getEntityRate(class_1297 entity) {return 0;}
    default int tickRate$getChunkRate(class_2818 chunk) {return 0;}

    default TickState tickRate$getChunkTickStateShallow(class_1937 world, class_1923 chunkPos) {return null;}
    default TickState tickRate$getEntityTickStateShallow(class_1297 entity) {return null;}
    default TickState tickRate$getChunkTickStateDeep(class_1937 world, class_1923 chunkPos) {return null;}
    default TickState tickRate$getEntityTickStateDeep(class_1297 entity) {return null;}
    default TickState tickRate$getServerTickState() {return null;}

}
