package io.github.dennisochulor.tickrate.mixin.chunk;

import io.github.dennisochulor.tickrate.injected_interface.TickRateChunkTickScheduler;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.*;

import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import net.minecraft.class_6755;
import net.minecraft.class_6760;

@Mixin(class_6755.class)
public abstract class ChunkTickSchedulerMixin<T> implements TickRateChunkTickScheduler<T> {

    @Shadow @Final private Queue<class_6760<T>> tickQueue;
    @Shadow public abstract class_6760<T> peekNextTick();

    @Shadow public abstract @Nullable class_6760<T> pollNextTick();

    @Unique private long chunkTime;
    @Unique private long serverTime; // actually should be worldTime
    @Unique private boolean isFollowingServerTick = true;

    @ModifyVariable(method = "scheduleTick", at = @At("HEAD"), argsOnly = true)
    public class_6760<T> scheduleTick(class_6760<T> orderedTick) {
        if(!isFollowingServerTick) {
            long newTriggerTick = chunkTime + (orderedTick.comp_254()-serverTime);
            return new class_6760<>(orderedTick.comp_252(),orderedTick.comp_253(),newTriggerTick,orderedTick.comp_256());
        }
        return orderedTick;
    }

    @ModifyVariable(method = "toNbt(JLjava/util/function/Function;)Lnet/minecraft/nbt/NbtList;", at = @At(value = "INVOKE",
        target = "Lnet/minecraft/world/tick/Tick;orderedTickToNbt(Lnet/minecraft/world/tick/OrderedTick;Ljava/util/function/Function;J)Lnet/minecraft/nbt/NbtCompound;"))
    public class_6760<T> collectTicks(class_6760<T> orderedTick) {
        if(isFollowingServerTick) return orderedTick;
        else {
            long newTriggerTick = serverTime + (orderedTick.comp_254() - chunkTime);
            return new class_6760<>(orderedTick.comp_252(),orderedTick.comp_253(),newTriggerTick,orderedTick.comp_256());
        }
    }

    @Unique
    public void tickRate$setServerTime(long time) {
        serverTime = time;
    }

    @Unique
    public List<class_6760<T>> tickRate$tick() {
        chunkTime++;
        List<class_6760<T>> list = new ArrayList<>();
        while(peekNextTick() != null) {
            if(peekNextTick().comp_254() <= chunkTime) list.add(pollNextTick());
            else break;
        }
        return list;
    }

    @Unique
    public void tickRate$toggleMode(boolean followServerTick) {
        if(!followServerTick && isFollowingServerTick) {
            isFollowingServerTick = false;
            chunkTime = serverTime-1;
        }
        else if(followServerTick && !isFollowingServerTick) {
            isFollowingServerTick = true;
            List<class_6760<T>> list = new ArrayList<>();
            tickQueue.forEach(orderedTick -> {
                long newTriggerTick = serverTime + (orderedTick.comp_254() - chunkTime);
                class_6760<T> orderedTick1 = new class_6760<>(orderedTick.comp_252(),orderedTick.comp_253(),newTriggerTick,orderedTick.comp_256());
                list.add(orderedTick1);
            });
            tickQueue.clear();
            tickQueue.addAll(list);
        }
    }



}
