package io.github.dennisochulor.tickrate.mixin.client.tick;

import io.github.dennisochulor.tickrate.TickIndicator;
import io.github.dennisochulor.tickrate.TickRateClientManager;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.function.BooleanSupplier;
import net.minecraft.class_1060;
import net.minecraft.class_310;
import net.minecraft.class_315;
import net.minecraft.class_638;
import net.minecraft.class_702;
import net.minecraft.class_746;
import net.minecraft.class_757;
import net.minecraft.class_761;
import net.minecraft.class_8921;
import net.minecraft.class_9779;

@Mixin(class_310.class)
public abstract class MinecraftClientMixin {

	@Shadow public abstract class_9779 getRenderTickCounter();
	@Shadow public class_638 world;
	@Shadow public class_746 player;
	@Shadow @Final public class_702 particleManager;
	@Shadow @Final public class_315 options;
	@Shadow protected abstract void openChatScreen(String text);
	@Shadow protected abstract boolean shouldTick();
	@Shadow @Final private class_1060 textureManager;
	@Shadow private volatile boolean paused;
	@Shadow @Final public class_761 worldRenderer;
	@Shadow @Final public class_757 gameRenderer;

	@Redirect(method = "getTargetMillisPerTick", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/tick/TickManager;getMillisPerTick()F"))
	private float getMillisPerTick(class_8921 instance) {
		if(TickRateClientManager.serverHasMod()) return TickRateClientManager.getMillisPerServerTick();
		else return instance.method_54749();
	}

	@Inject(method = "render", at = @At(value = "INVOKE", target = "Lnet/minecraft/util/profiler/Profiler;pop()V", ordinal = 1, shift = At.Shift.BEFORE))
	private void render(boolean tick, CallbackInfo ci) {
		if(!TickRateClientManager.serverHasMod()) return;
		class_9779 renderTickCounter = getRenderTickCounter();
		int playerChunkI = TickRateClientManager.getChunkTickDelta(this.player.method_31476()).i();
		for(int i=0; i<10; i++) { // these things need to tick all 10 times
			renderTickCounter.tickRate$setMovingI(i);
			this.world.method_18116();
			this.particleManager.method_3057();

			if(this.shouldTick() && i < playerChunkI) { // animate according to the player's chunk (not the player themself)
				this.textureManager.method_4622();
				this.world.method_2941(this.player.method_31477(), this.player.method_31478(), this.player.method_31479());
			}

			if(!this.paused && i < renderTickCounter.tickRate$getI()) { // tick according to server, not the player
				this.world.method_54719().method_54755();
				if(this.world.method_54719().method_54751()) this.worldRenderer.method_22713(this.gameRenderer.method_19418());
				this.world.method_8441(() -> true);
				this.worldRenderer.method_3252();
			}
		}

		while (this.options.field_1890.method_1436()) { // to allow player to chat even when FROZEN
			this.openChatScreen("");
		}
		TickIndicator.tick();
	}

	@ModifyVariable(method = "render", at = @At(value = "STORE"), ordinal = 0)
	private int render(int i) { // make the clientTick follow the player's tick rate (which may differ from the server)
		if(!TickRateClientManager.serverHasMod()) return i;
		return TickRateClientManager.getEntityTickDelta(this.player).i();
	}

	@Redirect(method = "tick", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/world/ClientWorld;tickEntities()V"))
	public void tick$tickEntities(class_638 instance) {
		if(!TickRateClientManager.serverHasMod()) instance.method_18116();
		// otherwise NO-OP
	}

	@Redirect(method = "tick", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/particle/ParticleManager;tick()V"))
	public void tick$tickParticles(class_702 instance) {
		if(!TickRateClientManager.serverHasMod()) instance.method_3057();
		// otherwise NO-OP
	}

	@Redirect(method = "tick", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/texture/TextureManager;tick()V"))
	public void tick$tickTextures(class_1060 instance) {
		if(!TickRateClientManager.serverHasMod()) instance.method_4622();
		// otherwise NO-OP
	}

	@Redirect(method = "tick", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/render/WorldRenderer;tick()V"))
	public void tick$tickWorldRenderer(class_761 instance) {
		if(!TickRateClientManager.serverHasMod()) instance.method_3252();
		// otherwise NO-OP
	}

	@Redirect(method = "tick", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/world/ClientWorld;tick(Ljava/util/function/BooleanSupplier;)V"))
	public void tick$tickWorld(class_638 instance, BooleanSupplier shouldKeepTicking) {
		if(!TickRateClientManager.serverHasMod()) instance.method_8441(shouldKeepTicking);
		// otherwise NO-OP
	}

	@Redirect(method = "tick", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/tick/TickManager;step()V"))
	public void tick$stepTickManager(class_8921 instance) {
		if(!TickRateClientManager.serverHasMod()) instance.method_54755();
		// otherwise NO-OP
	}

	@Redirect(method = "tick", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/world/ClientWorld;doRandomBlockDisplayTicks(III)V"))
	public void tick$randomBlockDisplayTicks(class_638 instance, int centerX, int centerY, int centerZ) {
		if(!TickRateClientManager.serverHasMod()) instance.method_2941(centerX,centerY,centerZ);
		// otherwise NO-OP
	}

}