package io.github.dennisochulor.tickrate.mixin.core;

import net.minecraft.class_2991;
import net.minecraft.class_8915;
import net.minecraft.server.MinecraftServer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.*;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(MinecraftServer.class)
public abstract class MinecraftServerMixin {

	@Shadow public abstract class_8915 getTickManager();

	@Inject(method = "runServer", at= @At(value = "INVOKE", target = "Lnet/minecraft/util/profiling/jfr/FlightProfiler;onTick(F)V", shift = At.Shift.AFTER, args = "ldc="))
	private void runServer$tickTail(CallbackInfo ci) {
		getTickManager().tickRate$ticked();
	}

	@Redirect(method = "tickWorlds", at = @At(value = "INVOKE", target = "Lnet/minecraft/server/function/CommandFunctionManager;tick()V"))
	protected void tickWorlds$CommandTick(class_2991 instance) {
		if(getTickManager().tickRate$shouldTickServer()) instance.method_18699();
	}

	@Redirect(method = "runServer", at = @At(value = "INVOKE", target = "Lnet/minecraft/server/ServerTickManager;sprint()Z"))
	private boolean runServer$sprint(class_8915 instance) {
		if(instance.tickRate$isServerSprint()) return instance.method_54679();
		return instance.tickRate$isIndividualSprint();
	}

}