package io.github.dennisochulor.tickrate.mixin.sound;

import com.llamalad7.mixinextras.sugar.Local;
import io.github.dennisochulor.tickrate.TickRate;
import io.github.dennisochulor.tickrate.TickState;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_6880;
import net.minecraft.class_8915;
import net.minecraft.server.MinecraftServer;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;

@Mixin(class_3218.class)
public class ServerWorldMixin {

    @Shadow @Final private MinecraftServer server;

    /**
     * Entity pitch change is handled by EntityMixin already
     */
    @ModifyVariable(method = "playSound(Lnet/minecraft/entity/player/PlayerEntity;DDDLnet/minecraft/registry/entry/RegistryEntry;Lnet/minecraft/sound/SoundCategory;FFJ)V", at = @At("HEAD"), argsOnly = true, ordinal = 1)
    public float playSound(float pitch, @Local(argsOnly = true) class_1657 player, @Local(argsOnly = true, ordinal = 0) double x, @Local(argsOnly = true, ordinal = 1) double y, @Local(argsOnly = true, ordinal = 2) double z, @Local(argsOnly = true) class_3419 category, @Local(argsOnly = true) class_6880<class_3414> event) {
        class_8915 tickManager = server.method_54833();
        return switch(category) {
            case field_15250,field_15253,field_15247,field_15246,field_15254,field_15251 -> pitch;
            case field_15248 -> {
                TickState state;
                if(player != null)
                    state = tickManager.tickRate$getEntityTickStateDeep(player);
                else
                    state = tickManager.tickRate$getChunkTickStateDeep((class_1937) (Object) this, new class_1923(new class_2338(class_3532.method_15357(x), class_3532.method_15357(y), class_3532.method_15357(z))));
                if(state.sprinting()) yield TickRate.MAX_SOUND_PITCH;
                else yield pitch * (state.rate() / 20.0F);
            }
            case field_15252 -> {
                TickState state = tickManager.tickRate$getServerTickState();
                if(state.sprinting()) yield TickRate.MAX_SOUND_PITCH;
                else yield pitch * (state.rate() / 20.0F);
            }
            case field_15245, field_15256 -> {
                TickState state = tickManager.tickRate$getChunkTickStateDeep((class_1937)(Object)this, new class_1923(new class_2338(class_3532.method_15357(x), class_3532.method_15357(y), class_3532.method_15357(z))));
                if(state.sprinting()) yield TickRate.MAX_SOUND_PITCH;
                else yield pitch * (state.rate() / 20.0F);
            }
        };
    }

    @ModifyVariable(method = "playSoundFromEntity", at = @At("HEAD"), argsOnly = true, ordinal = 1)
    public float playSoundFromEntity(float pitch, @Local(argsOnly = true) class_1297 entity) { // never called apparently
        TickState state = server.method_54833().tickRate$getEntityTickStateDeep(entity);
        if(state.sprinting()) return TickRate.MAX_SOUND_PITCH;
        else return pitch * (state.rate() / 20.0F);
    }

}
