/*
 * Decompiled with CFR 0.152.
 */
package io.github.dennisochulor.tickrate;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import io.github.dennisochulor.tickrate.TickRateAttachments;
import io.github.dennisochulor.tickrate.TickRateHelloPayload;
import io.github.dennisochulor.tickrate.api_impl.TickRateAPIImpl;
import io.github.dennisochulor.tickrate.test.Test;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.attachment.v1.AttachmentTarget;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.entity.event.v1.ServerPlayerEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerChunkEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerEntityEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_3194;
import net.minecraft.class_8710;
import net.minecraft.class_8915;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TickRate
implements ModInitializer {
    public static final String MOD_ID = "tickrate";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"tickrate");
    public static final float MAX_SOUND_PITCH = 2.0f;
    public static final float MIN_SOUND_PITCH = 0.25f;

    public void onInitialize() {
        LOGGER.info("Initializing tickrate!");
        TickRateAttachments.init();
        PayloadTypeRegistry.playS2C().register(TickRateHelloPayload.ID, TickRateHelloPayload.CODEC);
        PayloadTypeRegistry.playC2S().register(TickRateHelloPayload.ID, TickRateHelloPayload.CODEC);
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> sender.sendPacket((class_8710)new TickRateHelloPayload()));
        ServerPlayNetworking.registerGlobalReceiver(TickRateHelloPayload.ID, (payload, context) -> {});
        ServerLifecycleEvents.SERVER_STARTING.register(server -> {
            server.method_54833().tickRate$serverStarting();
            TickRateAPIImpl.init(server);
        });
        ServerLifecycleEvents.SERVER_STARTED.register(server -> server.method_54833().tickRate$serverStarted());
        ServerLifecycleEvents.SERVER_STOPPED.register(server -> TickRateAPIImpl.uninit());
        ServerLifecycleEvents.AFTER_SAVE.register((server, flush, force) -> server.method_54833().tickRate$saveData());
        ServerEntityEvents.ENTITY_LOAD.register((entity, serverWorld) -> {
            class_8915 tickManager = (class_8915)serverWorld.method_54719();
            tickManager.tickRate$updateLoad((AttachmentTarget)entity, true);
        });
        ServerPlayerEvents.AFTER_RESPAWN.register((oldPlayer, newPlayer, alive) -> {
            class_8915 tickManager = (class_8915)oldPlayer.method_37908().method_54719();
            tickManager.tickRate$updateLoad((AttachmentTarget)oldPlayer, true);
        });
        ServerEntityEvents.ENTITY_UNLOAD.register((entity, serverWorld) -> {
            class_8915 tickManager = (class_8915)serverWorld.method_54719();
            tickManager.tickRate$updateLoad((AttachmentTarget)entity, false);
        });
        ServerChunkEvents.CHUNK_LEVEL_TYPE_CHANGE.register((serverWorld, worldChunk, oldLevelType, newLevelType) -> {
            class_8915 tickManager = (class_8915)serverWorld.method_54719();
            if (oldLevelType == class_3194.field_19334 && newLevelType.method_14014(class_3194.field_44855)) {
                tickManager.tickRate$updateLoad((AttachmentTarget)worldChunk, true);
            } else if (newLevelType == class_3194.field_19334) {
                tickManager.tickRate$updateLoad((AttachmentTarget)worldChunk, false);
            }
        });
        if (FabricLoader.getInstance().isDevelopmentEnvironment()) {
            CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"tickratetest").then(class_2170.method_9244((String)"entity", (ArgumentType)class_2186.method_9309()).executes(context -> {
                Test.test(class_2186.method_9313((CommandContext)context, (String)"entity"));
                return 1;
            }))).then(class_2170.method_9247((String)"server").executes(context -> {
                Test.test(((class_2168)context.getSource()).method_9211());
                return 1;
            }))));
        }
    }
}

