/*
 * Decompiled with CFR 0.152.
 */
package io.github.dennisochulor.tickrate;

import io.github.dennisochulor.tickrate.TickDeltaInfo;
import io.github.dennisochulor.tickrate.TickRateAttachments;
import io.github.dennisochulor.tickrate.TickState;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1923;
import net.minecraft.class_310;
import net.minecraft.class_8921;
import net.minecraft.class_9779;

@Environment(value=EnvType.CLIENT)
public class TickRateClientManager {
    private static boolean serverHasMod = false;
    private static final Map<Integer, TickDeltaInfo> entityCache = new HashMap<Integer, TickDeltaInfo>();
    private static final Map<Long, TickDeltaInfo> chunkCache = new HashMap<Long, TickDeltaInfo>();

    private TickRateClientManager() {
    }

    public static void clearCache() {
        entityCache.clear();
        chunkCache.clear();
    }

    public static void setServerHasMod(boolean serverHasMod) {
        TickRateClientManager.serverHasMod = serverHasMod;
    }

    public static boolean serverHasMod() {
        return serverHasMod;
    }

    public static float getMillisPerServerTick() {
        return 1000.0f / (float)TickRateClientManager.getServerState().rate();
    }

    public static TickDeltaInfo getEntityTickDelta(class_1297 entity) {
        TickDeltaInfo info = entityCache.get(entity.method_5628());
        if (info != null) {
            return info;
        }
        class_9779 renderTickCounter = class_310.method_1551().method_60646();
        TickState serverState = TickRateClientManager.getServerState();
        if (!serverHasMod) {
            info = TickDeltaInfo.ofServer(false);
        } else if (class_310.method_1551().method_1493()) {
            info = TickDeltaInfo.NO_ANIMATE;
        } else if (entity instanceof class_1657 && serverState.frozen()) {
            info = TickDeltaInfo.ofServer(true);
        } else if (entity.method_5765()) {
            info = TickRateClientManager.getEntityTickDelta(entity.method_5668());
        } else {
            boolean cappedAt20TPS = entity != class_310.method_1551().field_1724 && !entity.method_5626((class_1297)class_310.method_1551().field_1724);
            TickState state = TickRateClientManager.getEntityState(entity);
            info = state.sprinting() ? (cappedAt20TPS ? renderTickCounter.tickRate$getSpecificTickDeltaInfo(20) : renderTickCounter.tickRate$getClientPlayerTickDeltaInfo(100)) : (state.frozen() && !state.stepping() ? TickDeltaInfo.NO_ANIMATE : (!cappedAt20TPS ? renderTickCounter.tickRate$getClientPlayerTickDeltaInfo(state.rate()) : renderTickCounter.tickRate$getSpecificTickDeltaInfo(state.rate())));
        }
        entityCache.put(entity.method_5628(), info);
        return info;
    }

    public static TickDeltaInfo getChunkTickDelta(class_1923 chunkPos) {
        TickState state;
        TickDeltaInfo info = chunkCache.get(chunkPos.method_8324());
        if (info != null) {
            return info;
        }
        class_9779 renderTickCounter = class_310.method_1551().method_60646();
        info = !serverHasMod ? TickDeltaInfo.ofServer(false) : (class_310.method_1551().method_1493() ? TickDeltaInfo.NO_ANIMATE : ((state = TickRateClientManager.getChunkState(chunkPos)).sprinting() ? renderTickCounter.tickRate$getSpecificTickDeltaInfo(20) : (state.frozen() && !state.stepping() ? TickDeltaInfo.NO_ANIMATE : renderTickCounter.tickRate$getSpecificTickDeltaInfo(state.rate()))));
        chunkCache.put(chunkPos.method_8324(), info);
        return info;
    }

    public static TickState getEntityState(class_1297 entity) {
        if (entity.method_5765()) {
            return TickRateClientManager.getEntityState(entity.method_5668());
        }
        TickState state = (TickState)entity.getAttached(TickRateAttachments.TICK_STATE);
        if (state == null) {
            return TickRateClientManager.getChunkState(entity.method_31476());
        }
        int rate = state.rate();
        TickState serverState = TickRateClientManager.getServerState();
        if (rate == -1) {
            rate = TickRateClientManager.getChunkState(entity.method_31476()).rate();
        }
        if (serverState.frozen() || serverState.sprinting() || serverState.stepping()) {
            return serverState.withRate(serverState.stepping() ? serverState.rate() : rate);
        }
        return state.withRate(rate);
    }

    public static TickState getChunkState(class_1923 chunkPos) {
        if (!serverHasMod) {
            return TickRateClientManager.getServerState();
        }
        TickState state = (TickState)class_310.method_1551().field_1687.method_8497(chunkPos.field_9181, chunkPos.field_9180).getAttached(TickRateAttachments.TICK_STATE);
        if (state == null) {
            return TickRateClientManager.getServerState();
        }
        int rate = state.rate();
        TickState serverState = TickRateClientManager.getServerState();
        if (state.rate() == -1) {
            rate = serverState.rate();
        }
        if (serverState.frozen() || serverState.sprinting() || serverState.stepping()) {
            return serverState.withRate(serverState.stepping() ? serverState.rate() : rate);
        }
        return state.withRate(rate);
    }

    public static TickState getServerState() {
        if (!serverHasMod) {
            class_8921 tickManager = class_310.method_1551().field_1687.method_54719();
            return new TickState((int)tickManager.method_54748(), tickManager.method_54754(), tickManager.method_54752(), false);
        }
        return (TickState)class_310.method_1551().field_1687.getAttached(TickRateAttachments.TICK_STATE_SERVER);
    }
}

