/*
 * Decompiled with CFR 0.152.
 */
package io.github.dennisochulor.tickrate.mixin.client.render;

import com.llamalad7.mixinextras.sugar.Local;
import io.github.dennisochulor.tickrate.TickDeltaInfo;
import io.github.dennisochulor.tickrate.TickRateClientManager;
import io.github.dennisochulor.tickrate.injected_interface.TickRateRenderTickCounter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_9779;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Environment(value=EnvType.CLIENT)
@Mixin(value={class_9779.class_9781.class})
public class RenderTickCounterDynamicMixin
implements TickRateRenderTickCounter {
    @Shadow
    private long field_51962;
    @Shadow
    private float field_51959;
    @Shadow
    @Final
    private float field_51964;
    @Unique
    private long prevPrevTickMillis;
    @Unique
    private float prevTickDelta;
    @Unique
    private int movingI;
    @Unique
    private int i;
    @Unique
    private final Map<Integer, TickDeltaInfo> prevTickDeltas = new HashMap<Integer, TickDeltaInfo>();
    @Unique
    private final Set<Integer> isUpdated = new HashSet<Integer>();
    @Unique
    private TickDeltaInfo clientPlayerTickDeltaInfo = TickDeltaInfo.NO_ANIMATE;
    @Unique
    private boolean clientPlayerUpdated = false;

    @Inject(method={"beginRenderTick(J)I"}, at={@At(value="HEAD")})
    private void beginRenderTick(long timeMillis, CallbackInfoReturnable<Integer> cir) {
        this.prevPrevTickMillis = this.field_51962;
        this.prevTickDelta = this.field_51959;
        this.isUpdated.clear();
        this.clientPlayerUpdated = false;
    }

    @Inject(method={"beginRenderTick(J)I"}, at={@At(value="TAIL")})
    private void beginRenderTick(long timeMillis, CallbackInfoReturnable<Integer> cir, @Local int i) {
        this.i = i;
        TickRateClientManager.clearCache();
    }

    @Override
    @Unique
    public TickDeltaInfo tickRate$getSpecificTickDeltaInfo(int tps) {
        float millisPerTick = 1000.0f / (float)tps;
        if (this.isUpdated.contains(tps)) {
            return this.prevTickDeltas.get(tps);
        }
        float lastFrameDuration = (float)(this.field_51962 - this.prevPrevTickMillis) / Math.max(millisPerTick, this.field_51964);
        float specificTickDelta = this.prevTickDeltas.getOrDefault(tps, new TickDeltaInfo(this.prevTickDelta, 0, 0.0f)).tickDelta() + lastFrameDuration;
        int i = (int)specificTickDelta;
        TickDeltaInfo info = new TickDeltaInfo(specificTickDelta -= (float)i, i, lastFrameDuration);
        this.isUpdated.add(tps);
        this.prevTickDeltas.put(tps, info);
        return info;
    }

    @Override
    @Unique
    public TickDeltaInfo tickRate$getClientPlayerTickDeltaInfo(int tps) {
        float millisPerTick = 1000.0f / (float)tps;
        if (this.clientPlayerUpdated) {
            return this.clientPlayerTickDeltaInfo;
        }
        float lastFrameDuration = (float)(this.field_51962 - this.prevPrevTickMillis) / millisPerTick;
        float specificTickDelta = this.clientPlayerTickDeltaInfo.tickDelta() + lastFrameDuration;
        int i = (int)specificTickDelta;
        this.clientPlayerTickDeltaInfo = new TickDeltaInfo(specificTickDelta -= (float)i, i, lastFrameDuration);
        this.clientPlayerUpdated = true;
        return this.clientPlayerTickDeltaInfo;
    }

    @Override
    public void tickRate$setMovingI(int newI) {
        this.movingI = newI;
    }

    @Override
    public int tickRate$getMovingI() {
        return this.movingI;
    }

    @Override
    public int tickRate$getI() {
        return this.i;
    }
}

