/*
 * Decompiled with CFR 0.152.
 */
package io.github.dennisochulor.tickrate.mixin.core;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.context.ParsedCommandNode;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import io.github.dennisochulor.tickrate.api.TickRateEvents;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import net.fabricmc.fabric.api.attachment.v1.AttachmentTarget;
import net.minecraft.class_1297;
import net.minecraft.class_1923;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2186;
import net.minecraft.class_2245;
import net.minecraft.class_2262;
import net.minecraft.class_2264;
import net.minecraft.class_2265;
import net.minecraft.class_2561;
import net.minecraft.class_2806;
import net.minecraft.class_2818;
import net.minecraft.class_3194;
import net.minecraft.class_4076;
import net.minecraft.class_4802;
import net.minecraft.class_8915;
import net.minecraft.class_8916;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_8916.class})
public class TickCommandMixin {
    @Shadow
    @Final
    private static String field_46926;

    @Shadow
    private static String method_54686(long nanos) {
        return "";
    }

    @ModifyConstant(method={"method_54709"}, constant={@Constant(intValue=3)})
    private static int modifyPermissionLevel(int permissionLevel) {
        return 2;
    }

    @ModifyExpressionValue(method={"register"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/command/CommandManager;literal(Ljava/lang/String;)Lcom/mojang/brigadier/builder/LiteralArgumentBuilder;", args={"ldc=tick"}, ordinal=0)})
    private static LiteralArgumentBuilder<class_2168> register(LiteralArgumentBuilder<class_2168> builder) {
        LiteralCommandNode chunkQuery = ((LiteralArgumentBuilder)class_2170.method_9247((String)"query").executes(context -> TickCommandMixin.executeQuery((class_2168)context.getSource(), TickCommandMixin.chunkCheck(TickCommandMixin.getChunks((CommandContext<class_2168>)context, 1), (class_2168)context.getSource())))).build();
        LiteralCommandNode chunkRate = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"rate").then(class_2170.method_9247((String)"reset").executes(context -> TickCommandMixin.executeRate((class_2168)context.getSource(), TickCommandMixin.chunkCheck(TickCommandMixin.getChunks((CommandContext<class_2168>)context, 2), (class_2168)context.getSource()), -1.0f)))).then(class_2170.method_9244((String)"rate", (ArgumentType)FloatArgumentType.floatArg((float)1.0f, (float)10000.0f)).suggests((context, suggestionsBuilder) -> class_2172.method_9253((String[])new String[]{field_46926, "reset"}, (SuggestionsBuilder)suggestionsBuilder)).executes(context -> TickCommandMixin.executeRate((class_2168)context.getSource(), TickCommandMixin.chunkCheck(TickCommandMixin.getChunks((CommandContext<class_2168>)context, 2), (class_2168)context.getSource()), FloatArgumentType.getFloat((CommandContext)context, (String)"rate"))))).build();
        LiteralCommandNode chunkUnfreeze = ((LiteralArgumentBuilder)class_2170.method_9247((String)"unfreeze").executes(context -> TickCommandMixin.executeFreeze((class_2168)context.getSource(), TickCommandMixin.chunkCheck(TickCommandMixin.getChunks((CommandContext<class_2168>)context, 1), (class_2168)context.getSource()), false))).build();
        LiteralCommandNode chunkFreeze = ((LiteralArgumentBuilder)class_2170.method_9247((String)"freeze").executes(context -> TickCommandMixin.executeFreeze((class_2168)context.getSource(), TickCommandMixin.chunkCheck(TickCommandMixin.getChunks((CommandContext<class_2168>)context, 1), (class_2168)context.getSource()), true))).build();
        LiteralCommandNode chunkStep = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"step").executes(context -> TickCommandMixin.executeStep((class_2168)context.getSource(), TickCommandMixin.chunkCheck(TickCommandMixin.getChunks((CommandContext<class_2168>)context, 1), (class_2168)context.getSource()), 1))).then(class_2170.method_9247((String)"stop").executes(context -> TickCommandMixin.executeStep((class_2168)context.getSource(), TickCommandMixin.chunkCheck(TickCommandMixin.getChunks((CommandContext<class_2168>)context, 2), (class_2168)context.getSource()), 0)))).then(class_2170.method_9244((String)"time", (ArgumentType)class_2245.method_48287((int)1)).suggests((context, suggestionsBuilder) -> class_2172.method_9253((String[])new String[]{"1t", "1s"}, (SuggestionsBuilder)suggestionsBuilder)).executes(context -> TickCommandMixin.executeStep((class_2168)context.getSource(), TickCommandMixin.chunkCheck(TickCommandMixin.getChunks((CommandContext<class_2168>)context, 2), (class_2168)context.getSource()), IntegerArgumentType.getInteger((CommandContext)context, (String)"time"))))).build();
        LiteralCommandNode chunkSprint = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"sprint").then(class_2170.method_9247((String)"stop").executes(context -> TickCommandMixin.executeSprint((class_2168)context.getSource(), TickCommandMixin.chunkCheck(TickCommandMixin.getChunks((CommandContext<class_2168>)context, 2), (class_2168)context.getSource()), 0)))).then(class_2170.method_9244((String)"time", (ArgumentType)class_2245.method_48287((int)1)).suggests((context, suggestionsBuilder) -> class_2172.method_9253((String[])new String[]{"60s", "1d", "3d"}, (SuggestionsBuilder)suggestionsBuilder)).executes(context -> TickCommandMixin.executeSprint((class_2168)context.getSource(), TickCommandMixin.chunkCheck(TickCommandMixin.getChunks((CommandContext<class_2168>)context, 2), (class_2168)context.getSource()), IntegerArgumentType.getInteger((CommandContext)context, (String)"time"))))).build();
        ((LiteralArgumentBuilder)builder.then(class_2170.method_9247((String)"entity").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"entities", (ArgumentType)class_2186.method_9306()).then(class_2170.method_9247((String)"query").executes(context -> TickCommandMixin.executeQuery((class_2168)context.getSource(), TickCommandMixin.entityCheck(class_2186.method_9317((CommandContext)context, (String)"entities"), (class_2168)context.getSource()))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"rate").then(class_2170.method_9247((String)"reset").executes(context -> TickCommandMixin.executeRate((class_2168)context.getSource(), TickCommandMixin.entityCheck(class_2186.method_9317((CommandContext)context, (String)"entities"), (class_2168)context.getSource()), -1.0f)))).then(class_2170.method_9244((String)"rate", (ArgumentType)FloatArgumentType.floatArg((float)1.0f, (float)10000.0f)).suggests((context, suggestionsBuilder) -> class_2172.method_9253((String[])new String[]{field_46926, "reset"}, (SuggestionsBuilder)suggestionsBuilder)).executes(context -> TickCommandMixin.executeRate((class_2168)context.getSource(), TickCommandMixin.entityCheck(class_2186.method_9317((CommandContext)context, (String)"entities"), (class_2168)context.getSource()), FloatArgumentType.getFloat((CommandContext)context, (String)"rate")))))).then(class_2170.method_9247((String)"unfreeze").executes(context -> TickCommandMixin.executeFreeze((class_2168)context.getSource(), TickCommandMixin.entityCheck(class_2186.method_9317((CommandContext)context, (String)"entities"), (class_2168)context.getSource()), false)))).then(class_2170.method_9247((String)"freeze").executes(context -> TickCommandMixin.executeFreeze((class_2168)context.getSource(), TickCommandMixin.entityCheck(class_2186.method_9317((CommandContext)context, (String)"entities"), (class_2168)context.getSource()), true)))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"step").executes(context -> TickCommandMixin.executeStep((class_2168)context.getSource(), TickCommandMixin.entityCheck(class_2186.method_9317((CommandContext)context, (String)"entities"), (class_2168)context.getSource()), 1))).then(class_2170.method_9247((String)"stop").executes(context -> TickCommandMixin.executeStep((class_2168)context.getSource(), TickCommandMixin.entityCheck(class_2186.method_9317((CommandContext)context, (String)"entities"), (class_2168)context.getSource()), 0)))).then(class_2170.method_9244((String)"time", (ArgumentType)class_2245.method_48287((int)1)).suggests((context, suggestionsBuilder) -> class_2172.method_9253((String[])new String[]{"1t", "1s"}, (SuggestionsBuilder)suggestionsBuilder)).executes(context -> TickCommandMixin.executeStep((class_2168)context.getSource(), TickCommandMixin.entityCheck(class_2186.method_9317((CommandContext)context, (String)"entities"), (class_2168)context.getSource()), IntegerArgumentType.getInteger((CommandContext)context, (String)"time")))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"sprint").then(class_2170.method_9247((String)"stop").executes(context -> TickCommandMixin.executeSprint((class_2168)context.getSource(), TickCommandMixin.entityCheck(class_2186.method_9317((CommandContext)context, (String)"entities"), (class_2168)context.getSource()), 0)))).then(class_2170.method_9244((String)"time", (ArgumentType)class_2245.method_48287((int)1)).suggests((context, suggestionsBuilder) -> class_2172.method_9253((String[])new String[]{"60s", "1d", "3d"}, (SuggestionsBuilder)suggestionsBuilder)).executes(context -> TickCommandMixin.executeSprint((class_2168)context.getSource(), TickCommandMixin.entityCheck(class_2186.method_9317((CommandContext)context, (String)"entities"), (class_2168)context.getSource()), IntegerArgumentType.getInteger((CommandContext)context, (String)"time")))))))).then(class_2170.method_9247((String)"chunk").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"from", (ArgumentType)class_2264.method_9701()).then((CommandNode)chunkQuery)).then((CommandNode)chunkRate)).then((CommandNode)chunkUnfreeze)).then((CommandNode)chunkFreeze)).then((CommandNode)chunkStep)).then((CommandNode)chunkSprint)).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"to", (ArgumentType)class_2264.method_9701()).then((CommandNode)chunkQuery)).then((CommandNode)chunkRate)).then((CommandNode)chunkUnfreeze)).then((CommandNode)chunkFreeze)).then((CommandNode)chunkStep)).then((CommandNode)chunkSprint))).then(class_2170.method_9247((String)"radius").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"radius", (ArgumentType)FloatArgumentType.floatArg((float)1.0f)).then((CommandNode)chunkQuery)).then((CommandNode)chunkRate)).then((CommandNode)chunkUnfreeze)).then((CommandNode)chunkFreeze)).then((CommandNode)chunkStep)).then((CommandNode)chunkSprint)))));
        return builder;
    }

    @Overwrite
    private static int method_54691(class_2168 source, float rate) {
        int roundRate = Math.round(rate);
        class_8915 tickManager = source.method_9211().method_54833();
        tickManager.tickRate$setServerRate(roundRate);
        ((TickRateEvents.ServerRate)TickRateEvents.SERVER_RATE.invoker()).onServerRate(source.method_9211(), roundRate);
        source.method_9226(() -> class_2561.method_43469((String)"commands.tick.rate.success", (Object[])new Object[]{roundRate}), true);
        return roundRate;
    }

    @Overwrite
    private static int method_54690(class_2168 source) {
        class_8915 serverTickManager = source.method_9211().method_54833();
        if (serverTickManager.method_54670()) {
            source.method_9226(() -> class_2561.method_43471((String)"commands.tick.status.sprinting"), false);
        } else if (serverTickManager.method_54754()) {
            source.method_9226(() -> class_2561.method_43471((String)"commands.tick.status.frozen"), false);
        } else if (serverTickManager.method_54750() < source.method_9211().method_54834()) {
            source.method_9226(() -> class_2561.method_43471((String)"commands.tick.status.lagging"), false);
        } else {
            source.method_9226(() -> class_2561.method_43471((String)"commands.tick.status.running"), false);
        }
        source.method_9226(() -> class_2561.method_43470((String)("Server's target tick rate: " + serverTickManager.tickRate$getServerRate() + " per second (" + TickCommandMixin.method_54686((long)((double)class_4802.field_33868 / (double)serverTickManager.tickRate$getServerRate())) + " mspt)")), false);
        source.method_9226(() -> class_2561.method_43470((String)("Mainloop's target tick rate: " + Math.round(serverTickManager.method_54748()) + " per second (" + TickCommandMixin.method_54686((long)((double)class_4802.field_33868 / (double)serverTickManager.method_54748())) + " mspt)")), false);
        long[] ls = Arrays.copyOf(source.method_9211().method_54835(), source.method_9211().method_54835().length);
        Arrays.sort(ls);
        String p50 = TickCommandMixin.method_54686(ls[ls.length / 2]);
        String p95 = TickCommandMixin.method_54686(ls[(int)((double)ls.length * 0.95)]);
        String p99 = TickCommandMixin.method_54686(ls[(int)((double)ls.length * 0.99)]);
        float avg = source.method_9211().method_54832();
        source.method_9226(() -> class_2561.method_43470((String)"Avg: %.1fms P50: %sms P95: %sms P99: %sms, sample: %s".formatted(Float.valueOf(avg), p50, p95, p99, ls.length)), false);
        return serverTickManager.tickRate$getServerRate();
    }

    @Inject(method={"executeSprint"}, at={@At(value="TAIL")})
    private static void executeSprint(class_2168 source, int ticks, CallbackInfoReturnable<Integer> cir) {
        ((TickRateEvents.ServerSprint)TickRateEvents.SERVER_SPRINT.invoker()).onServerSprint(source.method_9211(), ticks);
    }

    @Inject(method={"executeFreeze"}, at={@At(value="TAIL")})
    private static void executeFreeze(class_2168 source, boolean frozen, CallbackInfoReturnable<Integer> cir) {
        ((TickRateEvents.ServerFreeze)TickRateEvents.SERVER_FREEZE.invoker()).onServerFreeze(source.method_9211(), frozen);
    }

    @Inject(method={"executeStep"}, at={@At(value="TAIL")})
    private static void executeStep(class_2168 source, int ticks, CallbackInfoReturnable<Integer> cir) {
        ((TickRateEvents.ServerStep)TickRateEvents.SERVER_STEP.invoker()).onServerStep(source.method_9211(), ticks);
    }

    @Unique
    private static int executeRate(class_2168 source, List<? extends AttachmentTarget> targets, float rate) {
        String targetType;
        if (targets == null) {
            return 0;
        }
        int roundRate = Math.round(rate);
        class_8915 tickManager = source.method_9211().method_54833();
        tickManager.tickRate$setRate(roundRate, targets);
        AttachmentTarget attachmentTarget = targets.getFirst();
        Objects.requireNonNull(attachmentTarget);
        AttachmentTarget attachmentTarget2 = attachmentTarget;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{class_1297.class, class_2818.class}, (Object)attachmentTarget2, n)) {
            case 0: {
                class_1297 ignored = (class_1297)attachmentTarget2;
                targetType = "entities";
                targets.forEach(target -> ((TickRateEvents.EntityRate)TickRateEvents.ENTITY_RATE.invoker()).onEntityRate((class_1297)target, roundRate == -1 ? 0.0f : (float)roundRate));
                break;
            }
            case 1: {
                class_2818 ignored = (class_2818)attachmentTarget2;
                targetType = "chunks";
                targets.forEach(target -> ((TickRateEvents.ChunkRate)TickRateEvents.CHUNK_RATE.invoker()).onChunkRate((class_2818)target, roundRate == -1 ? 0.0f : (float)roundRate));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown target type: " + String.valueOf(targets.getFirst()));
            }
        }
        if (roundRate != -1) {
            source.method_9226(() -> class_2561.method_30163((String)("Set tick rate of " + targets.size() + " " + targetType + " to " + roundRate + " TPS.")), false);
            return roundRate;
        }
        source.method_9226(() -> class_2561.method_43470((String)("Reset the target rate of " + targets.size() + " " + targetType)), false);
        return 0;
    }

    @Unique
    private static int executeQuery(class_2168 source, List<? extends AttachmentTarget> targets) {
        int firstRate;
        String targetType;
        if (targets == null) {
            return 0;
        }
        class_8915 tickManager = source.method_9211().method_54833();
        StringBuilder sb = new StringBuilder();
        AttachmentTarget attachmentTarget = targets.getFirst();
        Objects.requireNonNull(attachmentTarget);
        AttachmentTarget attachmentTarget2 = attachmentTarget;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{class_1297.class, class_2818.class}, (Object)attachmentTarget2, n)) {
            case 0: {
                class_1297 first = (class_1297)attachmentTarget2;
                targetType = "entities";
                firstRate = tickManager.tickRate$getEntityRate(first);
                targets.forEach(e -> {
                    class_1297 entity = (class_1297)e;
                    sb.append(entity.method_5864().method_5897().getString()).append(" ").append(entity.method_5820()).append(" - ").append(tickManager.tickRate$getEntityRate(entity)).append(" TPS").append("\n");
                });
                break;
            }
            case 1: {
                class_2818 first = (class_2818)attachmentTarget2;
                targetType = "chunks";
                firstRate = tickManager.tickRate$getChunkRate(first);
                targets.forEach(chunk -> {
                    class_2818 worldChunk = (class_2818)chunk;
                    sb.append("Chunk ").append(worldChunk.method_12004().toString()).append(" - ").append(tickManager.tickRate$getChunkRate(worldChunk)).append(" TPS").append("\n");
                });
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown target type: " + String.valueOf(targets.getFirst()));
            }
        }
        sb.insert(0, "The tick rates of the specified " + targetType + " are as follows:\n");
        sb.deleteCharAt(sb.length() - 1);
        source.method_9226(() -> class_2561.method_30163((String)sb.toString()), false);
        return firstRate;
    }

    @Unique
    private static int executeFreeze(class_2168 source, List<? extends AttachmentTarget> targets, boolean frozen) {
        String targetType;
        if (targets == null) {
            return 0;
        }
        class_8915 tickManager = source.method_9211().method_54833();
        tickManager.tickRate$setFrozen(frozen, targets);
        AttachmentTarget attachmentTarget = targets.getFirst();
        Objects.requireNonNull(attachmentTarget);
        AttachmentTarget attachmentTarget2 = attachmentTarget;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{class_1297.class, class_2818.class}, (Object)attachmentTarget2, n)) {
            case 0: {
                class_1297 ignored = (class_1297)attachmentTarget2;
                targetType = "entities";
                targets.forEach(entity -> ((TickRateEvents.EntityFreeze)TickRateEvents.ENTITY_FREEZE.invoker()).onEntityFreeze((class_1297)entity, frozen));
                break;
            }
            case 1: {
                class_2818 ignored = (class_2818)attachmentTarget2;
                targetType = "chunks";
                targets.forEach(chunk -> ((TickRateEvents.ChunkFreeze)TickRateEvents.CHUNK_FREEZE.invoker()).onChunkFreeze((class_2818)chunk, frozen));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown target type: " + String.valueOf(targets.getFirst()));
            }
        }
        source.method_9226(() -> class_2561.method_43470((String)(targets.size() + " " + targetType + " have been " + (frozen ? "frozen." : "unfrozen."))), false);
        return 1;
    }

    @Unique
    private static int executeStep(class_2168 source, List<? extends AttachmentTarget> targets, int steps) {
        String targetType;
        if (targets == null) {
            return 0;
        }
        class_8915 tickManager = source.method_9211().method_54833();
        boolean success = tickManager.tickRate$step(steps, targets);
        AttachmentTarget attachmentTarget = targets.getFirst();
        Objects.requireNonNull(attachmentTarget);
        AttachmentTarget attachmentTarget2 = attachmentTarget;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{class_1297.class, class_2818.class}, (Object)attachmentTarget2, n)) {
            case 0: {
                class_1297 ignored = (class_1297)attachmentTarget2;
                targetType = "entities";
                if (!success || steps == 0) break;
                targets.forEach(entity -> ((TickRateEvents.EntityStep)TickRateEvents.ENTITY_STEP.invoker()).onEntityStep((class_1297)entity, steps));
                break;
            }
            case 1: {
                class_2818 ignored = (class_2818)attachmentTarget2;
                targetType = "chunks";
                if (!success || steps == 0) break;
                targets.forEach(chunk -> ((TickRateEvents.ChunkStep)TickRateEvents.CHUNK_STEP.invoker()).onChunkStep((class_2818)chunk, steps));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown target type: " + String.valueOf(targets.getFirst()));
            }
        }
        if (success) {
            if (steps != 0) {
                source.method_9226(() -> class_2561.method_43470((String)(targets.size() + " " + targetType + " will step " + steps + " ticks.")), false);
            } else {
                source.method_9226(() -> class_2561.method_43470((String)(targets.size() + " " + targetType + " have stopped stepping.")), false);
            }
        } else {
            source.method_9226(() -> class_2561.method_43470((String)("All of the specified " + targetType + " must be frozen first and cannot be sprinting!")).method_54663(-2142128), false);
        }
        return success ? 1 : 0;
    }

    @Unique
    private static int executeSprint(class_2168 source, List<? extends AttachmentTarget> targets, int ticks) {
        String targetType;
        if (targets == null) {
            return 0;
        }
        class_8915 tickManager = source.method_9211().method_54833();
        boolean success = tickManager.tickRate$sprint(ticks, targets);
        AttachmentTarget attachmentTarget = targets.getFirst();
        Objects.requireNonNull(attachmentTarget);
        AttachmentTarget attachmentTarget2 = attachmentTarget;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{class_1297.class, class_2818.class}, (Object)attachmentTarget2, n)) {
            case 0: {
                class_1297 ignored = (class_1297)attachmentTarget2;
                targetType = "entities";
                if (!success || ticks == 0) break;
                targets.forEach(entity -> ((TickRateEvents.EntitySprint)TickRateEvents.ENTITY_SPRINT.invoker()).onEntitySprint((class_1297)entity, ticks));
                break;
            }
            case 1: {
                class_2818 ignored = (class_2818)attachmentTarget2;
                targetType = "chunks";
                if (!success || ticks == 0) break;
                targets.forEach(chunk -> ((TickRateEvents.ChunkSprint)TickRateEvents.CHUNK_SPRINT.invoker()).onChunkSprint((class_2818)chunk, ticks));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown target type: " + String.valueOf(targets.getFirst()));
            }
        }
        if (success) {
            if (ticks != 0) {
                source.method_9226(() -> class_2561.method_43470((String)(targets.size() + " " + targetType + " will sprint " + ticks + " ticks.")), false);
            } else {
                source.method_9226(() -> class_2561.method_43470((String)(targets.size() + " " + targetType + " have stopped sprinting.")), false);
            }
        } else {
            source.method_9226(() -> class_2561.method_43470((String)("All of the specified " + targetType + " must not be stepping!")).method_54663(-2142128), false);
        }
        return success ? 1 : 0;
    }

    @Unique
    private static List<? extends class_1297> entityCheck(Collection<? extends class_1297> entities, class_2168 source) {
        return (List)entities;
    }

    @Unique
    private static List<class_2818> chunkCheck(List<class_1923> chunks, class_2168 source) {
        ArrayList<class_2818> worldChunks = new ArrayList<class_2818>();
        boolean match = chunks.stream().anyMatch(chunkPos -> {
            class_2818 worldChunk = (class_2818)source.method_9225().method_8402(chunkPos.field_9181, chunkPos.field_9180, class_2806.field_12803, false);
            worldChunks.add(worldChunk);
            return worldChunk == null || worldChunk.method_12225() == class_3194.field_19334;
        });
        if (match) {
            source.method_9226(() -> class_2561.method_43470((String)"Some of the specified chunks are not loaded!").method_54663(-2142128), false);
            return null;
        }
        return worldChunks;
    }

    @Unique
    private static List<class_1923> getChunks(CommandContext<class_2168> context, int depth) throws CommandSyntaxException {
        String lastNode;
        return switch (lastNode = ((ParsedCommandNode)context.getNodes().get(context.getNodes().size() - depth - 1)).getNode().getName()) {
            case "from" -> {
                class_2265 from = class_2264.method_9702(context, (String)"from");
                if (from.comp_638() < -30000000 || from.comp_639() < -30000000 || from.comp_638() >= 30000000 || from.comp_639() >= 30000000) {
                    throw class_2262.field_10704.create();
                }
                yield List.of(from.method_34873());
            }
            case "to" -> {
                class_2265 from = class_2264.method_9702(context, (String)"from");
                class_2265 to = class_2264.method_9702(context, (String)"to");
                int minX = Math.min(from.comp_638(), to.comp_638());
                int minZ = Math.min(from.comp_639(), to.comp_639());
                int maxX = Math.max(from.comp_638(), to.comp_638());
                int maxZ = Math.max(from.comp_639(), to.comp_639());
                if (minX < -30000000 || minZ < -30000000 || maxX >= 30000000 || maxZ >= 30000000) {
                    throw class_2262.field_10704.create();
                }
                int chunkMinX = class_4076.method_18675((int)minX);
                int chunkMinZ = class_4076.method_18675((int)minZ);
                int chunkMaxX = class_4076.method_18675((int)maxX);
                int chunkMaxZ = class_4076.method_18675((int)maxZ);
                ArrayList<class_1923> chunks = new ArrayList<class_1923>();
                for (int chunkX = chunkMinX; chunkX <= chunkMaxX; ++chunkX) {
                    for (int chunkZ = chunkMinZ; chunkZ <= chunkMaxZ; ++chunkZ) {
                        chunks.add(new class_1923(chunkX, chunkZ));
                    }
                }
                yield chunks;
            }
            case "radius" -> {
                class_2265 circleCentre = class_2264.method_9702(context, (String)"from");
                float radius = FloatArgumentType.getFloat(context, (String)"radius");
                float minX = (float)circleCentre.comp_638() - radius;
                float minZ = (float)circleCentre.comp_639() - radius;
                float maxX = (float)circleCentre.comp_638() + radius;
                float maxZ = (float)circleCentre.comp_639() + radius;
                if (minX < -3.0E7f || minZ < -3.0E7f || maxX >= 3.0E7f || maxZ >= 3.0E7f) {
                    throw class_2262.field_10704.create();
                }
                int chunkMinX = class_4076.method_32204((double)minX);
                int chunkMinZ = class_4076.method_32204((double)minZ);
                int chunkMaxX = class_4076.method_32204((double)maxX);
                int chunkMaxZ = class_4076.method_32204((double)maxZ);
                ArrayList<class_1923> chunks = new ArrayList<class_1923>();
                for (int chunkX = chunkMinX; chunkX <= chunkMaxX; ++chunkX) {
                    for (int chunkZ = chunkMinZ; chunkZ <= chunkMaxZ; ++chunkZ) {
                        int Yn;
                        int Dz;
                        class_1923 chunkPos = new class_1923(chunkX, chunkZ);
                        class_4076 chunkSectionPos = class_4076.method_18681((class_1923)chunkPos, (int)0);
                        int X1 = chunkSectionPos.method_19527();
                        int X2 = chunkSectionPos.method_19530();
                        int Z1 = chunkSectionPos.method_19529();
                        int Z2 = chunkSectionPos.method_19532();
                        int Xc = circleCentre.comp_638();
                        int Zc = circleCentre.comp_639();
                        int Xn = Math.max(X1, Math.min(Xc, X2));
                        int Dx = Xn - Xc;
                        if (!((float)(Dx * Dx + (Dz = (Yn = Math.max(Z1, Math.min(Zc, Z2))) - Zc) * Dz) <= radius * radius)) continue;
                        chunks.add(chunkPos);
                    }
                }
                yield chunks;
            }
            default -> throw new IllegalStateException("Unexpected value: " + lastNode);
        };
    }
}

