/*
 * Decompiled with CFR 0.152.
 */
package com.finaty.stunningbows.custom;

import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.ForgeEventFactory;

public class BoneBow
extends BowItem {
    public static final int MAX_DRAW_DURATION = 20;
    public static final int DEFAULT_RANGE = 15;

    public BoneBow(Item.Properties pProperties) {
        super(pProperties);
    }

    public boolean releaseUsing(ItemStack pItemStack, Level pLevel, LivingEntity pLivingEntity, int pTimeLeft) {
        if (pLivingEntity instanceof Player) {
            Player player = (Player)pLivingEntity;
            ItemStack itemstack = player.getProjectile(pItemStack);
            if (itemstack.isEmpty()) {
                return false;
            }
            int i = this.getUseDuration(pItemStack, pLivingEntity) - pTimeLeft;
            if ((i = ForgeEventFactory.onArrowLoose((ItemStack)pItemStack, (Level)pLevel, (Player)player, (int)i, (boolean)true)) < 0) {
                return false;
            }
            float f = BoneBow.getPowerForTime(i);
            if ((double)f < 0.1) {
                return false;
            }
            List list = BoneBow.draw((ItemStack)pItemStack, (ItemStack)itemstack, (LivingEntity)player);
            if (pLevel instanceof ServerLevel) {
                ServerLevel serverlevel = (ServerLevel)pLevel;
                if (!list.isEmpty()) {
                    this.shoot(serverlevel, (LivingEntity)player, player.getUsedItemHand(), pItemStack, list, f * 3.0f, 1.0f, f == 1.0f, null);
                }
            }
            pLevel.playSound((Entity)((Player)null), player.getX(), player.getY(), player.getZ(), SoundEvents.ARROW_SHOOT, SoundSource.PLAYERS, 1.0f, 1.0f / (pLevel.getRandom().nextFloat() * 0.4f + 1.2f) + f * 0.5f);
            player.awardStat(Stats.ITEM_USED.get((Object)this));
            return true;
        }
        return false;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Holder<Enchantment> enchantment) {
        return super.canApplyAtEnchantingTable(stack, enchantment);
    }

    public static float getPowerForTime(int pCharge) {
        float f = (float)pCharge / 20.0f;
        if ((f = (f * f + f * 2.2f) / 2.9f) > 1.0f) {
            f = 1.0f;
        }
        return f;
    }
}

