/*
 * Decompiled with CFR 0.152.
 */
package org.doraj1.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Objects;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_437;

@Environment(value=EnvType.CLIENT)
public class ForceGUIScaleConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Path CONFIG_PATH = FabricLoader.getInstance().getConfigDir().resolve("forceguiscale.json");
    private static final ForceGUIScaleConfig INSTANCE = ForceGUIScaleConfig.load();
    public boolean enabled = false;
    public int forceScale = 4;

    private ForceGUIScaleConfig() {
    }

    public static ForceGUIScaleConfig getInstance() {
        return INSTANCE;
    }

    private static ForceGUIScaleConfig load() {
        if (CONFIG_PATH == null || !Files.exists(CONFIG_PATH, new LinkOption[0])) {
            ForceGUIScaleConfig config = new ForceGUIScaleConfig();
            config.save();
            return config;
        }
        try {
            String json = Files.readString(CONFIG_PATH);
            ForceGUIScaleConfig loaded = (ForceGUIScaleConfig)GSON.fromJson(json, ForceGUIScaleConfig.class);
            return Objects.requireNonNullElseGet(loaded, ForceGUIScaleConfig::new);
        }
        catch (IOException e) {
            e.printStackTrace();
            return new ForceGUIScaleConfig();
        }
    }

    public void save() {
        try {
            String json = GSON.toJson((Object)this);
            Files.writeString(CONFIG_PATH, (CharSequence)json, new OpenOption[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public class_437 createScreen(class_437 parent) {
        ConfigBuilder builder = ConfigBuilder.create().setParentScreen(parent).setTitle((class_2561)class_2561.method_43470((String)"Force GUI Scale \uc124\uc815"));
        builder.setSavingRunnable(() -> {
            this.save();
            if (class_310.method_1551() != null) {
                class_310.method_1551().method_15993();
            }
        });
        ConfigCategory general = builder.getOrCreateCategory((class_2561)class_2561.method_43470((String)"\uc77c\ubc18"));
        ConfigEntryBuilder entryBuilder = builder.entryBuilder();
        general.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)class_2561.method_43470((String)"\ubaa8\ub4dc \ud65c\uc131\ud654"), this.enabled).setDefaultValue(false).setTooltip(new class_2561[]{class_2561.method_43470((String)"\ucf1c\uba74 \uc544\ub798 \uc124\uc815\ub41c \ud06c\uae30\ub85c GUI\ub97c \uace0\uc815\ud569\ub2c8\ub2e4.")}).setSaveConsumer(newValue -> {
            this.enabled = newValue;
        }).build());
        general.addEntry((AbstractConfigListEntry)entryBuilder.startIntSlider((class_2561)class_2561.method_43470((String)"GUI \ud06c\uae30 \uac15\uc81c \uc124\uc815"), this.forceScale, 1, 10).setDefaultValue(4).setTooltip(new class_2561[]{class_2561.method_43470((String)"\uc6d0\ud558\ub294 GUI \ud06c\uae30\ub97c \uc124\uc815\ud558\uc138\uc694. \uc720\ub2c8\ucf54\ub4dc \uc124\uc815\uc5d0 \uc601\ud5a5\uc744 \ubc1b\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4.")}).setSaveConsumer(newValue -> {
            this.forceScale = newValue;
        }).build());
        return builder.build();
    }
}

