#version 150
//Made by Max4K

vec4 linear_fog(vec4 inColor, float vertexDistance, float fogStart, float fogEnd, vec4 fogColor) {



    float fogRedValue = ceil(fogColor.r * 255.0);
    float fogGreenValue = ceil(fogColor.g * 255.0);
    float fogBlueValue = ceil(fogColor.b * 255.0);



    vertexDistance = min(vertexDistance, fogEnd);
   
	

	//Ender Dragon Fog || Powder Snow Fog || Lava Fog
    if (fogRedValue == 21 && fogGreenValue == 17 && fogBlueValue == 21
	|| fogRedValue == 159 && fogGreenValue == 188 && fogBlueValue == 201
	|| fogRedValue == 153 && fogGreenValue == 26 && fogBlueValue == 0 && fogColor.a != 0
	) {return vec4(mix(inColor.rgb, fogColor.rgb, smoothstep(fogStart, fogEnd, vertexDistance) * fogColor.a / 1.5), inColor.a/1.5);}



	//Blindness || Darkness Fogs || Water fix
    if (fogRedValue == 0 && fogGreenValue == 0 && fogBlueValue == 0 && fogColor.a != 0) {  
		return vec4(mix(inColor.rgb, fogColor.rgb, smoothstep(fogStart, fogEnd, vertexDistance/1.2) * fogColor.a / 1.2), inColor.a);
	}
	
	

	if(fogColor.a == 1 && fogEnd < 100  && fogEnd > 20 ) {
		return vec4(mix(inColor.rgb, fogColor.rgb, smoothstep(fogStart, fogEnd, vertexDistance) * fogColor.a), inColor.a);
	}

	
	if (vertexDistance/2 < fogStart) {
        return inColor;
    }

    return vec4(mix(inColor.rgb, fogColor.rgb, smoothstep(fogStart, fogEnd, vertexDistance) * fogColor.a), fogColor.a);
	
}

float linear_fog_fade(float vertexDistance, float fogStart, float fogEnd) {

   
    if (vertexDistance <= fogStart) {
        return 1.0;
    } else if (vertexDistance >= fogEnd) {
        return 0.0;
    }

    return smoothstep(fogEnd, fogStart, vertexDistance);
}


float fog_distance(mat4 modelViewMat, vec3 pos, int shape) {
    if (shape == 0) {
        return length((modelViewMat * vec4(pos, 1.0)).xyz);
    } else {
        float distXZ = length((modelViewMat * vec4(pos.x, 0.0, pos.z, 1.0)).xyz);
        float distY = length((modelViewMat * vec4(0.0, pos.y, 0.0, 1.0)).xyz);
        return max(distXZ, distY);
    }
}


