/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.radiationmod.init;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import net.mcreator.radiationmod.world.features.NukeFeature;
import net.mcreator.radiationmod.world.features.ores.AntiRadOreFeature;
import net.mcreator.radiationmod.world.features.ores.HighRadioactiveDirtFeature;
import net.mcreator.radiationmod.world.features.ores.LeadOreFeature;
import net.mcreator.radiationmod.world.features.ores.RadioActiveDirtFeature;
import net.mcreator.radiationmod.world.features.ores.VeryHighRadioactiveDirtFeature;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber
public class RadiationmodModFeatures {
    public static final DeferredRegister<Feature<?>> REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FEATURES, (String)"radiationmod");
    private static final List<FeatureRegistration> FEATURE_REGISTRATIONS = new ArrayList<FeatureRegistration>();
    public static final RegistryObject<Feature<?>> RADIO_ACTIVE_DIRT = RadiationmodModFeatures.register("radio_active_dirt", RadioActiveDirtFeature::feature, new FeatureRegistration(GenerationStep.Decoration.UNDERGROUND_ORES, RadioActiveDirtFeature.GENERATE_BIOMES, RadioActiveDirtFeature::placedFeature));
    public static final RegistryObject<Feature<?>> HIGH_RADIOACTIVE_DIRT = RadiationmodModFeatures.register("high_radioactive_dirt", HighRadioactiveDirtFeature::feature, new FeatureRegistration(GenerationStep.Decoration.UNDERGROUND_ORES, HighRadioactiveDirtFeature.GENERATE_BIOMES, HighRadioactiveDirtFeature::placedFeature));
    public static final RegistryObject<Feature<?>> NUKE = RadiationmodModFeatures.register("nuke", NukeFeature::feature, new FeatureRegistration(GenerationStep.Decoration.SURFACE_STRUCTURES, NukeFeature.GENERATE_BIOMES, NukeFeature::placedFeature));
    public static final RegistryObject<Feature<?>> VERY_HIGH_RADIOACTIVE_DIRT = RadiationmodModFeatures.register("very_high_radioactive_dirt", VeryHighRadioactiveDirtFeature::feature, new FeatureRegistration(GenerationStep.Decoration.UNDERGROUND_ORES, VeryHighRadioactiveDirtFeature.GENERATE_BIOMES, VeryHighRadioactiveDirtFeature::placedFeature));
    public static final RegistryObject<Feature<?>> ANTI_RAD_ORE = RadiationmodModFeatures.register("anti_rad_ore", AntiRadOreFeature::feature, new FeatureRegistration(GenerationStep.Decoration.UNDERGROUND_ORES, AntiRadOreFeature.GENERATE_BIOMES, AntiRadOreFeature::placedFeature));
    public static final RegistryObject<Feature<?>> LEAD_ORE = RadiationmodModFeatures.register("lead_ore", LeadOreFeature::feature, new FeatureRegistration(GenerationStep.Decoration.UNDERGROUND_ORES, LeadOreFeature.GENERATE_BIOMES, LeadOreFeature::placedFeature));

    private static RegistryObject<Feature<?>> register(String registryname, Supplier<Feature<?>> feature, FeatureRegistration featureRegistration) {
        FEATURE_REGISTRATIONS.add(featureRegistration);
        return REGISTRY.register(registryname, feature);
    }

    @SubscribeEvent
    public static void addFeaturesToBiomes(BiomeLoadingEvent event) {
        for (FeatureRegistration registration : FEATURE_REGISTRATIONS) {
            if (registration.biomes() != null && !registration.biomes().contains(event.getName())) continue;
            event.getGeneration().getFeatures(registration.stage()).add(registration.placedFeature().get());
        }
    }

    private record FeatureRegistration(GenerationStep.Decoration stage, Set<ResourceLocation> biomes, Supplier<Holder<PlacedFeature>> placedFeature) {
    }
}

