/*
 * Decompiled with CFR 0.152.
 */
package ru.sculmix.anticlonetool.command;

import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.endera.enderalib.utils.PluginException;
import org.jetbrains.annotations.NotNull;
import ru.sculmix.anticlonetool.AntiCloneToolKt;
import ru.sculmix.anticlonetool.config.ConfigSchem;
import ru.sculmix.anticlonetool.util.ItemLocker;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J3\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0010H\u0016\u00a2\u0006\u0002\u0010\u0011J\u0010\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\u000eH\u0002R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lru/sculmix/anticlonetool/command/AntiCloneCommand;", "Lorg/bukkit/command/CommandExecutor;", "<init>", "()V", "miniMessage", "Lnet/kyori/adventure/text/minimessage/MiniMessage;", "Lorg/jetbrains/annotations/NotNull;", "onCommand", "", "sender", "Lorg/bukkit/command/CommandSender;", "command", "Lorg/bukkit/command/Command;", "label", "", "args", "", "(Lorg/bukkit/command/CommandSender;Lorg/bukkit/command/Command;Ljava/lang/String;[Ljava/lang/String;)Z", "isTemplateOrMap", "item", "Lorg/bukkit/inventory/ItemStack;", "isSmithingTemplate", "sendMessage", "", "message", "AntiCloneTool"})
public final class AntiCloneCommand
implements CommandExecutor {
    @NotNull
    private final MiniMessage miniMessage;

    public AntiCloneCommand() {
        MiniMessage miniMessage = MiniMessage.miniMessage();
        Intrinsics.checkNotNullExpressionValue((Object)miniMessage, (String)"miniMessage(...)");
        this.miniMessage = miniMessage;
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        Intrinsics.checkNotNullParameter((Object)sender, (String)"sender");
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Intrinsics.checkNotNullParameter((Object)label, (String)"label");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        if (args.length == 0) {
            this.sendMessage(sender, AntiCloneToolKt.getConfig().getMessages().getUsage());
            return true;
        }
        String string = args[0].toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        switch (string) {
            case "reload": {
                if (sender.hasPermission("anticlonetool.reload")) {
                    try {
                        AntiCloneToolKt.setConfig((ConfigSchem)AntiCloneToolKt.getConfigManager().loadOrCreateConfig());
                    }
                    catch (PluginException e) {
                        AntiCloneToolKt.getLogger().severe("Critical error loading configuration: " + e.getMessage());
                    }
                    this.sendMessage(sender, AntiCloneToolKt.getConfig().getMessages().getSuccessReload());
                } else {
                    this.sendMessage(sender, AntiCloneToolKt.getConfig().getMessages().getNoPermission());
                }
                return true;
            }
            case "unlock": 
            case "lock": {
                if (!(sender instanceof Player)) {
                    this.sendMessage(sender, AntiCloneToolKt.getConfig().getMessages().getOnlyPlayers());
                    return true;
                }
                CommandSender player = sender;
                ItemStack itemStack = ((Player)player).getInventory().getItemInMainHand();
                Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getItemInMainHand(...)");
                ItemStack item = itemStack;
                if (!this.isTemplateOrMap(item)) {
                    this.sendMessage(player, AntiCloneToolKt.getConfig().getMessages().getMustHoldItem());
                    return true;
                }
                ItemMeta itemMeta = item.getItemMeta();
                if (itemMeta == null) {
                    return true;
                }
                ItemMeta meta = itemMeta;
                String string2 = args[0].toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
                String string3 = string2;
                if (Intrinsics.areEqual((Object)string3, (Object)"lock")) {
                    if (!player.hasPermission("anticlonetool.lock")) {
                        this.sendMessage(player, AntiCloneToolKt.getConfig().getMessages().getNoPermission());
                        return true;
                    }
                    if (item.getType() == Material.FILLED_MAP && !AntiCloneToolKt.getConfig().getLockMapEnabled()) {
                        this.sendMessage(player, AntiCloneToolKt.getConfig().getMessages().getMapLockDisabled());
                        return true;
                    }
                    if (this.isSmithingTemplate(item) && !AntiCloneToolKt.getConfig().getLockTemplatesEnabled()) {
                        this.sendMessage(player, AntiCloneToolKt.getConfig().getMessages().getTemplateLockDisabled());
                        return true;
                    }
                    if (ItemLocker.INSTANCE.isLocked(item)) {
                        this.sendMessage(player, AntiCloneToolKt.getConfig().getMessages().getAlreadyLocked());
                        return true;
                    }
                    String string4 = ((Player)player).getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getName(...)");
                    ItemLocker.INSTANCE.lockItem(meta, string4);
                    item.setItemMeta(meta);
                    this.sendMessage(player, AntiCloneToolKt.getConfig().getMessages().getLocked());
                    break;
                }
                if (!Intrinsics.areEqual((Object)string3, (Object)"unlock")) break;
                if (!player.hasPermission("anticlonetool.unlock")) {
                    this.sendMessage(player, AntiCloneToolKt.getConfig().getMessages().getNoPermission());
                    return true;
                }
                if (!ItemLocker.INSTANCE.isLocked(item)) {
                    this.sendMessage(player, AntiCloneToolKt.getConfig().getMessages().getNotLocked());
                    return true;
                }
                String string5 = ((Player)player).getName();
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getName(...)");
                if (!ItemLocker.INSTANCE.canUnlock(item, string5, (Player)player)) {
                    this.sendMessage(player, AntiCloneToolKt.getConfig().getMessages().getCannotUnlock());
                    return true;
                }
                ItemLocker.INSTANCE.unlockItem(meta);
                item.setItemMeta(meta);
                this.sendMessage(player, AntiCloneToolKt.getConfig().getMessages().getUnlocked());
                break;
            }
            default: {
                this.sendMessage(sender, AntiCloneToolKt.getConfig().getMessages().getUsage());
            }
        }
        return true;
    }

    private final boolean isTemplateOrMap(ItemStack item) {
        return item.getType() == Material.FILLED_MAP || this.isSmithingTemplate(item);
    }

    private final boolean isSmithingTemplate(ItemStack item) {
        return StringsKt.endsWith$default((String)item.getType().toString(), (String)"_SMITHING_TEMPLATE", (boolean)false, (int)2, null);
    }

    private final void sendMessage(CommandSender sender, String message) {
        Component component = this.miniMessage.deserialize((Object)message);
        Intrinsics.checkNotNullExpressionValue((Object)component, (String)"deserialize(...)");
        Component component2 = component;
        sender.sendMessage(component2);
    }
}

