/*
 * Decompiled with CFR 0.152.
 */
package ru.sculmix.anticlonetool.util;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.endera.enderalib.adventure.MinimessageKt;
import org.jetbrains.annotations.NotNull;
import ru.sculmix.anticlonetool.AntiCloneTool;
import ru.sculmix.anticlonetool.AntiCloneToolKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u001e\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lru/sculmix/anticlonetool/util/ItemLocker;", "", "<init>", "()V", "lockedKey", "Lorg/bukkit/NamespacedKey;", "playerKey", "lockItem", "", "meta", "Lorg/bukkit/inventory/meta/ItemMeta;", "playerName", "", "unlockItem", "isLocked", "", "item", "Lorg/bukkit/inventory/ItemStack;", "canUnlock", "player", "Lorg/bukkit/entity/Player;", "AntiCloneTool"})
public final class ItemLocker {
    @NotNull
    public static final ItemLocker INSTANCE = new ItemLocker();
    @NotNull
    private static final NamespacedKey lockedKey = AntiCloneTool.Companion.getInstance().getLockKey();
    @NotNull
    private static final NamespacedKey playerKey = AntiCloneTool.Companion.getInstance().getLockedByKey();

    private ItemLocker() {
    }

    public final void lockItem(@NotNull ItemMeta meta, @NotNull String playerName) {
        Intrinsics.checkNotNullParameter((Object)meta, (String)"meta");
        Intrinsics.checkNotNullParameter((Object)playerName, (String)"playerName");
        PersistentDataContainer persistentDataContainer = meta.getPersistentDataContainer();
        Intrinsics.checkNotNullExpressionValue((Object)persistentDataContainer, (String)"getPersistentDataContainer(...)");
        PersistentDataContainer container = persistentDataContainer;
        container.set(playerKey, PersistentDataType.STRING, (Object)playerName);
        container.set(lockedKey, PersistentDataType.BYTE, (Object)1);
        List lore = new ArrayList();
        lore.add(MinimessageKt.stringToComponent((String)AntiCloneToolKt.getConfig().getMessages().getLockedLore()));
        lore.add(MinimessageKt.stringToComponent((String)StringsKt.replace$default((String)AntiCloneToolKt.getConfig().getMessages().getAuthorLore(), (String)"{author}", (String)playerName, (boolean)false, (int)4, null)));
        meta.lore(lore);
    }

    public final void unlockItem(@NotNull ItemMeta meta) {
        Intrinsics.checkNotNullParameter((Object)meta, (String)"meta");
        PersistentDataContainer persistentDataContainer = meta.getPersistentDataContainer();
        Intrinsics.checkNotNullExpressionValue((Object)persistentDataContainer, (String)"getPersistentDataContainer(...)");
        PersistentDataContainer container = persistentDataContainer;
        container.remove(playerKey);
        container.remove(lockedKey);
        meta.setLore(null);
    }

    public final boolean isLocked(@NotNull ItemStack item) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        ItemMeta itemMeta = item.getItemMeta();
        if (itemMeta == null) {
            return false;
        }
        ItemMeta meta = itemMeta;
        return meta.getPersistentDataContainer().has(lockedKey, PersistentDataType.BYTE);
    }

    public final boolean canUnlock(@NotNull ItemStack item, @NotNull String playerName, @NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        Intrinsics.checkNotNullParameter((Object)playerName, (String)"playerName");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        ItemMeta itemMeta = item.getItemMeta();
        if (itemMeta == null) {
            return false;
        }
        ItemMeta meta = itemMeta;
        String lockedBy = (String)meta.getPersistentDataContainer().get(playerKey, PersistentDataType.STRING);
        return Intrinsics.areEqual((Object)lockedBy, (Object)playerName) || Intrinsics.areEqual((Object)playerName, (Object)"CONSOLE") || player.hasPermission("anticlonetool.admin");
    }
}

