/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.api;

import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IOwnable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class Owner {
    public static final StreamCodec<RegistryFriendlyByteBuf, Owner> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, Owner::getName, (StreamCodec)ByteBufCodecs.STRING_UTF8, Owner::getUUID, Owner::new);
    private String ownerName = "owner";
    private String ownerUUID = "ownerUUID";
    private boolean validated = true;

    public Owner() {
    }

    public Owner(Entity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            this.ownerName = player.getName().getString();
            this.ownerUUID = player.getGameProfile().getId().toString();
        }
    }

    public Owner(Player player) {
        if (player != null) {
            this.ownerName = player.getName().getString();
            this.ownerUUID = player.getGameProfile().getId().toString();
        }
    }

    public Owner(String playerName, String playerUUID) {
        this.ownerName = playerName;
        this.ownerUUID = playerUUID;
    }

    public Owner(String playerName, String playerUUID, boolean validated) {
        this.ownerName = playerName;
        this.ownerUUID = playerUUID;
        this.validated = validated;
    }

    public static Owner fromCompound(CompoundTag tag) {
        Owner owner = new Owner();
        if (tag != null) {
            owner.load(tag);
        }
        return owner;
    }

    public void load(CompoundTag tag) {
        this.ownerName = tag.getStringOr("owner", this.ownerName);
        this.ownerUUID = tag.getStringOr("ownerUUID", this.ownerUUID);
        this.validated = tag.getBooleanOr("ownerValidated", this.validated);
    }

    public void save(CompoundTag tag, boolean saveValidationStatus) {
        tag.putString("owner", this.ownerName);
        tag.putString("ownerUUID", this.ownerUUID);
        if (saveValidationStatus) {
            tag.putBoolean("ownerValidated", this.validated);
        }
    }

    public boolean owns(IOwnable ... ownables) {
        for (IOwnable ownable : ownables) {
            if (ownable == null || ownable.isOwnedBy(this)) continue;
            return false;
        }
        return true;
    }

    public boolean isDefaultOwner() {
        return this.equals(new Owner());
    }

    public void set(String uuid, String name) {
        this.ownerName = name;
        this.ownerUUID = uuid;
    }

    public void setOwnerName(String name) {
        this.ownerName = name;
    }

    public void setOwnerUUID(String uuid) {
        this.ownerUUID = uuid;
    }

    public void setValidated(boolean validated) {
        this.validated = validated;
    }

    public String getName() {
        return this.ownerName;
    }

    public String getUUID() {
        return this.ownerUUID;
    }

    public boolean isValidated() {
        return this.validated;
    }

    public String toString() {
        return "Name: " + this.ownerName + "  UUID: " + this.ownerUUID;
    }

    public Owner copy() {
        return new Owner(this.ownerName, this.ownerUUID);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Deprecated
    public boolean equals(Object obj) {
        if (!(obj instanceof Owner)) return false;
        Owner owner = (Owner)obj;
        if (!this.getName().equals(owner.getName())) return false;
        if (!this.getUUID().equals(owner.getUUID())) return false;
        return true;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.ownerName).append((Object)this.ownerUUID).build();
    }

    public static EntityDataSerializer<Owner> getSerializer() {
        return (EntityDataSerializer)SCContent.OWNER_SERIALIZER.get();
    }
}

