/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blockentities;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.ILockable;
import net.geforcemods.securitycraft.api.IModuleInventoryWithContainer;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.blockentities.DisguisableBlockEntity;
import net.geforcemods.securitycraft.blocks.AbstractPanelBlock;
import net.geforcemods.securitycraft.blocks.BlockChangeDetectorBlock;
import net.geforcemods.securitycraft.inventory.BlockChangeDetectorMenu;
import net.geforcemods.securitycraft.misc.BlockEntityTracker;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.ITickingBlockEntity;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class BlockChangeDetectorBlockEntity
extends DisguisableBlockEntity
implements IModuleInventoryWithContainer,
MenuProvider,
ILockable,
ITickingBlockEntity {
    private Option.IntOption signalLength = new Option.IntOption("signalLength", 60, 0, 400, 5);
    private Option.IntOption range = new Option.IntOption("range", 5, 1, 15, 1);
    private Option.DisabledOption disabled = new Option.DisabledOption(false);
    private Option.IgnoreOwnerOption ignoreOwner = new Option.IgnoreOwnerOption(true);
    private DetectionMode mode = DetectionMode.BOTH;
    private boolean tracked = false;
    private List<ChangeEntry> entries = new ArrayList<ChangeEntry>();
    private final List<ChangeEntry> filteredEntries = new ArrayList<ChangeEntry>();
    private ItemStack filter = ItemStack.EMPTY;
    private boolean showHighlights = false;
    private int color = -16776961;

    public BlockChangeDetectorBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)SCContent.BLOCK_CHANGE_DETECTOR_BLOCK_ENTITY.get(), pos, state);
    }

    public void log(Player player, DetectionMode action, BlockPos pos, BlockState state) {
        BlockItem item;
        Item item2;
        if (this.isDisabled()) {
            return;
        }
        if (this.mode != DetectionMode.BOTH && action != this.mode) {
            return;
        }
        if (this.isOwnedBy((Entity)player) && this.ignoresOwner() || this.isAllowed((Entity)player)) {
            return;
        }
        if (pos.equals((Object)this.getBlockPos())) {
            return;
        }
        if (this.isModuleEnabled(ModuleType.SMART) && (item2 = this.filter.getItem()) instanceof BlockItem && (item = (BlockItem)item2).getBlock() != state.getBlock()) {
            return;
        }
        if (this.isModuleEnabled(ModuleType.REDSTONE)) {
            int signalLength = this.getSignalLength();
            this.level.setBlockAndUpdate(this.worldPosition, (BlockState)this.getBlockState().cycle((Property)BlockChangeDetectorBlock.POWERED));
            BlockUtils.updateIndirectNeighbors(this.level, this.worldPosition, (Block)SCContent.BLOCK_CHANGE_DETECTOR.get(), AbstractPanelBlock.getConnectedDirection(this.getBlockState()).getOpposite());
            if (signalLength > 0) {
                this.level.scheduleTick(this.worldPosition, (Block)SCContent.BLOCK_CHANGE_DETECTOR.get(), signalLength);
            }
        }
        this.entries.add(new ChangeEntry(player.getDisplayName().getString(), player.getUUID(), System.currentTimeMillis(), action, pos, state));
        this.setChanged();
        this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 2);
    }

    @Override
    public void tick(Level level, BlockPos pos, BlockState state) {
        if (!this.tracked) {
            BlockEntityTracker.BLOCK_CHANGE_DETECTOR.track(this);
            this.tracked = true;
        }
    }

    @Override
    public void saveAdditional(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        super.saveAdditional(tag, lookupProvider);
        ListTag entryList = new ListTag();
        this.entries.stream().map(ChangeEntry::save).forEach(arg_0 -> entryList.add(arg_0));
        tag.putInt("mode", this.mode.ordinal());
        tag.put("entries", (Tag)entryList);
        if (!this.filter.isEmpty()) {
            tag.put("filter", this.filter.save(lookupProvider));
        }
        tag.putBoolean("ShowHighlights", this.showHighlights);
        tag.putInt("Color", this.color);
    }

    @Override
    public void loadAdditional(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        super.loadAdditional(tag, lookupProvider);
        int modeOrdinal = tag.getIntOr("mode", 2);
        if (modeOrdinal < 0 || modeOrdinal >= DetectionMode.values().length) {
            modeOrdinal = 0;
        }
        this.mode = DetectionMode.values()[modeOrdinal];
        this.entries = new ArrayList<ChangeEntry>();
        tag.getListOrEmpty("entries").stream().map(element -> ChangeEntry.load(this.level, (CompoundTag)element)).forEach(this.entries::add);
        this.filter = Utils.parseOptional(lookupProvider, tag.getCompoundOrEmpty("filter"));
        this.showHighlights = tag.getBooleanOr("ShowHighlights", false);
        this.setColor(tag.getIntOr("Color", -16776961));
        this.updateFilteredEntries();
    }

    @Override
    public void preRemoveSideEffects(BlockPos pos, BlockState state) {
        if (this.level != null) {
            Block.popResource((Level)this.level, (BlockPos)pos, (ItemStack)this.getStackInSlot(36));
        }
        super.preRemoveSideEffects(pos, state);
    }

    @Override
    public <T> void onOptionChanged(Option<T> option) {
        if (option == this.signalLength) {
            this.level.setBlockAndUpdate(this.worldPosition, (BlockState)this.getBlockState().setValue((Property)BlockStateProperties.POWERED, (Comparable)Boolean.valueOf(false)));
            BlockUtils.updateIndirectNeighbors(this.level, this.worldPosition, this.getBlockState().getBlock());
        }
        super.onOptionChanged(option);
    }

    @Override
    public void setRemoved() {
        super.setRemoved();
        BlockEntityTracker.BLOCK_CHANGE_DETECTOR.stopTracking(this);
    }

    public AbstractContainerMenu createMenu(int id, Inventory inventory, Player player) {
        return new BlockChangeDetectorMenu(id, this.level, this.worldPosition, inventory);
    }

    public Component getDisplayName() {
        return super.getDisplayName();
    }

    public void setMode(DetectionMode mode) {
        this.mode = mode;
        if (!this.level.isClientSide) {
            this.setChanged();
        }
    }

    public DetectionMode getMode() {
        return this.mode;
    }

    public int getSignalLength() {
        return (Integer)this.signalLength.get();
    }

    public int getRange() {
        return (Integer)this.range.get();
    }

    public boolean isDisabled() {
        return (Boolean)this.disabled.get();
    }

    @Override
    public boolean ignoresOwner() {
        return (Boolean)this.ignoreOwner.get();
    }

    public List<ChangeEntry> getEntries() {
        return this.entries;
    }

    public List<ChangeEntry> getFilteredEntries() {
        return this.filteredEntries;
    }

    public void updateFilteredEntries() {
        this.filteredEntries.clear();
        this.entries.stream().filter(this::isEntryShown).forEach(this.filteredEntries::add);
    }

    public boolean isEntryShown(ChangeEntry entry) {
        DetectionMode currentMode = this.getMode();
        return !(currentMode != DetectionMode.BOTH && currentMode != entry.action() || !this.filter.isEmpty() && ((BlockItem)this.filter.getItem()).getBlock() != entry.state.getBlock());
    }

    @Override
    public ModuleType[] acceptedModules() {
        return new ModuleType[]{ModuleType.DISGUISE, ModuleType.ALLOWLIST, ModuleType.SMART, ModuleType.REDSTONE};
    }

    @Override
    public Option<?>[] customOptions() {
        return new Option[]{this.signalLength, this.range, this.disabled, this.ignoreOwner};
    }

    @Override
    public int getContainerSize() {
        return 1;
    }

    @Override
    public int getContainerStackSize() {
        return 1;
    }

    @Override
    public boolean isContainerEmpty() {
        return this.filter.isEmpty();
    }

    @Override
    public ItemStack removeContainerItem(int index, int count, boolean simulate) {
        ItemStack stack = this.filter;
        if (count >= 1) {
            if (simulate) {
                this.filter = ItemStack.EMPTY;
                this.setChanged();
            }
            return stack.copy();
        }
        return ItemStack.EMPTY;
    }

    @Override
    public void setContainerItem(int index, ItemStack stack) {
        if (stack.getItem() instanceof BlockItem) {
            if (!stack.isEmpty() && stack.getCount() > this.getContainerStackSize()) {
                stack = new ItemStack((ItemLike)stack.getItem(), this.getContainerStackSize());
            }
            this.filter = stack;
            this.setChanged();
        }
    }

    public void writeClientSideData(AbstractContainerMenu menu, RegistryFriendlyByteBuf buffer) {
        super.writeClientSideData(menu, buffer);
        buffer.writeBlockPos(this.worldPosition);
    }

    @Override
    public boolean enableHack() {
        return true;
    }

    @Override
    public ItemStack getStackInSlot(int slot) {
        if (!this.isContainer(slot)) {
            return this.getModuleInSlot(slot);
        }
        return slot == 36 ? this.filter : ItemStack.EMPTY;
    }

    public void showHighlights(boolean showHighlights) {
        this.showHighlights = showHighlights;
    }

    public boolean isShowingHighlights() {
        return this.showHighlights;
    }

    public void setColor(int color) {
        this.color = Mth.clamp((int)color, (int)-16777216, (int)-1);
    }

    public int getColor() {
        return this.color;
    }

    @Override
    public boolean isItemValidForContainer(int slot, ItemStack stack) {
        return true;
    }

    @Override
    public ItemStack getStackInContainer(int slot) {
        return this.filter;
    }

    public static enum DetectionMode {
        BREAK("gui.securitycraft:block_change_detector.mode.break"),
        PLACE("gui.securitycraft:block_change_detector.mode.place"),
        BOTH("gui.securitycraft:block_change_detector.mode.both");

        private String descriptionId;

        private DetectionMode(String desciptionId) {
            this.descriptionId = desciptionId;
        }

        public String getDescriptionId() {
            return this.descriptionId;
        }
    }

    public record ChangeEntry(String player, UUID uuid, long timestamp, DetectionMode action, BlockPos pos, BlockState state) {
        public CompoundTag save() {
            CompoundTag tag = new CompoundTag();
            tag.putString("player", this.player);
            tag.store("uuid", UUIDUtil.CODEC, (Object)this.uuid);
            tag.putLong("timestamp", this.timestamp);
            tag.putInt("action", this.action.ordinal());
            tag.putLong("pos", this.pos.asLong());
            tag.put("state", (Tag)NbtUtils.writeBlockState((BlockState)this.state));
            return tag;
        }

        public static ChangeEntry load(Level level, CompoundTag tag) {
            DefaultedRegistry holderGetter = level != null ? level.holderLookup(Registries.BLOCK) : BuiltInRegistries.BLOCK;
            int actionOrdinal = tag.getIntOr("action", 0);
            if (actionOrdinal < 0 || actionOrdinal >= DetectionMode.values().length) {
                actionOrdinal = 0;
            }
            return new ChangeEntry(tag.getStringOr("player", ""), tag.read("uuid", UUIDUtil.CODEC).orElse(null), tag.getLongOr("timestamp", 0L), DetectionMode.values()[actionOrdinal], BlockPos.of((long)tag.getLongOr("pos", 0L)), NbtUtils.readBlockState((HolderGetter)holderGetter, (CompoundTag)tag.getCompoundOrEmpty("state")));
        }
    }
}

