/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blockentities;

import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.OwnableBlockEntity;
import net.geforcemods.securitycraft.blockentities.BlockPocketManagerBlockEntity;
import net.geforcemods.securitycraft.util.ITickingBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class BlockPocketBlockEntity
extends OwnableBlockEntity
implements ITickingBlockEntity {
    private BlockPocketManagerBlockEntity manager;
    private BlockPos managerPos;

    public BlockPocketBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)SCContent.BLOCK_POCKET_BLOCK_ENTITY.get(), pos, state);
    }

    public void setManager(BlockPocketManagerBlockEntity manager) {
        this.manager = manager;
        this.managerPos = manager.getBlockPos();
        this.setChanged();
        this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
    }

    public void removeManager() {
        this.managerPos = null;
        this.manager = null;
        this.setChanged();
        this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
    }

    public BlockPocketManagerBlockEntity getManager() {
        return this.manager;
    }

    @Override
    public void tick(Level level, BlockPos pos, BlockState state) {
        BlockEntity blockEntity;
        if (this.manager == null && this.managerPos != null && (blockEntity = level.getBlockEntity(this.managerPos)) instanceof BlockPocketManagerBlockEntity) {
            BlockPocketManagerBlockEntity be;
            this.manager = be = (BlockPocketManagerBlockEntity)blockEntity;
        }
    }

    @Override
    public void preRemoveSideEffects(BlockPos pos, BlockState state) {
        if (this.manager != null) {
            this.manager.disableMultiblock();
        }
        super.preRemoveSideEffects(pos, state);
    }

    @Override
    public void saveAdditional(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        if (this.manager != null) {
            tag.putLong("ManagerPos", this.manager.getBlockPos().asLong());
        }
        super.saveAdditional(tag, lookupProvider);
    }

    @Override
    public void loadAdditional(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        super.loadAdditional(tag, lookupProvider);
        if (tag.contains("ManagerPos")) {
            this.managerPos = BlockPos.of((long)tag.getLongOr("ManagerPos", 0L));
        }
    }
}

