/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blockentities;

import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.CustomizableBlockEntity;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.blocks.mines.ClaymoreBlock;
import net.geforcemods.securitycraft.inventory.InsertOnlyInvWrapper;
import net.geforcemods.securitycraft.inventory.LensContainer;
import net.geforcemods.securitycraft.inventory.SingleLensMenu;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.misc.TargetingMode;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.ITickingBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerListener;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.wrapper.InvWrapper;

public class ClaymoreBlockEntity
extends CustomizableBlockEntity
implements ITickingBlockEntity,
MenuProvider,
ContainerListener,
SingleLensMenu.SingleLensContainer {
    private Option.IntOption range = new Option.IntOption("range", 5, 1, 10, 1);
    private Option.IgnoreOwnerOption ignoreOwner = new Option.IgnoreOwnerOption(true);
    private Option.TargetingModeOption targetingMode = new Option.TargetingModeOption(TargetingMode.PLAYERS_AND_MOBS);
    private Option.RespectInvisibilityOption respectInvisibility = new Option.RespectInvisibilityOption();
    private LensContainer lens = new LensContainer(1);
    private int cooldown = -1;

    public ClaymoreBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)SCContent.CLAYMORE_BLOCK_ENTITY.get(), pos, state);
        this.lens.addListener(this);
    }

    @Override
    public void tick(Level level, BlockPos pos, BlockState state) {
        if (((Boolean)state.getValue((Property)ClaymoreBlock.DEACTIVATED)).booleanValue()) {
            return;
        }
        if (this.cooldown > 0) {
            --this.cooldown;
            return;
        }
        if (this.cooldown == 0) {
            ((ClaymoreBlock)state.getBlock()).explode(level, pos);
            return;
        }
        TargetingMode mode = this.getTargetingMode();
        Direction dir = (Direction)state.getValue(ClaymoreBlock.FACING);
        AABB area = switch (dir) {
            case Direction.NORTH -> new AABB(pos).contract(0.0, 0.0, (double)((Integer)this.range.get()).intValue());
            case Direction.SOUTH -> new AABB(pos).contract(0.0, 0.0, (double)(-((Integer)this.range.get()).intValue()));
            case Direction.EAST -> new AABB(pos).contract((double)(-((Integer)this.range.get()).intValue()), 0.0, 0.0);
            case Direction.WEST -> new AABB(pos).contract((double)((Integer)this.range.get()).intValue(), 0.0, 0.0);
            default -> new AABB(pos);
        };
        level.getEntitiesOfClass(LivingEntity.class, area, e -> mode.canAttackEntity((LivingEntity)e, this, this.respectInvisibility::isConsideredInvisible)).stream().findFirst().ifPresent(e -> {
            this.cooldown = 20;
            level.playSound(null, BlockPos.containing((double)((double)this.worldPosition.getX() + 0.5), (double)((double)this.worldPosition.getY() + 0.5), (double)((double)this.worldPosition.getZ() + 0.5)), SoundEvents.LEVER_CLICK, SoundSource.BLOCKS, 0.3f, 0.6f);
        });
    }

    @Override
    public void saveAdditional(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        super.saveAdditional(tag, lookupProvider);
        tag.putInt("cooldown", this.cooldown);
        tag.put("lens", (Tag)this.lens.createTag(lookupProvider));
    }

    @Override
    public void loadAdditional(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        super.loadAdditional(tag, lookupProvider);
        this.cooldown = tag.getIntOr("cooldown", -1);
        tag.getList("lens").ifPresent(inv -> this.lens.fromTag((ListTag)inv, lookupProvider));
    }

    @Override
    public void preRemoveSideEffects(BlockPos pos, BlockState state) {
        if (this.level != null) {
            Containers.dropContents((Level)this.level, (BlockPos)pos, (Container)this.getLensContainer());
        }
        super.preRemoveSideEffects(pos, state);
    }

    public static IItemHandler getCapability(ClaymoreBlockEntity be, Direction side) {
        return BlockUtils.isAllowedToExtractFromProtectedObject(side, be) ? new InvWrapper((Container)be.lens) : new InsertOnlyInvWrapper((Container)be.lens);
    }

    public void writeClientSideData(AbstractContainerMenu menu, RegistryFriendlyByteBuf buffer) {
        super.writeClientSideData(menu, buffer);
        buffer.writeBlockPos(this.worldPosition);
    }

    public void containerChanged(Container container) {
        if (this.level == null) {
            return;
        }
        this.setChanged();
        this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 2);
    }

    public AbstractContainerMenu createMenu(int id, Inventory inventory, Player player) {
        return new SingleLensMenu(id, this.level, this.worldPosition, inventory);
    }

    public Component getDisplayName() {
        return super.getDisplayName();
    }

    @Override
    public Container getLensContainer() {
        return this.lens;
    }

    @Override
    public Option<?>[] customOptions() {
        return new Option[]{this.range, this.ignoreOwner, this.targetingMode, this.respectInvisibility};
    }

    @Override
    public ModuleType[] acceptedModules() {
        return new ModuleType[0];
    }

    @Override
    public boolean ignoresOwner() {
        return (Boolean)this.ignoreOwner.get();
    }

    public TargetingMode getTargetingMode() {
        return (TargetingMode)((Object)this.targetingMode.get());
    }
}

