/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blockentities;

import java.util.UUID;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.CustomizableBlockEntity;
import net.geforcemods.securitycraft.api.ILockable;
import net.geforcemods.securitycraft.api.IPasscodeProtected;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.blocks.DisplayCaseBlock;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.misc.SCSounds;
import net.geforcemods.securitycraft.util.ITickingBlockEntity;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class DisplayCaseBlockEntity
extends CustomizableBlockEntity
implements ITickingBlockEntity,
IPasscodeProtected,
ILockable {
    private Option.BooleanOption sendAllowlistMessage = new Option.SendAllowlistMessageOption(false);
    private Option.BooleanOption sendDenylistMessage = new Option.SendDenylistMessageOption(true);
    private Option.DisabledOption disabled = new Option.DisabledOption(false);
    private Option.SmartModuleCooldownOption smartModuleCooldown = new Option.SmartModuleCooldownOption();
    private long cooldownEnd = 0L;
    private ItemStack displayedStack = ItemStack.EMPTY;
    private boolean hasReceivedData = false;
    private boolean shouldBeOpen;
    private float openness;
    private float oOpenness;
    private byte[] passcode;
    private UUID saltKey;
    private boolean saveSalt = false;

    public DisplayCaseBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)SCContent.DISPLAY_CASE_BLOCK_ENTITY.get(), pos, state);
    }

    public DisplayCaseBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public void tick(Level level, BlockPos pos, BlockState state) {
        this.oOpenness = this.openness;
        if (!this.shouldBeOpen && this.openness > 0.0f) {
            this.openness = Math.max(this.openness - 0.1f, 0.0f);
        } else if (this.shouldBeOpen && this.openness < 1.0f) {
            this.openness = Math.min(this.openness + 0.1f, 1.0f);
        }
    }

    @Override
    public void activate(Player player) {
        Block block;
        if (!this.level.isClientSide && (block = this.getBlockState().getBlock()) instanceof DisplayCaseBlock) {
            DisplayCaseBlock block2 = (DisplayCaseBlock)block;
            block2.activate(this);
        }
    }

    @Override
    public boolean shouldAttemptCodebreak(Player player) {
        if (this.isDisabled()) {
            player.displayClientMessage((Component)Utils.localize("gui.securitycraft:scManual.disabled", new Object[0]), true);
            return false;
        }
        return !this.isOpen() && !this.getDisplayedStack().isEmpty() && IPasscodeProtected.super.shouldAttemptCodebreak(player);
    }

    @Override
    public byte[] getPasscode() {
        return this.passcode == null || this.passcode.length == 0 ? null : this.passcode;
    }

    @Override
    public void setPasscode(byte[] passcode) {
        this.passcode = passcode;
        this.setChanged();
    }

    @Override
    public UUID getSaltKey() {
        return this.saltKey;
    }

    @Override
    public void setSaltKey(UUID saltKey) {
        this.saltKey = saltKey;
    }

    @Override
    public void setSaveSalt(boolean saveSalt) {
        this.saveSalt = saveSalt;
    }

    @Override
    public boolean shouldSaveSalt() {
        return this.saveSalt;
    }

    @Override
    public void saveAdditional(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        super.saveAdditional(tag, lookupProvider);
        if (!this.displayedStack.isEmpty()) {
            tag.put("DisplayedStack", this.displayedStack.save(lookupProvider));
        }
        tag.putBoolean("ShouldBeOpen", this.shouldBeOpen);
        long cooldownLeft = this.getCooldownEnd() - System.currentTimeMillis();
        tag.putLong("cooldownLeft", cooldownLeft <= 0L ? -1L : cooldownLeft);
        this.savePasscodeAndSalt(tag);
    }

    @Override
    public void loadAdditional(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        super.loadAdditional(tag, lookupProvider);
        this.setDisplayedStack(Utils.parseOptional(lookupProvider, tag.getCompoundOrEmpty("DisplayedStack")));
        this.shouldBeOpen = tag.getBooleanOr("ShouldBeOpen", false);
        this.cooldownEnd = System.currentTimeMillis() + tag.getLongOr("cooldownLeft", 0L);
        this.loadSaltKey(tag);
        this.loadPasscode(tag);
        if (this.level != null && this.level.isClientSide && !this.hasReceivedData) {
            this.forceOpen(this.shouldBeOpen);
            this.hasReceivedData = true;
        }
        if (!tag.getBooleanOr("sendMessage", true)) {
            this.sendAllowlistMessage.setValue(false);
            this.sendDenylistMessage.setValue(false);
        }
    }

    @Override
    public void preRemoveSideEffects(BlockPos pos, BlockState state) {
        if (this.level != null) {
            Block.popResource((Level)this.level, (BlockPos)pos, (ItemStack)this.getDisplayedStack());
        }
        super.preRemoveSideEffects(pos, state);
    }

    @Override
    public void startCooldown() {
        if (!this.isOnCooldown()) {
            this.cooldownEnd = System.currentTimeMillis() + (long)((Integer)this.smartModuleCooldown.get() * 50);
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 2);
            this.setChanged();
        }
    }

    @Override
    public long getCooldownEnd() {
        return this.cooldownEnd;
    }

    @Override
    public boolean isOnCooldown() {
        return System.currentTimeMillis() < this.getCooldownEnd();
    }

    @Override
    public ModuleType[] acceptedModules() {
        return new ModuleType[]{ModuleType.ALLOWLIST, ModuleType.DENYLIST, ModuleType.SMART, ModuleType.HARMING};
    }

    @Override
    public Option<?>[] customOptions() {
        return new Option[]{this.sendAllowlistMessage, this.sendDenylistMessage, this.disabled, this.smartModuleCooldown};
    }

    public boolean sendsAllowlistMessage() {
        return (Boolean)this.sendAllowlistMessage.get();
    }

    public boolean sendsDenylistMessage() {
        return (Boolean)this.sendDenylistMessage.get();
    }

    public boolean isDisabled() {
        return (Boolean)this.disabled.get();
    }

    public void setDisplayedStack(ItemStack displayedStack) {
        this.displayedStack = displayedStack;
        this.sync();
    }

    public ItemStack getDisplayedStack() {
        return this.displayedStack;
    }

    public void setOpen(boolean shouldBeOpen) {
        this.level.playSound(null, this.worldPosition, shouldBeOpen ? SCSounds.DISPLAY_CASE_OPEN.event : SCSounds.DISPLAY_CASE_CLOSE.event, SoundSource.BLOCKS, 1.0f, 1.0f);
        this.shouldBeOpen = shouldBeOpen;
        this.sync();
    }

    public void forceOpen(boolean open) {
        this.shouldBeOpen = open;
        this.openness = open ? 1.0f : 0.0f;
        this.oOpenness = this.openness;
        this.sync();
    }

    public float getOpenness(float partialTicks) {
        return Mth.lerp((float)partialTicks, (float)this.oOpenness, (float)this.openness);
    }

    public boolean isOpen() {
        return this.shouldBeOpen;
    }

    private void sync() {
        if (this.level != null && !this.level.isClientSide) {
            this.setChanged();
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 2);
        }
    }
}

