/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blockentities;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.IEMPAffectedBE;
import net.geforcemods.securitycraft.api.ILockable;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.blockentities.DisguisableBlockEntity;
import net.geforcemods.securitycraft.blocks.SonicSecuritySystemBlock;
import net.geforcemods.securitycraft.components.GlobalPositions;
import net.geforcemods.securitycraft.components.Notes;
import net.geforcemods.securitycraft.misc.BlockEntityTracker;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.misc.SCSounds;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.ITickingBlockEntity;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;

public class SonicSecuritySystemBlockEntity
extends DisguisableBlockEntity
implements ITickingBlockEntity,
IEMPAffectedBE {
    private static final int PING_DELAY = 100;
    private static final int LISTEN_DELAY = 60;
    public static final int MAX_RANGE = 30;
    public static final int MAX_LINKED_BLOCKS = 30;
    private boolean emitsPings = true;
    private int pingCooldown = 100;
    private Option.IntOption signalLength = new Option.IntOption("signalLength", 60, 5, 400, 5);
    private int powerCooldown = 0;
    private float radarRotationDegrees = 0.0f;
    private float oRadarRotationDegrees = 0.0f;
    private List<GlobalPos> linkedBlocks = new ArrayList<GlobalPos>();
    private boolean isActive = true;
    private boolean isRecording = false;
    private List<Notes.NoteWrapper> recordedNotes = new ArrayList<Notes.NoteWrapper>();
    private boolean wasCorrectTunePlayed = false;
    private boolean isListening = false;
    private int listeningTimer = 60;
    private int listenPos = 0;
    private boolean tracked = false;
    private boolean shutDown = false;
    private boolean disableBlocksWhenTuneIsPlayed = false;

    public SonicSecuritySystemBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)SCContent.SONIC_SECURITY_SYSTEM_BLOCK_ENTITY.get(), pos, state);
    }

    @Override
    public void tick(Level level, BlockPos pos, BlockState state) {
        if (!this.tracked) {
            BlockEntityTracker.SONIC_SECURITY_SYSTEM.track(this);
            this.tracked = true;
        }
        if (!level.isClientSide) {
            if (!this.isActive()) {
                return;
            }
            if (this.wasCorrectTunePlayed) {
                if (this.powerCooldown > 0) {
                    --this.powerCooldown;
                } else {
                    this.wasCorrectTunePlayed = false;
                    level.setBlockAndUpdate(this.worldPosition, (BlockState)level.getBlockState(this.worldPosition).setValue((Property)SonicSecuritySystemBlock.POWERED, (Comparable)Boolean.valueOf(false)));
                    BlockUtils.updateIndirectNeighbors(level, this.worldPosition, (Block)SCContent.SONIC_SECURITY_SYSTEM.get(), Direction.DOWN);
                }
            }
            if (this.isListening) {
                if (this.listeningTimer > 0) {
                    --this.listeningTimer;
                    return;
                }
                this.stopListening();
            }
            if (this.pingCooldown > 0) {
                --this.pingCooldown;
            } else {
                if (this.linkedBlocks.stream().allMatch(Objects::isNull)) {
                    return;
                }
                ArrayList<GlobalPos> blocksToRemove = new ArrayList<GlobalPos>();
                for (GlobalPos globalPos : this.linkedBlocks) {
                    if (globalPos == null || level.getBlockEntity(globalPos.pos()) instanceof ILockable) continue;
                    blocksToRemove.add(globalPos);
                }
                for (GlobalPos posToRemove : blocksToRemove) {
                    this.delink(posToRemove, false);
                    this.sync();
                }
                if (this.emitsPings && !this.isRecording) {
                    level.playSound(null, this.worldPosition, SCSounds.PING.event, SoundSource.BLOCKS, 0.3f, 1.0f);
                }
                this.pingCooldown = 100;
            }
        } else {
            this.oRadarRotationDegrees = this.getRadarRotationDegrees();
            if (this.isActive() || this.isRecording()) {
                this.radarRotationDegrees = this.getRadarRotationDegrees() + 0.15f;
                if (this.getRadarRotationDegrees() >= 360.0f) {
                    this.radarRotationDegrees = 0.0f;
                }
            }
        }
    }

    @Override
    public void setRemoved() {
        super.setRemoved();
        BlockEntityTracker.SONIC_SECURITY_SYSTEM.stopTracking(this);
    }

    @Override
    public void onModuleRemoved(ItemStack stack, ModuleType module, boolean toggled) {
        if (module == ModuleType.REDSTONE) {
            this.level.setBlockAndUpdate(this.worldPosition, (BlockState)this.level.getBlockState(this.worldPosition).setValue((Property)SonicSecuritySystemBlock.POWERED, (Comparable)Boolean.valueOf(false)));
            BlockUtils.updateIndirectNeighbors(this.level, this.worldPosition, (Block)SCContent.SONIC_SECURITY_SYSTEM.get(), Direction.DOWN);
        }
        super.onModuleRemoved(stack, module, toggled);
    }

    @Override
    public void saveAdditional(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        super.saveAdditional(tag, lookupProvider);
        ListTag list = new ListTag();
        for (GlobalPos blockToSave : this.linkedBlocks) {
            if (blockToSave == null) {
                list.add((Object)new CompoundTag());
                continue;
            }
            list.add((Object)((Tag)GlobalPos.CODEC.encodeStart((DynamicOps)lookupProvider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)blockToSave).getOrThrow()));
        }
        tag.put("linked_blocks", (Tag)list);
        this.saveNotes(tag, lookupProvider);
        tag.putBoolean("emitsPings", this.emitsPings);
        tag.putBoolean("isActive", this.isActive);
        tag.putBoolean("isRecording", this.isRecording);
        tag.putBoolean("isListening", this.isListening);
        tag.putInt("listenPos", this.listenPos);
        tag.putBoolean("correctTuneWasPlayed", this.wasCorrectTunePlayed);
        tag.putInt("powerCooldown", this.powerCooldown);
        tag.putBoolean("shutDown", this.shutDown);
        tag.putBoolean("disableBlocksWhenTuneIsPlayed", this.disableBlocksWhenTuneIsPlayed);
    }

    @Override
    public void loadAdditional(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        super.loadAdditional(tag, lookupProvider);
        this.linkedBlocks = new ArrayList<GlobalPos>();
        if (tag.contains("linked_blocks")) {
            ListTag list = tag.getListOrEmpty("linked_blocks");
            for (Tag entry : list) {
                try {
                    GlobalPos.CODEC.decode((DynamicOps)NbtOps.INSTANCE, (Object)entry).result().ifPresentOrElse(pair -> this.linkedBlocks.add((GlobalPos)pair.getFirst()), () -> this.linkedBlocks.add(null));
                }
                catch (Exception exception) {
                    SecurityCraft.LOGGER.error("Failed to load global pos in Sonic Security System at position {}: {}", new Object[]{this.worldPosition, entry, exception});
                }
            }
        } else if (tag.contains("LinkedBlocks")) {
            ListTag list = tag.getListOrEmpty("LinkedBlocks");
            for (int i = 0; i < list.size(); ++i) {
                CompoundTag linkedBlock = list.getCompoundOrEmpty(i);
                BlockPos linkedBlockPos = Utils.readBlockPos(linkedBlock);
                this.linkedBlocks.add(new GlobalPos(this.level != null ? this.level.dimension() : ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)SecurityCraft.mcResLoc("overworld")), linkedBlockPos));
            }
        }
        this.recordedNotes.clear();
        this.loadNotes(tag);
        this.emitsPings = tag.getBooleanOr("emitsPings", this.emitsPings);
        this.isActive = tag.getBooleanOr("isActive", this.isActive);
        this.isRecording = tag.getBooleanOr("isRecording", false);
        this.isListening = tag.getBooleanOr("isListening", false);
        this.listenPos = tag.getIntOr("listenPos", 0);
        this.wasCorrectTunePlayed = tag.getBooleanOr("correctTuneWasPlayed", false);
        this.powerCooldown = tag.getIntOr("powerCooldown", 0);
        this.shutDown = tag.getBooleanOr("shutDown", false);
        this.disableBlocksWhenTuneIsPlayed = tag.getBooleanOr("disableBlocksWhenTuneIsPlayed", false);
    }

    public void saveNotes(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        ListTag list = new ListTag();
        for (Notes.NoteWrapper note : this.recordedNotes) {
            list.add((Object)((Tag)Notes.NoteWrapper.CODEC.encodeStart((DynamicOps)lookupProvider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)note).getOrThrow()));
        }
        tag.put("notes", (Tag)list);
    }

    public void loadNotes(CompoundTag tag) {
        this.recordedNotes = new ArrayList<Notes.NoteWrapper>();
        if (tag.contains("notes")) {
            this.recordedNotes.addAll(((Notes)((Pair)Notes.CODEC.decode((DynamicOps)NbtOps.INSTANCE, (Object)tag).result().get()).getFirst()).notes());
        } else if (tag.contains("Notes")) {
            ListTag list = tag.getListOrEmpty("Notes");
            for (int i = 0; i < list.size(); ++i) {
                CompoundTag note = list.getCompoundOrEmpty(i);
                this.recordedNotes.add(new Notes.NoteWrapper(note.getIntOr("noteID", 0), note.getStringOr("instrument", ""), note.getStringOr("customSoundId", "")));
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isLinkedToBlock(BlockPos linkedPos) {
        if (this.linkedBlocks.isEmpty()) return false;
        if (!this.linkedBlocks.stream().filter(Objects::nonNull).map(GlobalPos::pos).anyMatch(arg_0 -> ((BlockPos)linkedPos).equals(arg_0))) return false;
        return true;
    }

    public void delink(GlobalPos linkedGlobalPos, boolean shouldSync) {
        if (this.linkedBlocks.isEmpty()) {
            return;
        }
        this.linkedBlocks.remove(linkedGlobalPos);
        if (shouldSync) {
            this.sync();
        }
    }

    public List<GlobalPos> getLinkedBlocks() {
        return this.linkedBlocks;
    }

    public boolean pings() {
        return this.emitsPings;
    }

    public void setPings(boolean pings) {
        this.emitsPings = pings;
    }

    public boolean isActive() {
        return this.isActive && !this.isShutDown();
    }

    public void setActive(boolean active) {
        this.isActive = active;
    }

    public boolean isRecording() {
        return this.isRecording;
    }

    public void setRecording(boolean recording) {
        this.isRecording = recording;
    }

    public boolean isListening() {
        return this.isListening;
    }

    public void startListening() {
        this.isListening = true;
    }

    public void stopListening() {
        this.resetListeningTimer();
        this.listenPos = 0;
        this.isListening = false;
        this.level.updateNeighborsAt(this.worldPosition, (Block)SCContent.SONIC_SECURITY_SYSTEM.get());
        if (!this.level.isClientSide) {
            this.sync();
        }
    }

    public void resetListeningTimer() {
        this.listeningTimer = 60;
    }

    public void recordNote(int noteID, NoteBlockInstrument instrument, String customSoundId) {
        this.recordedNotes.add(new Notes.NoteWrapper(noteID, instrument.getSerializedName(), customSoundId));
        if (!this.level.isClientSide) {
            this.sync();
        }
    }

    public void listenToNote(int noteID, NoteBlockInstrument instrument, String customSoundId) {
        if (this.getNumberOfNotes() == 0 || this.listenPos >= this.getNumberOfNotes()) {
            return;
        }
        if (!this.isListening) {
            this.isListening = true;
            this.sync();
        }
        if (this.recordedNotes.get(this.listenPos++).isSameNote(noteID, instrument, customSoundId)) {
            this.resetListeningTimer();
            if (this.listenPos >= this.recordedNotes.size()) {
                this.wasCorrectTunePlayed = true;
                this.powerCooldown = (Integer)this.signalLength.get();
                if (this.isModuleEnabled(ModuleType.REDSTONE)) {
                    this.level.setBlockAndUpdate(this.getBlockPos(), (BlockState)this.getLevel().getBlockState(this.getBlockPos()).setValue((Property)SonicSecuritySystemBlock.POWERED, (Comparable)Boolean.valueOf(true)));
                    BlockUtils.updateIndirectNeighbors(this.getLevel(), this.getBlockPos(), (Block)SCContent.SONIC_SECURITY_SYSTEM.get(), Direction.DOWN);
                }
            }
        }
    }

    public List<Notes.NoteWrapper> getRecordedNotes() {
        return this.recordedNotes;
    }

    public int getNumberOfNotes() {
        return this.recordedNotes.size();
    }

    public void clearNotes() {
        this.recordedNotes.clear();
    }

    private void sync() {
        this.setChanged();
        this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
    }

    @Override
    public boolean isShutDown() {
        return this.shutDown;
    }

    @Override
    public void setShutDown(boolean shutDown) {
        this.shutDown = shutDown;
    }

    public void setDisableBlocksWhenTuneIsPlayed(boolean disableBlocksWhenTuneIsPlayed) {
        this.disableBlocksWhenTuneIsPlayed = disableBlocksWhenTuneIsPlayed;
    }

    public boolean disablesBlocksWhenTuneIsPlayed() {
        return this.disableBlocksWhenTuneIsPlayed;
    }

    @Override
    public ModuleType[] acceptedModules() {
        return new ModuleType[]{ModuleType.ALLOWLIST, ModuleType.REDSTONE, ModuleType.DISGUISE};
    }

    @Override
    public Option<?>[] customOptions() {
        return new Option[]{this.signalLength};
    }

    public ItemStack getItem() {
        ItemStack stack = new ItemStack((ItemLike)SCContent.SONIC_SECURITY_SYSTEM_ITEM.get());
        stack.applyComponents(this.collectComponents());
        return stack;
    }

    @Override
    protected void applyImplicitComponents(DataComponentGetter input) {
        super.applyImplicitComponents(input);
        GlobalPositions sssLinkedBlocks = (GlobalPositions)input.get(SCContent.SSS_LINKED_BLOCKS);
        this.linkedBlocks = sssLinkedBlocks != null ? sssLinkedBlocks.positions().stream().collect(Collectors.toList()) : new ArrayList<GlobalPos>();
        this.recordedNotes = new ArrayList<Notes.NoteWrapper>(((Notes)input.getOrDefault(SCContent.NOTES, (Object)Notes.EMPTY)).notes());
    }

    @Override
    protected void collectImplicitComponents(DataComponentMap.Builder builder) {
        super.collectImplicitComponents(builder);
        this.linkedBlocks = new ArrayList<GlobalPos>(this.linkedBlocks);
        int linkedBlocksCount = this.linkedBlocks.size();
        if (linkedBlocksCount < 30) {
            for (int i = linkedBlocksCount; i < 30; ++i) {
                this.linkedBlocks.add(null);
            }
        } else if (linkedBlocksCount > 30) {
            this.linkedBlocks = new ArrayList<GlobalPos>(this.linkedBlocks.subList(0, 30));
        }
        builder.set(SCContent.SSS_LINKED_BLOCKS, (Object)new GlobalPositions(new ArrayList<GlobalPos>(this.linkedBlocks)));
        builder.set(SCContent.NOTES, (Object)new Notes(new ArrayList<Notes.NoteWrapper>(this.recordedNotes)));
    }

    @Override
    public void removeComponentsFromTag(CompoundTag tag) {
        super.removeComponentsFromTag(tag);
        tag.remove("linked_blocks");
        tag.remove("notes");
    }

    public boolean wasCorrectTunePlayed() {
        return this.wasCorrectTunePlayed;
    }

    public float getOriginalRadarRotationDegrees() {
        return this.oRadarRotationDegrees;
    }

    public float getRadarRotationDegrees() {
        return this.radarRotationDegrees;
    }
}

