/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blockentities;

import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.OwnableBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class TrackMineBlockEntity
extends OwnableBlockEntity {
    private boolean active = true;

    public TrackMineBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)SCContent.TRACK_MINE_BLOCK_ENTITY.get(), pos, state);
    }

    public void activate() {
        if (!this.active) {
            this.active = true;
            this.setChanged();
        }
    }

    public void deactivate() {
        if (this.active) {
            this.active = false;
            this.setChanged();
        }
    }

    public boolean isActive() {
        return this.active;
    }

    @Override
    public void saveAdditional(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        tag.putBoolean("TrackMineEnabled", this.active);
        super.saveAdditional(tag, lookupProvider);
    }

    @Override
    public void loadAdditional(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        super.loadAdditional(tag, lookupProvider);
        this.active = tag.getBooleanOr("TrackMineEnabled", true);
    }
}

