/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks;

import java.util.Optional;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IDisguisable;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.IPasscodeConvertible;
import net.geforcemods.securitycraft.blockentities.KeypadChestBlockEntity;
import net.geforcemods.securitycraft.blocks.OwnableBlock;
import net.geforcemods.securitycraft.compat.IOverlayDisplay;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.misc.OwnershipEvent;
import net.geforcemods.securitycraft.misc.SaltData;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.CompoundContainer;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.DoubleBlockCombiner;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.world.AuxiliaryLightManager;

public class KeypadChestBlock
extends ChestBlock
implements IOverlayDisplay,
IDisguisable {
    private static final DoubleBlockCombiner.Combiner<ChestBlockEntity, Optional<MenuProvider>> CONTAINER_MERGER = new DoubleBlockCombiner.Combiner<ChestBlockEntity, Optional<MenuProvider>>(){

        public Optional<MenuProvider> acceptDouble(final ChestBlockEntity chest1, final ChestBlockEntity chest2) {
            CompoundContainer chestInventory = new CompoundContainer((Container)chest1, (Container)chest2);
            return Optional.of(new MenuProvider(){
                final /* synthetic */ Container val$chestInventory;
                {
                    this.val$chestInventory = container;
                }

                public AbstractContainerMenu createMenu(int id, Inventory inventory, Player player) {
                    if (chest1.canOpen(player) && chest2.canOpen(player)) {
                        chest1.unpackLootTable(inventory.player);
                        chest2.unpackLootTable(inventory.player);
                        return ChestMenu.sixRows((int)id, (Inventory)inventory, (Container)this.val$chestInventory);
                    }
                    return null;
                }

                public Component getDisplayName() {
                    if (((KeypadChestBlockEntity)chest1).isModuleEnabled(ModuleType.DISGUISE)) {
                        return Utils.localize(IDisguisable.getDisguisedBlockState((BlockEntity)chest1).orElse(chest1.getBlockState()).getBlock().getDescriptionId(), new Object[0]);
                    }
                    if (chest1.hasCustomName()) {
                        return chest1.getDisplayName();
                    }
                    return chest2.hasCustomName() ? chest2.getDisplayName() : Utils.localize("block.securitycraft.keypad_chest_double", new Object[0]);
                }
            });
        }

        public Optional<MenuProvider> acceptSingle(ChestBlockEntity be) {
            return Optional.of(be);
        }

        public Optional<MenuProvider> acceptNone() {
            return Optional.empty();
        }
    };
    private final float destroyTimeForOwner = OwnableBlock.getStoredDestroyTime();

    public KeypadChestBlock(BlockBehaviour.Properties properties) {
        super(SCContent.KEYPAD_CHEST_BLOCK_ENTITY, OwnableBlock.withReinforcedDestroyTime(properties));
    }

    public float getDestroyProgress(BlockState state, Player player, BlockGetter level, BlockPos pos) {
        return BlockUtils.getDestroyProgress((x$0, x$1, x$2, x$3) -> super.getDestroyProgress(x$0, x$1, x$2, x$3), this.destroyTimeForOwner, state, player, level, pos);
    }

    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        KeypadChestBlockEntity be;
        if (!level.isClientSide && !KeypadChestBlock.isBlocked(level, pos) && (be = (KeypadChestBlockEntity)level.getBlockEntity(pos)).verifyPasscodeSet(level, pos, be, player)) {
            if (be.isDenied((Entity)player)) {
                if (be.sendsDenylistMessage()) {
                    PlayerUtils.sendMessageToPlayer(player, Utils.localize(this.getDescriptionId(), new Object[0]), Utils.localize("messages.securitycraft:module.onDenylist", new Object[0]), ChatFormatting.RED);
                }
            } else if (be.isAllowed((Entity)player)) {
                if (be.sendsAllowlistMessage()) {
                    PlayerUtils.sendMessageToPlayer(player, Utils.localize(this.getDescriptionId(), new Object[0]), Utils.localize("messages.securitycraft:module.onAllowlist", new Object[0]), ChatFormatting.GREEN);
                }
                this.activate(state, level, pos, player);
            } else {
                be.openPasscodeGUI(level, pos, player);
            }
        }
        return InteractionResult.SUCCESS;
    }

    public void activate(BlockState state, Level level, BlockPos pos, Player player) {
        KeypadChestBlock block;
        MenuProvider menuProvider;
        if (!level.isClientSide && (menuProvider = (block = (KeypadChestBlock)state.getBlock()).getMenuProvider(state, level, pos)) != null) {
            player.openMenu(menuProvider);
            player.awardStat(Stats.CUSTOM.get((Object)Stats.OPEN_CHEST));
        }
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, LivingEntity entity, ItemStack stack) {
        super.setPlacedBy(level, pos, state, entity, stack);
        if (entity instanceof Player) {
            Player player = (Player)entity;
            NeoForge.EVENT_BUS.post((Event)new OwnershipEvent(level, pos, player));
            if (state.getValue((Property)TYPE) != ChestType.SINGLE) {
                KeypadChestBlockEntity thisBe = (KeypadChestBlockEntity)level.getBlockEntity(pos);
                BlockEntity otherBe = level.getBlockEntity(pos.relative(KeypadChestBlock.getConnectedDirection((BlockState)state)));
                if (otherBe instanceof KeypadChestBlockEntity) {
                    KeypadChestBlockEntity be = (KeypadChestBlockEntity)otherBe;
                    if (thisBe.getOwner().owns(be)) {
                        for (ModuleType type : be.getInsertedModules()) {
                            thisBe.insertModule(be.getModule(type), false);
                        }
                        thisBe.readOptions(be.writeOptions(new CompoundTag()));
                        if (be.getSaltKey() != null) {
                            thisBe.setSaltKey(SaltData.copySaltToNewKey(be.getSaltKey()));
                        }
                        thisBe.setPasscode(be.getPasscode());
                    }
                }
            }
        }
    }

    public Direction candidatePartnerFacing(BlockPlaceContext ctx, Direction dir) {
        IOwnable ownable;
        BlockEntity blockEntity;
        Direction returnValue = super.candidatePartnerFacing(ctx, dir);
        if (returnValue != null && (blockEntity = ctx.getLevel().getBlockEntity(ctx.getClickedPos().relative(dir))) instanceof IOwnable && (ownable = (IOwnable)blockEntity).isOwnedBy((Entity)ctx.getPlayer())) {
            return returnValue;
        }
        return null;
    }

    public boolean isSignalSource(BlockState state) {
        return true;
    }

    public int getSignal(BlockState state, BlockGetter level, BlockPos pos, Direction side) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof KeypadChestBlockEntity) {
            KeypadChestBlockEntity be = (KeypadChestBlockEntity)blockEntity;
            return be.isModuleEnabled(ModuleType.REDSTONE) ? Mth.clamp((int)be.getNumPlayersUsing(), (int)0, (int)15) : 0;
        }
        return 0;
    }

    public int getDirectSignal(BlockState state, BlockGetter level, BlockPos pos, Direction side) {
        return side == Direction.UP ? state.getSignal(level, pos, side) : 0;
    }

    public void onNeighborChange(BlockState state, LevelReader level, BlockPos pos, BlockPos neighbor) {
        super.onNeighborChange(state, level, pos, neighbor);
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof KeypadChestBlockEntity) {
            KeypadChestBlockEntity be = (KeypadChestBlockEntity)blockEntity;
            be.setBlockState(state);
        }
    }

    public MenuProvider getMenuProvider(BlockState state, Level level, BlockPos pos) {
        return ((Optional)this.combine(state, level, pos, false).apply(CONTAINER_MERGER)).orElse(null);
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new KeypadChestBlockEntity(pos, state);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return level.isClientSide ? KeypadChestBlock.createTickerHelper(type, (BlockEntityType)((BlockEntityType)SCContent.KEYPAD_CHEST_BLOCK_ENTITY.get()), ChestBlockEntity::lidAnimateTick) : null;
    }

    public static boolean isBlocked(Level level, BlockPos pos) {
        return KeypadChestBlock.isBelowSolidBlock(level, pos);
    }

    private static boolean isBelowSolidBlock(Level level, BlockPos pos) {
        return level.getBlockState(pos.above()).isRedstoneConductor((BlockGetter)level, pos.above());
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        BlockState disguisedState = IDisguisable.getDisguisedBlockState(level.getBlockEntity(pos)).orElse(state);
        if (disguisedState.getBlock() != this) {
            return disguisedState.getShape(level, pos, ctx);
        }
        return super.getShape(state, level, pos, ctx);
    }

    public int getLightEmission(BlockState state, BlockGetter level, BlockPos pos) {
        AuxiliaryLightManager lightManager = level.getAuxLightManager(pos);
        int lightValue = 0;
        if (lightManager != null) {
            lightValue = lightManager.getLightAt(pos);
        }
        return lightValue > 0 ? lightValue : super.getLightEmission(state, level, pos);
    }

    public SoundType getSoundType(BlockState state, LevelReader level, BlockPos pos, Entity entity) {
        BlockState disguisedState = IDisguisable.getDisguisedBlockState(level.getBlockEntity(pos)).orElse(state);
        if (disguisedState.getBlock() != this) {
            return disguisedState.getSoundType(level, pos, entity);
        }
        return super.getSoundType(state, level, pos, entity);
    }

    public float getShadeBrightness(BlockState state, BlockGetter level, BlockPos pos) {
        BlockState disguisedState = IDisguisable.getDisguisedBlockState(level.getBlockEntity(pos)).orElse(state);
        if (disguisedState.getBlock() != this) {
            return disguisedState.getShadeBrightness(level, pos);
        }
        return super.getShadeBrightness(state, level, pos);
    }

    public BlockState getAppearance(BlockState state, BlockAndTintGetter level, BlockPos pos, Direction side, BlockState queryState, BlockPos queryPos) {
        return IDisguisable.getDisguisedBlockState(level.getBlockEntity(pos)).orElse(state);
    }

    @Override
    public ItemStack getDisplayStack(Level level, BlockState state, BlockPos pos) {
        return this.getDisguisedStack((BlockGetter)level, pos);
    }

    @Override
    public boolean shouldShowSCInfo(Level level, BlockState state, BlockPos pos) {
        return this.getDisguisedStack((BlockGetter)level, pos).getItem() == this.asItem();
    }

    public ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState state, boolean includeData, Player player) {
        if (IDisguisable.shouldPickBlockDisguise((BlockGetter)level, pos, player)) {
            return this.getDisguisedStack((BlockGetter)level, pos);
        }
        return super.getCloneItemStack(level, pos, state, includeData, player);
    }

    public boolean hasDynamicLightEmission(BlockState state) {
        return true;
    }

    public static class Convertible
    implements IPasscodeConvertible {
        @Override
        public boolean isUnprotectedBlock(BlockState state) {
            return state.is(Tags.Blocks.CHESTS_WOODEN);
        }

        @Override
        public boolean isProtectedBlock(BlockState state) {
            return state.is((Block)SCContent.KEYPAD_CHEST.get());
        }

        @Override
        public boolean protect(Player player, Level level, BlockPos pos) {
            this.convert(player, level, pos, true);
            return true;
        }

        @Override
        public boolean unprotect(Player player, Level level, BlockPos pos) {
            this.convert(player, level, pos, false);
            return true;
        }

        @Override
        public int getRequiredKeyPanels(BlockState state) {
            return state.getValue((Property)ChestBlock.TYPE) != ChestType.SINGLE ? 2 : 1;
        }

        private void convert(Player player, Level level, BlockPos pos, boolean protect) {
            BlockState state = level.getBlockState(pos);
            Direction facing = (Direction)state.getValue((Property)ChestBlock.FACING);
            ChestType type = (ChestType)state.getValue((Property)ChestBlock.TYPE);
            ChestBlockEntity chest = (ChestBlockEntity)level.getBlockEntity(pos);
            if (!protect) {
                ((IModuleInventory)chest).dropAllModules();
            }
            this.convertSingleChest(chest, player, level, pos, state, facing, type, protect);
            if (type != ChestType.SINGLE) {
                BlockPos newPos = pos.relative(ChestBlock.getConnectedDirection((BlockState)state));
                BlockState newState = level.getBlockState(newPos);
                this.convertSingleChest((ChestBlockEntity)level.getBlockEntity(newPos), player, level, newPos, newState, facing, type.getOpposite(), protect);
            }
        }

        private void convertSingleChest(ChestBlockEntity chest, Player player, Level level, BlockPos pos, BlockState oldChestState, Direction facing, ChestType type, boolean protect) {
            Block convertedBlock = protect ? (Block)SCContent.KEYPAD_CHEST.get() : BuiltInRegistries.BLOCK.get(((KeypadChestBlockEntity)chest).getPreviousChest()).map(Holder.Reference::value).orElse(Blocks.CHEST);
            chest.unpackLootTable(player);
            CompoundTag tag = chest.saveWithFullMetadata((HolderLookup.Provider)level.registryAccess());
            chest.clearContent();
            level.setBlockAndUpdate(pos, (BlockState)((BlockState)convertedBlock.defaultBlockState().setValue((Property)ChestBlock.FACING, (Comparable)facing)).setValue((Property)ChestBlock.TYPE, (Comparable)type));
            chest = (ChestBlockEntity)level.getBlockEntity(pos);
            chest.loadWithComponents(tag, (HolderLookup.Provider)level.registryAccess());
            if (protect) {
                if (player != null) {
                    ((IOwnable)chest).setOwner(player.getUUID().toString(), player.getName().getString());
                }
                ((KeypadChestBlockEntity)chest).setPreviousChest(oldChestState.getBlock());
            }
        }
    }
}

