/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks;

import java.util.stream.Stream;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IDisguisable;
import net.geforcemods.securitycraft.blockentities.TrophySystemBlockEntity;
import net.geforcemods.securitycraft.blocks.DisguisableBlock;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.LevelUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class TrophySystemBlock
extends DisguisableBlock {
    private static final VoxelShape SHAPE = Stream.of(Shapes.box((double)0.3125, (double)0.625, (double)0.3125, (double)0.6875, (double)1.0, (double)0.6875), Shapes.box((double)0.375, (double)0.375, (double)0.375, (double)0.625, (double)0.625, (double)0.625), Shapes.box((double)0.4375, (double)0.4375, (double)0.625, (double)0.5625, (double)0.5625, (double)0.875), Shapes.box((double)0.375, (double)0.5, (double)0.8125, (double)0.625, (double)0.75, (double)1.0), Shapes.box((double)0.0, (double)0.5, (double)0.375, (double)0.1875, (double)0.75, (double)0.625), Shapes.box((double)0.625, (double)0.4375, (double)0.4375, (double)0.875, (double)0.5625, (double)0.5625), Shapes.box((double)0.125, (double)0.4375, (double)0.4375, (double)0.375, (double)0.5625, (double)0.5625), Shapes.box((double)0.8125, (double)0.5, (double)0.375, (double)1.0, (double)0.75, (double)0.625), Shapes.box((double)0.4375, (double)0.4375, (double)0.125, (double)0.5625, (double)0.5625, (double)0.375), Shapes.box((double)0.375, (double)0.5, (double)0.0, (double)0.625, (double)0.75, (double)0.1875), Shapes.box((double)0.4375, (double)0.1875, (double)0.4375, (double)0.5625, (double)0.375, (double)0.5625)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).orElse(Shapes.block());

    public TrophySystemBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        return BlockUtils.isSideSolid(level, pos.below(), Direction.UP);
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, Orientation orientation, boolean flag) {
        if (!this.canSurvive(state, (LevelReader)level, pos)) {
            level.destroyBlock(pos, true);
        }
    }

    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        TrophySystemBlockEntity be;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof TrophySystemBlockEntity && (be = (TrophySystemBlockEntity)blockEntity).isOwnedBy((Entity)player)) {
            if (!level.isClientSide) {
                if (be.isDisabled()) {
                    player.displayClientMessage((Component)Utils.localize("gui.securitycraft:scManual.disabled", new Object[0]), true);
                } else {
                    player.openMenu((MenuProvider)be);
                }
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Override
    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        BlockState disguisedState = IDisguisable.getDisguisedBlockState(level.getBlockEntity(pos)).orElse(state);
        if (disguisedState.getBlock() != this) {
            return disguisedState.getShape(level, pos, ctx);
        }
        return SHAPE;
    }

    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        BlockEntity blockEntity;
        if (player.isCreative() && (blockEntity = level.getBlockEntity(pos)) instanceof TrophySystemBlockEntity) {
            TrophySystemBlockEntity inv = (TrophySystemBlockEntity)blockEntity;
            inv.getInventory().clear();
        }
        return super.playerWillDestroy(level, pos, state, player);
    }

    public void affectNeighborsAfterRemoval(BlockState state, ServerLevel level, BlockPos pos, boolean isMoving) {
        level.updateNeighbourForOutputSignal(pos, (Block)this);
        super.affectNeighborsAfterRemoval(state, level, pos, isMoving);
    }

    @Override
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new TrophySystemBlockEntity(pos, state);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return TrophySystemBlock.createTickerHelper(type, (BlockEntityType)((BlockEntityType)SCContent.TROPHY_SYSTEM_BLOCK_ENTITY.get()), LevelUtils::blockEntityTicker);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{WATERLOGGED});
    }
}

