/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks.reinforced;

import net.geforcemods.securitycraft.api.IReinforcedBlock;
import net.geforcemods.securitycraft.blocks.reinforced.BaseIronTrapDoorBlock;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.redstone.Orientation;

public class ReinforcedIronTrapDoorBlock
extends BaseIronTrapDoorBlock
implements IReinforcedBlock {
    public ReinforcedIronTrapDoorBlock(BlockBehaviour.Properties properties, BlockSetType blockSetType) {
        super(properties, blockSetType);
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, Orientation orientation, boolean flag) {
        boolean hasActiveSCBlock = BlockUtils.hasActiveSCBlockNextTo(level, pos);
        if (hasActiveSCBlock != (Boolean)state.getValue((Property)OPEN)) {
            level.setBlock(pos, (BlockState)state.setValue((Property)OPEN, (Comparable)Boolean.valueOf(hasActiveSCBlock)), 2);
            this.playSound(null, level, pos, hasActiveSCBlock);
        }
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        boolean hasActiveSCBlock = BlockUtils.hasActiveSCBlockNextTo(ctx.getLevel(), ctx.getClickedPos());
        return (BlockState)((BlockState)super.getStateForPlacement(ctx).setValue((Property)OPEN, (Comparable)Boolean.valueOf(hasActiveSCBlock))).setValue((Property)POWERED, (Comparable)Boolean.valueOf(hasActiveSCBlock));
    }

    @Override
    public Block getVanillaBlock() {
        return Blocks.IRON_TRAPDOOR;
    }

    @Override
    public BlockState convertToReinforced(Level level, BlockPos pos, BlockState vanillaState) {
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)((Direction)vanillaState.getValue((Property)FACING)))).setValue((Property)OPEN, (Comparable)Boolean.valueOf(BlockUtils.hasActiveSCBlockNextTo(level, pos)))).setValue((Property)HALF, (Comparable)((Half)vanillaState.getValue((Property)HALF)))).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)((Boolean)vanillaState.getValue((Property)WATERLOGGED)));
    }

    @Override
    public BlockState convertToVanilla(Level level, BlockPos pos, BlockState reinforcedState) {
        boolean isPowered = level.hasNeighborSignal(pos);
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)((Direction)reinforcedState.getValue((Property)FACING)))).setValue((Property)OPEN, (Comparable)Boolean.valueOf(isPowered))).setValue((Property)HALF, (Comparable)((Half)reinforcedState.getValue((Property)HALF)))).setValue((Property)POWERED, (Comparable)Boolean.valueOf(isPowered))).setValue((Property)WATERLOGGED, (Comparable)((Boolean)reinforcedState.getValue((Property)WATERLOGGED)));
    }
}

