/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.compat.hudmods;

import net.geforcemods.securitycraft.ClientHandler;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.blocks.FakeLavaBlock;
import net.geforcemods.securitycraft.blocks.FakeWaterBlock;
import net.geforcemods.securitycraft.compat.IOverlayDisplay;
import net.geforcemods.securitycraft.compat.hudmods.HudModHandler;
import net.geforcemods.securitycraft.entity.AbstractSecuritySeaBoat;
import net.geforcemods.securitycraft.entity.sentry.Sentry;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.EntityAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IComponentProvider;
import snownee.jade.api.IEntityComponentProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.IWailaClientRegistration;
import snownee.jade.api.IWailaPlugin;
import snownee.jade.api.WailaPlugin;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.ui.IElement;
import snownee.jade.impl.Tooltip;
import snownee.jade.impl.ui.TextElement;

@WailaPlugin(value="securitycraft")
public final class JadeDataProvider
extends HudModHandler
implements IWailaPlugin {
    public void registerClient(IWailaClientRegistration registration) {
        registration.addConfig(SHOW_OWNER, true);
        registration.addConfig(SHOW_MODULES, true);
        registration.addConfig(SHOW_CUSTOM_NAME, true);
        registration.registerBlockComponent((IComponentProvider)new SecurityCraftBlockInfo(), Block.class);
        registration.registerEntityComponent((IComponentProvider)new SecurityCraftEntityInfo(), Sentry.class);
        registration.registerEntityComponent((IComponentProvider)new SecurityCraftEntityInfo(), AbstractSecuritySeaBoat.class);
        registration.addBeforeRenderCallback((tooltip, rect, guiGraphics, accessor) -> ClientHandler.isPlayerMountedOnCamera());
        registration.addRayTraceCallback((hit, accessor, original) -> {
            if (accessor instanceof BlockAccessor) {
                BlockAccessor blockAccessor = (BlockAccessor)accessor;
                Block block = blockAccessor.getBlock();
                if (block instanceof IOverlayDisplay) {
                    BlockPos pos;
                    BlockState state;
                    IOverlayDisplay overlayDisplay = (IOverlayDisplay)block;
                    Level level = blockAccessor.getLevel();
                    if (!overlayDisplay.shouldShowSCInfo(level, state = blockAccessor.getBlockState(), pos = blockAccessor.getPosition())) {
                        return registration.blockAccessor().from(blockAccessor).fakeBlock(overlayDisplay.getDisplayStack(level, state, pos)).build();
                    }
                } else {
                    if (block instanceof FakeWaterBlock) {
                        return registration.blockAccessor().from(blockAccessor).blockState(Blocks.WATER.defaultBlockState()).build();
                    }
                    if (block instanceof FakeLavaBlock) {
                        return registration.blockAccessor().from(blockAccessor).blockState(Blocks.LAVA.defaultBlockState()).build();
                    }
                }
            }
            return accessor;
        });
    }

    private class SecurityCraftBlockInfo
    implements IBlockComponentProvider {
        private SecurityCraftBlockInfo() {
        }

        public void appendTooltip(ITooltip tooltip, BlockAccessor data, IPluginConfig config) {
            Level level = data.getLevel();
            BlockPos pos = data.getPosition();
            BlockState state = data.getBlockState();
            Block block = data.getBlock();
            JadeDataProvider.this.addDisguisedOwnerModuleNameInfo(level, pos, state, block, data.getBlockEntity(), data.getPlayer(), arg_0 -> ((ITooltip)tooltip).add(arg_0), arg_0 -> ((IPluginConfig)config).get(arg_0));
            if (tooltip instanceof Tooltip) {
                Tooltip t = (Tooltip)tooltip;
                if (block instanceof IOverlayDisplay) {
                    IOverlayDisplay overlayDisplay = (IOverlayDisplay)block;
                    ((Tooltip.Line)t.lines.get(0)).alignedElements(IElement.Align.LEFT).set(0, new TextElement((Component)MutableComponent.create((ComponentContents)overlayDisplay.getDisplayStack(level, state, pos).getItemName().getContents()).setStyle(HudModHandler.ITEM_NAME_STYLE)));
                }
            }
        }

        public ResourceLocation getUid() {
            return SecurityCraft.resLoc("block_info");
        }
    }

    private class SecurityCraftEntityInfo
    implements IEntityComponentProvider {
        private SecurityCraftEntityInfo() {
        }

        public void appendTooltip(ITooltip tooltip, EntityAccessor data, IPluginConfig config) {
            JadeDataProvider.this.addEntityInfo(data.getEntity(), data.getPlayer(), arg_0 -> ((ITooltip)tooltip).add(arg_0), arg_0 -> ((IPluginConfig)config).get(arg_0));
        }

        public ResourceLocation getUid() {
            return SecurityCraft.resLoc("entity_info");
        }
    }
}

