/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.entity.camera;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.Window;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.blockentities.FrameBlockEntity;
import net.geforcemods.securitycraft.blockentities.SecurityCameraBlockEntity;
import net.geforcemods.securitycraft.blocks.FrameBlock;
import net.geforcemods.securitycraft.blocks.SecurityCameraBlock;
import net.geforcemods.securitycraft.entity.camera.CameraFeed;
import net.geforcemods.securitycraft.entity.camera.CameraViewAreaExtension;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Camera;
import net.minecraft.client.CameraType;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.chunk.SectionRenderDispatcher;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.SectionPos;
import net.minecraft.util.Mth;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Marker;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import org.lwjgl.glfw.GLFW;

@EventBusSubscriber(modid="securitycraft", value={Dist.CLIENT})
public class FrameFeedHandler {
    private static final Map<GlobalPos, CameraFeed> FRAME_CAMERA_FEEDS = new ConcurrentHashMap<GlobalPos, CameraFeed>();
    private static GlobalPos currentlyCapturedCamera;
    private static double lastFrameRendered;

    public static void captureFrameFeeds(DeltaTracker partialTick) {
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        if (player == null || player.connection.getLevel() == null || !FrameFeedHandler.hasFeeds() || !((Boolean)ConfigHandler.SERVER.frameFeedViewingEnabled.get()).booleanValue() || FrameFeedHandler.isCapturingCamera()) {
            return;
        }
        ProfilerFiller profiler = Profiler.get();
        double currentTime = GLFW.glfwGetTime();
        Map<GlobalPos, CameraFeed> activeFrameCameraFeeds = FrameFeedHandler.getFeedsToRender(mc, currentTime);
        if (activeFrameCameraFeeds.isEmpty()) {
            return;
        }
        lastFrameRendered = currentTime;
        profiler.popPush("securitycraft:frame_level");
        Level level = player.level();
        Camera camera = mc.gameRenderer.getMainCamera();
        Entity oldCamEntity = mc.cameraEntity;
        Window window = mc.getWindow();
        int oldWidth = window.getWidth();
        int oldHeight = window.getHeight();
        ObjectArrayList oldVisibleSections = mc.levelRenderer.visibleSections.clone();
        int newFrameFeedViewDistance = FrameFeedHandler.getFrameFeedViewDistance(null);
        double oldX = player.getX();
        double oldXO = player.xOld;
        double oldY = player.getY();
        double oldYO = player.yOld;
        double oldZ = player.getZ();
        double oldZO = player.zOld;
        float oldXRot = player.getXRot();
        float oldXRotO = player.xRotO;
        float oldYRot = player.getYRot();
        float oldYRotO = player.yRotO;
        float oldEyeHeight = camera.eyeHeight;
        float oldEyeHeightO = camera.eyeHeightOld;
        CameraType oldCameraType = mc.options.getCameraType();
        Marker securityCamera = new Marker(EntityType.MARKER, level);
        Frustum playerFrustum = mc.levelRenderer.getFrustum();
        RenderTarget oldMainRenderTarget = mc.getMainRenderTarget();
        mc.gameRenderer.setRenderBlockOutline(false);
        mc.gameRenderer.setRenderHand(false);
        mc.gameRenderer.setPanoramicMode(true);
        window.setWidth(100);
        window.setHeight(100);
        mc.options.setCameraType(CameraType.FIRST_PERSON);
        camera.eyeHeight = camera.eyeHeightOld = player.getDimensions(Pose.STANDING).eyeHeight();
        mc.renderBuffers().bufferSource().endBatch();
        for (Map.Entry<GlobalPos, CameraFeed> cameraView : activeFrameCameraFeeds.entrySet()) {
            BlockPos pos;
            BlockEntity blockEntity;
            GlobalPos cameraPos = cameraView.getKey();
            if (!cameraPos.dimension().equals(level.dimension()) || !((blockEntity = level.getBlockEntity(pos = cameraPos.pos())) instanceof SecurityCameraBlockEntity)) continue;
            SecurityCameraBlockEntity be = (SecurityCameraBlockEntity)blockEntity;
            CameraFeed feed = cameraView.getValue();
            if (!feed.hasFrameInFrustum(playerFrustum)) continue;
            Vec3 cameraEntityPos = new Vec3((double)pos.getX() + 0.5, (double)((float)pos.getY() - player.getDimensions(Pose.STANDING).eyeHeight()) + 0.5, (double)pos.getZ() + 0.5);
            float cameraXRot = be.getDefaultXRotation();
            float cameraYRot = be.getDefaultYRotation((Direction)be.getBlockState().getValue(SecurityCameraBlock.FACING)) + (float)Mth.lerp((double)partialTick.getGameTimeDeltaPartialTick(false), (double)be.getOriginalCameraRotation(), (double)be.getCameraRotation()) * 57.295776f;
            securityCamera.setPos(cameraEntityPos);
            mc.setCameraEntity((Entity)securityCamera);
            securityCamera.setXRot(cameraXRot);
            securityCamera.setYRot(cameraYRot);
            currentlyCapturedCamera = cameraPos;
            feed.applyVisibleSections((List<SectionRenderDispatcher.RenderSection>)mc.levelRenderer.visibleSections);
            profiler.push("securitycraft:discover_frame_sections");
            feed.discoverVisibleSections(cameraPos, newFrameFeedViewDistance);
            mc.mainRenderTarget = feed.renderTarget();
            try {
                mc.gameRenderer.renderLevel(DeltaTracker.ONE);
            }
            catch (Exception e) {
                PlayerUtils.sendMessageToPlayer((Player)player, Utils.localize(((FrameBlock)((Object)SCContent.FRAME.get())).getDescriptionId(), new Object[0]), Utils.localize("messages.securitycraft:frame.error", new Object[0]), ChatFormatting.RED, true);
                SecurityCraft.LOGGER.error("Frame feed at {} threw an exception while rendering the level. Deactivating clientside rendering for this feed", (Object)be.getBlockPos());
                e.printStackTrace();
                feed.markForRemoval();
            }
            profiler.push("securitycraft:apply_frame_frustum");
            Frustum frustum = LevelRenderer.offsetFrustum((Frustum)mc.levelRenderer.getFrustum());
            if (be.shouldRotate() || !feed.hasVisibleSections() || feed.requiresFrustumUpdate()) {
                feed.updateVisibleSections(frustum);
            }
            profiler.pop();
        }
        securityCamera.discard();
        mc.setCameraEntity(oldCamEntity);
        player.setPosRaw(oldX, oldY, oldZ);
        player.xOld = player.xo = oldXO;
        player.yOld = player.yo = oldYO;
        player.zOld = player.zo = oldZO;
        player.setXRot(oldXRot);
        player.xRotO = oldXRotO;
        player.setYRot(oldYRot);
        player.yRotO = oldYRotO;
        camera.setup((BlockGetter)level, (Entity)(oldCamEntity == null ? player : oldCamEntity), !mc.options.getCameraType().isFirstPerson(), mc.options.getCameraType().isMirrored(), level.tickRateManager().isEntityFrozen(oldCamEntity) ? 1.0f : partialTick.getGameTimeDeltaPartialTick(true));
        camera.eyeHeight = oldEyeHeight;
        camera.eyeHeightOld = oldEyeHeightO;
        mc.options.setCameraType(oldCameraType);
        mc.gameRenderer.setRenderBlockOutline(true);
        mc.levelRenderer.visibleSections.clear();
        mc.levelRenderer.visibleSections.addAll((Collection)oldVisibleSections);
        window.setWidth(oldWidth);
        window.setHeight(oldHeight);
        mc.gameRenderer.setRenderHand(true);
        mc.gameRenderer.setPanoramicMode(false);
        mc.mainRenderTarget = oldMainRenderTarget;
        currentlyCapturedCamera = null;
    }

    @SubscribeEvent
    public static void onClientTickPost(ClientTickEvent.Post event) {
        if (FrameFeedHandler.hasFeeds()) {
            FRAME_CAMERA_FEEDS.entrySet().removeIf(e -> ((CameraFeed)e.getValue()).shouldBeRemoved());
        }
    }

    public static Map<GlobalPos, CameraFeed> getFeedsToRender(Minecraft mc, double currentTime) {
        double feedsToRender = FRAME_CAMERA_FEEDS.size() + 1;
        double fpsCap = ((Integer)ConfigHandler.CLIENT.frameFeedFpsLimit.get()).intValue();
        double frameInterval = 1.0 / fpsCap;
        double activeFramesPerMcFrame = Mth.ceil((double)(fpsCap * feedsToRender / (double)mc.getFps()));
        if (fpsCap < 260.0) {
            HashMap<GlobalPos, CameraFeed> activeFrameCameraFeeds = new HashMap<GlobalPos, CameraFeed>();
            for (Map.Entry<GlobalPos, CameraFeed> cameraView : FRAME_CAMERA_FEEDS.entrySet()) {
                double timeBetweenFrames = frameInterval / feedsToRender;
                double lastActiveTime = cameraView.getValue().lastActiveTime().get();
                if (currentTime < lastActiveTime + frameInterval || currentTime < lastFrameRendered + timeBetweenFrames) continue;
                double d = activeFramesPerMcFrame;
                activeFramesPerMcFrame = d - 1.0;
                if (d <= 0.0) continue;
                cameraView.getValue().lastActiveTime().set(currentTime);
                activeFrameCameraFeeds.put(cameraView.getKey(), cameraView.getValue());
            }
            return activeFrameCameraFeeds;
        }
        return FRAME_CAMERA_FEEDS;
    }

    public static void addFrameLink(FrameBlockEntity be, GlobalPos cameraPos) {
        CameraFeed feed = FRAME_CAMERA_FEEDS.computeIfAbsent(cameraPos, FrameFeedHandler::createFeedForCamera);
        feed.linkFrame(be);
    }

    private static CameraFeed createFeedForCamera(GlobalPos cameraPos) {
        SectionPos cameraSectionPos = SectionPos.of((BlockPos)cameraPos.pos());
        SectionRenderDispatcher.RenderSection startingSection = CameraViewAreaExtension.rawFetch(cameraSectionPos.x(), Mth.clamp((int)cameraSectionPos.y(), (int)CameraViewAreaExtension.minSectionY(), (int)(CameraViewAreaExtension.maxSectionY() - 1)), cameraSectionPos.z(), true);
        return new CameraFeed(cameraPos, startingSection);
    }

    public static void removeFrameLink(GlobalPos cameraPos, FrameBlockEntity be) {
        if (FRAME_CAMERA_FEEDS.containsKey(cameraPos)) {
            FRAME_CAMERA_FEEDS.get(cameraPos).unlinkFrame(be);
        }
    }

    public static void removeAllFrameLinks(GlobalPos cameraPos) {
        if (FRAME_CAMERA_FEEDS.containsKey(cameraPos)) {
            FRAME_CAMERA_FEEDS.remove(cameraPos);
        }
    }

    public static boolean isCapturingCamera() {
        return currentlyCapturedCamera != null;
    }

    public static boolean amIBeingCaptured(SecurityCameraBlockEntity be) {
        return FrameFeedHandler.isCapturingCamera() && currentlyCapturedCamera.pos().equals((Object)be.getBlockPos());
    }

    public static boolean shouldAddChunk(ChunkPos pos, int renderDistance) {
        for (GlobalPos cameraPos : FRAME_CAMERA_FEEDS.keySet()) {
            if (pos.getChessboardDistance(new ChunkPos(cameraPos.pos())) > renderDistance + 1) continue;
            return true;
        }
        return false;
    }

    public static boolean hasFeeds() {
        return !FRAME_CAMERA_FEEDS.isEmpty();
    }

    public static boolean hasFeed(GlobalPos cameraPos) {
        return FRAME_CAMERA_FEEDS.containsKey(cameraPos);
    }

    public static CameraFeed getFeed(GlobalPos cameraPos) {
        return FRAME_CAMERA_FEEDS.get(cameraPos);
    }

    public static void removeAllFeeds() {
        FRAME_CAMERA_FEEDS.clear();
    }

    public static CameraFeed getCurrentlyCapturedFeed() {
        return FrameFeedHandler.getFeed(currentlyCapturedCamera);
    }

    public static int getFrameFeedViewDistance(FrameBlockEntity be) {
        int frameSpecificRenderDistance = be == null ? 32 : be.getChunkLoadingDistanceOption();
        return Math.min(frameSpecificRenderDistance, Math.min((Integer)ConfigHandler.CLIENT.frameFeedRenderDistance.get(), Math.min((Integer)ConfigHandler.SERVER.frameFeedViewDistance.get(), Minecraft.getInstance().options.getEffectiveRenderDistance())));
    }

    static {
        lastFrameRendered = 0.0;
    }
}

