/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.items;

import it.unimi.dsi.fastutil.objects.ReferenceLinkedOpenHashSet;
import java.util.SequencedSet;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.components.OwnerData;
import net.geforcemods.securitycraft.components.PasscodeData;
import net.geforcemods.securitycraft.inventory.BriefcaseMenu;
import net.geforcemods.securitycraft.inventory.ItemContainer;
import net.geforcemods.securitycraft.network.client.OpenScreen;
import net.geforcemods.securitycraft.util.PasscodeUtils;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.PacketDistributor;

public class BriefcaseItem
extends Item {
    public static final TooltipDisplay DEFAULT_TOOLTIP_DISPLAY = new TooltipDisplay(false, (SequencedSet)new ReferenceLinkedOpenHashSet()).withHidden(DataComponents.CONTAINER, true);

    public BriefcaseItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult useOn(UseOnContext ctx) {
        this.handle(ctx.getItemInHand(), ctx.getLevel(), ctx.getPlayer());
        return InteractionResult.CONSUME;
    }

    public InteractionResult use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        this.handle(stack, level, player);
        return InteractionResult.CONSUME;
    }

    private void handle(ItemStack stack, Level level, Player player) {
        if (!level.isClientSide) {
            PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)player), (CustomPacketPayload)new OpenScreen(stack.has(SCContent.PASSCODE_DATA) ? OpenScreen.DataType.CHECK_PASSCODE_FOR_BRIEFCASE : OpenScreen.DataType.SET_PASSCODE_FOR_BRIEFCASE), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public static void checkPasscode(Player player, final ItemStack briefcase, String incomingCode, PasscodeData passcodeData) {
        PasscodeUtils.setOnCooldown(player);
        passcodeData.checkPasscode(briefcase, incomingCode, () -> {
            if (!briefcase.has(SCContent.OWNER_DATA)) {
                briefcase.set(SCContent.OWNER_DATA, (Object)OwnerData.fromPlayer(player));
            }
            player.openMenu(new MenuProvider(){

                public AbstractContainerMenu createMenu(int windowId, Inventory inv, Player player) {
                    return new BriefcaseMenu(windowId, inv, ItemContainer.briefcase(briefcase));
                }

                public Component getDisplayName() {
                    return briefcase.getHoverName();
                }
            });
        });
    }

    public static boolean isOwnedBy(ItemStack briefcase, Player player) {
        OwnerData owner = (OwnerData)briefcase.get(SCContent.OWNER_DATA);
        if (owner != null) {
            String ownerName = owner.name();
            String ownerUUID = owner.uuid();
            return ownerName.isEmpty() || ownerUUID.equals(player.getUUID().toString()) || ownerUUID.equals("ownerUUID") && ownerName.equals(player.getName().getString());
        }
        return false;
    }
}

