/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.items;

import java.util.ArrayList;
import java.util.List;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SCEventHandler;
import net.geforcemods.securitycraft.blockentities.SonicSecuritySystemBlockEntity;
import net.geforcemods.securitycraft.components.Notes;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.tuple.MutablePair;

public class PortableTunePlayerItem
extends Item {
    public PortableTunePlayerItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult useOn(UseOnContext ctx) {
        Player player;
        SonicSecuritySystemBlockEntity be;
        BlockPos pos;
        Level level = ctx.getLevel();
        if (level.getBlockState(pos = ctx.getClickedPos()).getBlock() == SCContent.SONIC_SECURITY_SYSTEM.get() && ((be = (SonicSecuritySystemBlockEntity)level.getBlockEntity(pos)).isOwnedBy((Entity)(player = ctx.getPlayer())) || be.isAllowed((Entity)player))) {
            if (be.getNumberOfNotes() > 0) {
                ctx.getItemInHand().set(SCContent.NOTES, (Object)new Notes(new ArrayList<Notes.NoteWrapper>(be.getRecordedNotes())));
                player.displayClientMessage((Component)Utils.localize("messages.securitycraft:portable_tune_player.tune_saved", new Object[0]), true);
            } else {
                player.displayClientMessage((Component)Utils.localize("messages.securitycraft:portable_tune_player.no_tune", new Object[0]), true);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public InteractionResult use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (!level.isClientSide) {
            boolean isTunePlaying = SCEventHandler.PLAYING_TUNES.containsKey(player);
            if (isTunePlaying) {
                SCEventHandler.PLAYING_TUNES.remove(player);
                return InteractionResult.SUCCESS_SERVER;
            }
            Notes notes = (Notes)stack.get(SCContent.NOTES);
            if (notes != null) {
                SCEventHandler.PLAYING_TUNES.put(player, (MutablePair<Integer, List<Notes.NoteWrapper>>)MutablePair.of((Object)0, new ArrayList<Notes.NoteWrapper>(notes.notes())));
                return InteractionResult.SUCCESS_SERVER;
            }
        }
        return InteractionResult.PASS;
    }
}

