/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.items.properties;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IDisguisable;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.components.CodebreakerData;
import net.geforcemods.securitycraft.items.properties.HitCheck;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.item.properties.select.SelectItemModelProperty;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;

public record CodebreakerState(HitCheck hitCheck) implements SelectItemModelProperty<String>
{
    public static final String DEFAULT = "default";
    public static final String DECODING = "decoding";
    public static final String SUCCESS = "success";
    public static final String FAILURE = "failure";
    public static final SelectItemModelProperty.Type<CodebreakerState, String> TYPE = SelectItemModelProperty.Type.create((MapCodec)RecordCodecBuilder.mapCodec(instance -> instance.group((App)HitCheck.CODEC.fieldOf("hit_check").forGetter(CodebreakerState::hitCheck)).apply((Applicative)instance, CodebreakerState::new)), (Codec)Codec.STRING);

    public String get(ItemStack stack, ClientLevel level, LivingEntity entity, int seed, ItemDisplayContext ctx) {
        Player player;
        BlockHitResult hitResult;
        CodebreakerData codebreakerData = (CodebreakerData)stack.getOrDefault(SCContent.CODEBREAKER_DATA, (Object)CodebreakerData.DEFAULT);
        boolean isPlayer = entity instanceof Player;
        if ((!isPlayer || !((Player)entity).isCreative() && !((Player)entity).isSpectator()) && codebreakerData.wasRecentlyUsed()) {
            return codebreakerData.wasSuccessful() ? SUCCESS : FAILURE;
        }
        if (level != null && isPlayer && (hitResult = HitCheck.getHitResult((Level)level, player = (Player)entity)) != null) {
            IOwnable ownable;
            BlockPos pos = hitResult.getBlockPos();
            BlockEntity be = level.getBlockEntity(pos);
            if (!(be instanceof IOwnable && (ownable = (IOwnable)be).isOwnedBy((Entity)player) || !IDisguisable.getDisguisedBlockState(be).isPresent())) {
                return DEFAULT;
            }
            if (this.hitCheck.isValidHitResult((Level)level, hitResult)) {
                return DECODING;
            }
        }
        return DEFAULT;
    }

    public Codec<String> valueCodec() {
        return Codec.STRING;
    }

    public SelectItemModelProperty.Type<? extends SelectItemModelProperty<String>, String> type() {
        return TYPE;
    }
}

