/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.renderers;

import com.mojang.blaze3d.vertex.PoseStack;
import net.geforcemods.securitycraft.ClientHandler;
import net.geforcemods.securitycraft.blockentities.ProjectorBlockEntity;
import net.geforcemods.securitycraft.blocks.ProjectorBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.util.TriPredicate;

public class ProjectorRenderer
implements BlockEntityRenderer<ProjectorBlockEntity> {
    public static final int RENDER_DISTANCE = 100;
    private final TriPredicate<ProjectorBlockEntity, Boolean, Integer> yLoopBoundary = (be, hanging, y) -> hanging.booleanValue() ? y > -be.getProjectionHeight() : y < be.getProjectionHeight();

    public ProjectorRenderer(BlockEntityRendererProvider.Context ctx) {
    }

    public void render(ProjectorBlockEntity be, float partialTicks, PoseStack pose, MultiBufferSource buffer, int combinedLight, int combinedOverlay, Vec3 cameraPos) {
        ClientHandler.DISGUISED_BLOCK_RENDER_DELEGATE.tryRenderDelegate(be, partialTicks, pose, buffer, combinedLight, combinedOverlay, cameraPos);
        if (be.isActive() && !be.isContainerEmpty()) {
            Level level = be.getLevel();
            BlockState state = be.getProjectedState();
            boolean hanging = (Boolean)be.getBlockState().getValue((Property)ProjectorBlock.HANGING);
            ModelBlockRenderer.enableCaching();
            for (int x = 0; x < be.getProjectionWidth(); ++x) {
                int y = 0;
                while (this.yLoopBoundary.test((Object)be, (Object)hanging, (Object)y)) {
                    pose.pushPose();
                    BlockPos pos = !be.isHorizontal() ? this.translateProjection(be.getBlockPos(), pose, (Direction)be.getBlockState().getValue(ProjectorBlock.FACING), x, y, be.getProjectionRange(), be.getProjectionOffset()) : this.translateProjection(be.getBlockPos(), pose, (Direction)be.getBlockState().getValue(ProjectorBlock.FACING), x, be.getProjectionRange() - 16, y + 1, be.getProjectionOffset());
                    if (pos != null && (be.isOverridingBlocks() || level.isEmptyBlock(pos))) {
                        BlockRenderDispatcher dispatcher = Minecraft.getInstance().getBlockRenderer();
                        BlockStateModel model = dispatcher.getBlockModel(state);
                        dispatcher.renderBatched(state, pos, (BlockAndTintGetter)level, pose, arg_0 -> ((MultiBufferSource)buffer).getBuffer(arg_0), true, model.collectParts((BlockAndTintGetter)be.getLevel(), pos, state, RandomSource.create((long)state.getSeed(pos))));
                        ClientHandler.PROJECTOR_RENDER_DELEGATE.tryRenderDelegate(be, partialTicks, pose, buffer, combinedLight, combinedOverlay, cameraPos);
                    }
                    pose.popPose();
                    y = hanging ? y - 1 : y + 1;
                }
            }
            ModelBlockRenderer.clearCache();
        }
    }

    private BlockPos translateProjection(BlockPos bePos, PoseStack pose, Direction direction, int x, int y, double distance, double offset) {
        BlockPos pos = null;
        switch (direction) {
            case NORTH: {
                pos = BlockPos.containing((double)((double)(bePos.getX() + x) + offset), (double)(bePos.getY() + y), (double)((double)bePos.getZ() + distance));
                pose.translate(0.0 + (double)x + offset, 0.0 + (double)y, distance);
                break;
            }
            case SOUTH: {
                pos = BlockPos.containing((double)((double)(bePos.getX() + x) + offset), (double)(bePos.getY() + y), (double)((double)bePos.getZ() + -distance));
                pose.translate(0.0 + (double)x + offset, 0.0 + (double)y, -distance);
                break;
            }
            case WEST: {
                pos = BlockPos.containing((double)((double)bePos.getX() + distance), (double)(bePos.getY() + y), (double)((double)(bePos.getZ() + x) + offset));
                pose.translate(distance, 0.0 + (double)y, 0.0 + (double)x + offset);
                break;
            }
            case EAST: {
                pos = BlockPos.containing((double)((double)bePos.getX() + -distance), (double)(bePos.getY() + y), (double)((double)(bePos.getZ() + x) + offset));
                pose.translate(-distance, 0.0 + (double)y, 0.0 + (double)x + offset);
                break;
            }
        }
        return pos;
    }

    public boolean shouldRenderOffScreen(ProjectorBlockEntity be) {
        return true;
    }

    public AABB getRenderBoundingBox(ProjectorBlockEntity be) {
        return new AABB(be.getBlockPos()).inflate(100.0);
    }
}

