/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.screen;

import com.mojang.blaze3d.platform.InputConstants;
import java.lang.invoke.LambdaMetafactory;
import java.util.Arrays;
import java.util.Optional;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.blockentities.KeycardReaderBlockEntity;
import net.geforcemods.securitycraft.components.KeycardData;
import net.geforcemods.securitycraft.inventory.KeycardReaderMenu;
import net.geforcemods.securitycraft.items.KeycardItem;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.misc.SCSounds;
import net.geforcemods.securitycraft.network.server.SetKeycardUses;
import net.geforcemods.securitycraft.network.server.SyncKeycardSettings;
import net.geforcemods.securitycraft.screen.components.ActiveBasedTextureButton;
import net.geforcemods.securitycraft.screen.components.TextHoverChecker;
import net.geforcemods.securitycraft.screen.components.TogglePictureButton;
import net.geforcemods.securitycraft.util.ClientUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.PacketDistributor;
import org.apache.commons.lang3.StringUtils;

public class KeycardReaderScreen
extends AbstractContainerScreen<KeycardReaderMenu> {
    private static final ResourceLocation TEXTURE = SecurityCraft.resLoc("textures/gui/container/keycard_reader.png");
    private static final ResourceLocation CONFIRM_SPRITE = SecurityCraft.mcResLoc("container/beacon/confirm");
    private static final ResourceLocation CANCEL_SPRITE = SecurityCraft.mcResLoc("container/beacon/cancel");
    private static final ResourceLocation RANDOM_SPRITE = SecurityCraft.resLoc("widget/random");
    private static final ResourceLocation RANDOM_INACTIVE_SPRITE = SecurityCraft.resLoc("widget/random_inactive");
    private static final ResourceLocation RESET_SPRITE = SecurityCraft.resLoc("widget/reset");
    private static final ResourceLocation RESET_INACTIVE_SPRITE = SecurityCraft.resLoc("widget/reset_inactive");
    private static final ResourceLocation RETURN_SPRITE = SecurityCraft.resLoc("widget/return");
    private static final ResourceLocation RETURN_INACTIVE_SPRITE = SecurityCraft.resLoc("widget/return_inactive");
    private static final ResourceLocation WARNING_HIGHLIGHTED_SPRITE = SecurityCraft.mcResLoc("world_list/warning_highlighted");
    private static final Component EQUALS = Component.literal((String)"=");
    private static final Component GREATER_THAN_EQUALS = Component.literal((String)">=");
    private static final int MAX_SIGNATURE = 99999;
    private final Component signatureText = Utils.localize("gui.securitycraft:keycard_reader.signature", new Object[0]);
    private final Component keycardLevelsText = Utils.localize("gui.securitycraft:keycard_reader.keycard_levels", new Object[0]);
    private final Component linkText = Utils.localize("gui.securitycraft:keycard_reader.link", new Object[0]);
    private final Component levelMismatchInfo = Utils.localize("gui.securitycraft:keycard_reader.level_mismatch", new Object[0]);
    private final Component limitedInfo = Utils.localize("tooltip.securitycraft:keycard.limited_info", new Object[0]);
    private Component smartModuleTooltip;
    private final KeycardReaderBlockEntity be;
    private final boolean hasSmartModule;
    private final boolean isOwner;
    private boolean isExactLevel = true;
    private int previousSignature;
    private int signature;
    private boolean[] acceptedLevels;
    private int signatureTextLength;
    private int signatureTextStartX;
    private Button minusThree;
    private Button minusTwo;
    private Button minusOne;
    private Button reset;
    private Button plusOne;
    private Button plusTwo;
    private Button plusThree;
    private TogglePictureButton[] toggleButtons = new TogglePictureButton[5];
    private EditBox signatureTextField;
    private EditBox usesTextField;
    private EditBox usableByTextField;
    private TextHoverChecker usesHoverChecker;
    private Button setUsesButton;
    private Button linkButton;
    private boolean firstTick = true;

    public KeycardReaderScreen(KeycardReaderMenu menu, Inventory inv, Component title) {
        super((AbstractContainerMenu)menu, inv, title);
        this.be = menu.be;
        this.signature = this.previousSignature = Mth.clamp((int)this.be.getSignature(), (int)0, (int)99999);
        this.acceptedLevels = this.be.getAcceptedLevels();
        this.hasSmartModule = this.be.isModuleEnabled(ModuleType.SMART);
        this.isOwner = this.be.isOwnedBy((Entity)inv.player);
        this.imageHeight = 249;
        this.smartModuleTooltip = this.hasSmartModule ? Utils.localize("gui.securitycraft:keycard_reader.smartModule", new Object[0]) : Utils.localize("gui.securitycraft:keycard_reader.noSmartModule", new Object[0]);
    }

    public void init() {
        super.init();
        int buttonHeight = 13;
        int buttonY = this.topPos + 35;
        int activeButtons = 0;
        int firstActiveButton = -1;
        for (int i = 0; i < 5; ++i) {
            int thisButtonId = i;
            this.toggleButtons[i] = (TogglePictureButton)this.addRenderableWidget((GuiEventListener)new TogglePictureButton(this.leftPos + 100, this.topPos + 50 + (i + 1) * 17, 15, 15, 0, 15, 15, 2, thisButton -> {
                if (!this.hasSmartModule) {
                    for (int otherButtonId = 0; otherButtonId < 5; ++otherButtonId) {
                        boolean active = this.isExactLevel ? otherButtonId == thisButtonId : otherButtonId >= thisButtonId;
                        this.changeLevelState(otherButtonId, active);
                    }
                } else {
                    this.acceptedLevels[thisButtonId] = !this.acceptedLevels[thisButtonId];
                }
            }, CANCEL_SPRITE, CONFIRM_SPRITE));
            this.toggleButtons[i].setCurrentIndex(this.acceptedLevels[i] ? 1 : 0);
            this.toggleButtons[i].active = this.isOwner;
            if (this.hasSmartModule || !this.acceptedLevels[i]) continue;
            if (firstActiveButton == -1) {
                firstActiveButton = i;
            }
            ++activeButtons;
        }
        this.signatureTextLength = this.font.width((FormattedText)this.signatureText);
        this.signatureTextStartX = this.imageWidth / 2 - this.signatureTextLength + 5;
        this.signatureTextField = (EditBox)this.addRenderableWidget((GuiEventListener)new EditBox(this.font, this.leftPos + 96, this.topPos + 21, 40, 12, (Component)Component.empty()));
        this.signatureTextField.setValue(this.leftPaddedSignature());
        this.signatureTextField.setFilter(s -> s.matches("\\d*"));
        this.signatureTextField.setMaxLength(5);
        this.signatureTextField.setResponder(this::changeSignature);
        this.minusThree = (Button)this.addRenderableWidget((GuiEventListener)new Button(this.leftPos + 22, buttonY, 24, buttonHeight, (Component)Component.literal((String)"---"), b -> this.changeSignature(this.signature - 100), Button.DEFAULT_NARRATION));
        this.minusTwo = (Button)this.addRenderableWidget((GuiEventListener)new Button(this.leftPos + 48, buttonY, 18, buttonHeight, (Component)Component.literal((String)"--"), b -> this.changeSignature(this.signature - 10), Button.DEFAULT_NARRATION));
        this.minusOne = (Button)this.addRenderableWidget((GuiEventListener)new Button(this.leftPos + 68, buttonY, 12, buttonHeight, (Component)Component.literal((String)"-"), b -> this.changeSignature(this.signature - 1), Button.DEFAULT_NARRATION));
        this.reset = (Button)this.addRenderableWidget((GuiEventListener)new ActiveBasedTextureButton(this.leftPos + 82, buttonY, 12, buttonHeight, RESET_SPRITE, RESET_INACTIVE_SPRITE, 1, 2, 10, 10, b -> this.changeSignature(this.previousSignature)));
        this.plusOne = (Button)this.addRenderableWidget((GuiEventListener)new Button(this.leftPos + 96, buttonY, 12, buttonHeight, (Component)Component.literal((String)"+"), b -> this.changeSignature(this.signature + 1), Button.DEFAULT_NARRATION));
        this.plusTwo = (Button)this.addRenderableWidget((GuiEventListener)new Button(this.leftPos + 110, buttonY, 18, buttonHeight, (Component)Component.literal((String)"++"), b -> this.changeSignature(this.signature + 10), Button.DEFAULT_NARRATION));
        this.plusThree = (Button)this.addRenderableWidget((GuiEventListener)new Button(this.leftPos + 130, buttonY, 24, buttonHeight, (Component)Component.literal((String)"+++"), b -> this.changeSignature(this.signature + 100), Button.DEFAULT_NARRATION));
        Button randomizeButton = (Button)this.addRenderableWidget((GuiEventListener)new ActiveBasedTextureButton(this.leftPos + 156, buttonY, 12, buttonHeight, RANDOM_SPRITE, RANDOM_INACTIVE_SPRITE, 1, 2, 10, 10, b -> this.changeSignature(SecurityCraft.RANDOM.nextInt(99999))));
        randomizeButton.setTooltip(Tooltip.create((Component)Utils.localize("gui.securitycraft:keycard_reader.randomize_signature", new Object[0])));
        randomizeButton.active = this.isOwner;
        this.changeSignature(this.signature);
        this.linkButton = (Button)this.addRenderableWidget((GuiEventListener)new Button(this.leftPos + 8, this.topPos + 126, 70, 20, this.linkText, b -> {
            this.previousSignature = this.signature;
            this.changeSignature(this.signature);
            PacketDistributor.sendToServer((CustomPacketPayload)new SyncKeycardSettings(this.be.getBlockPos(), this.acceptedLevels, this.signature, true, this.getUsableBy()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            if (((KeycardReaderMenu)this.menu).keycardSlot.getItem().getHoverName().getString().equalsIgnoreCase("Zelda")) {
                this.minecraft.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SCSounds.GET_ITEM.event, (float)1.0f, (float)1.25f));
            }
        }, Button.DEFAULT_NARRATION));
        this.linkButton.active = false;
        this.usableByTextField = (EditBox)this.addRenderableWidget((GuiEventListener)new EditBox(this.font, this.leftPos + 8, this.topPos + 66, 70, 15, (Component)Component.empty()));
        this.usableByTextField.setTooltip(Tooltip.create((Component)Utils.localize("gui.securitycraft:keycard_reader.usable_by.tooltip", new Object[0])));
        this.usableByTextField.setHint((Component)Utils.localize("gui.securitycraft:keycard_reader.usable_by.hint", new Object[0]));
        this.usableByTextField.setMaxLength(16);
        this.setUsesButton = (Button)this.addRenderableWidget((GuiEventListener)new ActiveBasedTextureButton(this.leftPos + 62, this.topPos + 106, 16, 17, RETURN_SPRITE, RETURN_INACTIVE_SPRITE, 2, 2, 14, 14, b -> PacketDistributor.sendToServer((CustomPacketPayload)new SetKeycardUses(this.be.getBlockPos(), Integer.parseInt(this.usesTextField.getValue())), (CustomPacketPayload[])new CustomPacketPayload[0])));
        this.setUsesButton.active = false;
        this.usesTextField = (EditBox)this.addRenderableWidget((GuiEventListener)new EditBox(this.font, this.leftPos + 28, this.topPos + 107, 30, 15, (Component)Component.empty()));
        this.usesTextField.setFilter(s -> s.matches("\\d*"));
        this.usesTextField.setMaxLength(3);
        this.usesHoverChecker = new TextHoverChecker(this.topPos + 107, this.topPos + 122, this.leftPos + 28, this.leftPos + 58, this.limitedInfo);
        if (!this.hasSmartModule) {
            if (activeButtons == 1) {
                this.isExactLevel = true;
            } else if (activeButtons == 0) {
                this.isExactLevel = true;
                this.changeLevelState(0, true);
            } else {
                boolean active = false;
                this.isExactLevel = false;
                for (int i = 0; i < 5; ++i) {
                    if (i == firstActiveButton) {
                        active = true;
                    }
                    this.changeLevelState(i, active);
                }
            }
            ((Button)this.addRenderableWidget((GuiEventListener)new Button((int)(this.leftPos + 135), (int)(this.topPos + 67), (int)18, (int)18, (Component)(this.isExactLevel ? KeycardReaderScreen.EQUALS : KeycardReaderScreen.GREATER_THAN_EQUALS), (Button.OnPress)(Button.OnPress)LambdaMetafactory.metafactory(null, null, null, (Lnet/minecraft/client/gui/components/Button;)V, lambda$init$13(net.minecraft.client.gui.components.Button ), (Lnet/minecraft/client/gui/components/Button;)V)((KeycardReaderScreen)this), (Button.CreateNarration)Button.DEFAULT_NARRATION))).active = this.isOwner;
        }
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.drawString(this.font, this.title, this.imageWidth / 2 - this.font.width((FormattedText)this.title) / 2, 6, 0x404040, false);
        guiGraphics.drawString(this.font, this.signatureText, this.signatureTextStartX, 23, 0x404040, false);
        guiGraphics.drawString(this.font, this.keycardLevelsText, 170 - this.font.width((FormattedText)this.keycardLevelsText), 56, 0x404040, false);
        for (int i = 1; i <= 5; ++i) {
            guiGraphics.drawString(this.font, "" + i, 91, 55 + 17 * i, 0x404040, false);
        }
        guiGraphics.drawString(this.font, Utils.INVENTORY_TEXT, 8, this.imageHeight - 93, 0x404040, false);
    }

    public void containerTick() {
        super.containerTick();
        ItemStack stack = ((KeycardReaderMenu)this.menu).keycardSlot.getItem();
        boolean isEmpty = stack.isEmpty();
        boolean wasActive = this.usesTextField.active;
        KeycardData keycardData = (KeycardData)stack.get(SCContent.KEYCARD_DATA);
        boolean hasData = keycardData != null;
        boolean enabled = !isEmpty && hasData && keycardData.limited();
        int cardSignature = hasData ? keycardData.signature() : -1;
        this.usesTextField.setEditable(enabled);
        this.usesTextField.active = enabled;
        if (!wasActive && enabled) {
            this.usesTextField.setValue("" + keycardData.usesLeft());
        } else if (wasActive && !enabled) {
            this.usesTextField.setValue("");
        }
        if (this.firstTick) {
            this.setUsesButton.active = false;
            this.linkButton.active = false;
            this.firstTick = false;
        } else {
            this.setUsesButton.active = enabled && this.usesTextField.getValue() != null && !this.usesTextField.getValue().isEmpty() && !("" + keycardData.usesLeft()).equals(this.usesTextField.getValue());
            this.linkButton.active = !isEmpty && (cardSignature != this.signature || !keycardData.usableBy().orElse("").equals(this.usableByTextField.getValue()));
        }
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        ItemStack stack = ((KeycardReaderMenu)this.menu).keycardSlot.getItem();
        if (!stack.isEmpty() && !this.acceptedLevels[((KeycardItem)stack.getItem()).getLevel()]) {
            int left = this.leftPos + 18;
            int top = this.topPos + 82;
            guiGraphics.blitSprite(RenderType::guiTextured, WARNING_HIGHLIGHTED_SPRITE, left, top, 24, 24);
            if (mouseX >= left && mouseX <= left + 12 && mouseY >= top && mouseY <= top + 22) {
                guiGraphics.renderComponentTooltip(this.font, Arrays.asList(this.levelMismatchInfo), mouseX, mouseY);
            }
        }
        if (!this.usesTextField.active && !stack.isEmpty() && this.usesHoverChecker.checkHover(mouseX, mouseY)) {
            guiGraphics.renderComponentTooltip(this.font, this.usesHoverChecker.getLines(), mouseX, mouseY);
        }
        this.renderTooltip(guiGraphics, mouseX, mouseY);
        ClientUtils.renderModuleInfo(guiGraphics, this.font, ModuleType.SMART, this.smartModuleTooltip, this.hasSmartModule, this.leftPos + 5, this.topPos + 5, mouseX, mouseY);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        guiGraphics.blit(RenderType::guiTextured, TEXTURE, this.leftPos, this.topPos, 0.0f, 0.0f, this.imageWidth, this.imageHeight, 256, 256);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.minecraft.player.isSpectator()) {
            return false;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (this.isOwner && mouseX >= (double)(this.leftPos + this.signatureTextStartX) && mouseY >= (double)(this.topPos + 23) && mouseX <= (double)(this.leftPos + this.signatureTextStartX + this.signatureTextLength + 42) && mouseY <= (double)(this.topPos + 43)) {
            this.changeSignature(this.signature + (int)Math.signum(scrollY));
        }
        return super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        InputConstants.Key key;
        if (this.usableByTextField.isFocused() && (this.minecraft.options.keyInventory.isActiveAndMatches(key = InputConstants.getKey((int)keyCode, (int)scanCode)) || this.minecraft.options.keySwapOffhand.isActiveAndMatches(key) || this.minecraft.options.keyPickItem.isActiveAndMatches(key))) {
            return false;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public void removed() {
        super.removed();
        if (this.isOwner) {
            this.be.setAcceptedLevels(this.acceptedLevels);
            this.be.setSignature(this.signature);
            PacketDistributor.sendToServer((CustomPacketPayload)new SyncKeycardSettings(this.be.getBlockPos(), this.acceptedLevels, this.signature, false, this.getUsableBy()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public void changeSignature(int newSignature) {
        this.changeSignature(newSignature, false);
    }

    public void changeSignature(String newSignature) {
        if (newSignature != null && !newSignature.isEmpty()) {
            this.changeSignature(Integer.parseInt(newSignature), true);
        }
    }

    public void changeSignature(int newSignature, boolean throughTextField) {
        boolean enableMinusButtons;
        if (this.isOwner) {
            this.signature = Mth.clamp((int)newSignature, (int)0, (int)99999);
        }
        boolean enablePlusButtons = this.isOwner && this.signature != 99999;
        this.minusThree.active = enableMinusButtons = this.isOwner && this.signature != 0;
        this.minusTwo.active = enableMinusButtons;
        this.minusOne.active = enableMinusButtons;
        this.reset.active = this.isOwner && this.signature != this.previousSignature;
        this.plusOne.active = enablePlusButtons;
        this.plusTwo.active = enablePlusButtons;
        this.plusThree.active = enablePlusButtons;
        if (!throughTextField) {
            String textFieldValue = this.leftPaddedSignature();
            if (!this.signatureTextField.getValue().equals(textFieldValue)) {
                this.signatureTextField.setValue(textFieldValue);
            }
        }
    }

    public void changeLevelState(int i, boolean active) {
        if (this.isOwner) {
            this.toggleButtons[i].setCurrentIndex(active ? 1 : 0);
        }
        this.acceptedLevels[i] = active;
    }

    public Optional<String> getUsableBy() {
        String message = this.usableByTextField.getValue();
        if (message == null || message.isBlank()) {
            return Optional.empty();
        }
        return Optional.of(message);
    }

    private String leftPaddedSignature() {
        return StringUtils.leftPad((String)("" + this.signature), (int)5, (String)"0");
    }

    private /* synthetic */ void lambda$init$13(Button b) {
        boolean change = false;
        this.isExactLevel = !this.isExactLevel;
        for (int i = 0; i < 5; ++i) {
            if (change) {
                this.changeLevelState(i, !this.isExactLevel);
                continue;
            }
            change = this.acceptedLevels[i];
        }
        b.setMessage(this.isExactLevel ? EQUALS : GREATER_THAN_EQUALS);
    }
}

