/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.screen;

import com.mojang.blaze3d.platform.InputConstants;
import java.util.Map;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.blockentities.LaserBlockBlockEntity;
import net.geforcemods.securitycraft.inventory.LaserBlockMenu;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.network.server.SyncLaserSideConfig;
import net.geforcemods.securitycraft.screen.components.CallbackCheckbox;
import net.geforcemods.securitycraft.util.ClientUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.neoforge.network.PacketDistributor;

public class LaserBlockScreen
extends AbstractContainerScreen<LaserBlockMenu> {
    private static final ResourceLocation TEXTURE = SecurityCraft.resLoc("textures/gui/container/laser_block.png");
    private final boolean hasSmartModule;
    private Component smartModuleTooltip;
    private LaserBlockBlockEntity be;
    private Map<Direction, Boolean> sideConfig;

    public LaserBlockScreen(LaserBlockMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
        this.be = menu.be;
        this.sideConfig = menu.sideConfig;
        this.hasSmartModule = this.be.isModuleEnabled(ModuleType.SMART);
        this.imageHeight = 256;
    }

    public void init() {
        super.init();
        this.titleLabelX = this.imageWidth / 2 - this.font.width((FormattedText)this.title) / 2;
        this.inventoryLabelY = this.imageHeight - 94;
        this.sideConfig.forEach((dir, enabled) -> {
            CallbackCheckbox checkbox = new CallbackCheckbox(this.leftPos + 40, this.topPos + dir.get3DDataValue() * 22 + 25, 20, 20, (Component)Utils.localize("gui.securitycraft:laser." + dir.getName() + "Enabled", new Object[0]), (boolean)enabled, newValue -> this.onChangeValue((Direction)dir, (boolean)newValue), 0x404040){

                @Override
                public void onPress() {
                    if (LaserBlockScreen.this.hasSmartModule) {
                        super.onPress();
                    }
                }
            };
            checkbox.active = this.be.isEnabled();
            this.addRenderableWidget((GuiEventListener)checkbox);
        });
        this.smartModuleTooltip = this.hasSmartModule ? Utils.localize("gui.securitycraft:laser.smartModule", new Object[0]) : Utils.localize("gui.securitycraft:laser.noSmartModule", new Object[0]);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        guiGraphics.blit(RenderType::guiTextured, TEXTURE, this.leftPos, this.topPos, 0.0f, 0.0f, this.imageWidth, this.imageHeight, 256, 256);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
        ClientUtils.renderModuleInfo(guiGraphics, this.font, ModuleType.SMART, this.smartModuleTooltip, this.hasSmartModule, this.leftPos + 5, this.topPos + 5, mouseX, mouseY);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.minecraft.player.isSpectator()) {
            return false;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public void onChangeValue(Direction dir, boolean newValue) {
        this.sideConfig.put(dir, newValue);
        PacketDistributor.sendToServer((CustomPacketPayload)new SyncLaserSideConfig(this.be.getBlockPos(), LaserBlockBlockEntity.saveSideConfig(this.sideConfig)), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public boolean isPauseScreen() {
        return false;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.minecraft.options.keyInventory.isActiveAndMatches(InputConstants.getKey((int)keyCode, (int)scanCode))) {
            this.onClose();
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }
}

