/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.screen.components;

import java.util.function.Consumer;
import net.geforcemods.securitycraft.SecurityCraft;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class CallbackCheckbox
extends AbstractButton {
    private static final ResourceLocation CHECKBOX_SELECTED_HIGHLIGHTED_SPRITE = SecurityCraft.mcResLoc("widget/checkbox_selected_highlighted");
    private static final ResourceLocation CHECKBOX_SELECTED_SPRITE = SecurityCraft.mcResLoc("widget/checkbox_selected");
    private static final ResourceLocation CHECKBOX_HIGHLIGHTED_SPRITE = SecurityCraft.mcResLoc("widget/checkbox_highlighted");
    private static final ResourceLocation CHECKBOX_SPRITE = SecurityCraft.mcResLoc("widget/checkbox");
    private boolean selected;
    private final Consumer<Boolean> onChange;
    private final int textColor;

    public CallbackCheckbox(int x, int y, int width, int height, Component message, boolean selected, Consumer<Boolean> onChange, int textColor) {
        super(x, y, width, height, message);
        this.selected = selected;
        this.onChange = onChange;
        this.textColor = textColor;
    }

    public void onPress() {
        this.setSelected(!this.selected);
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        Minecraft minecraft = Minecraft.getInstance();
        ResourceLocation sprite = this.selected ? (this.isFocused() ? CHECKBOX_SELECTED_HIGHLIGHTED_SPRITE : CHECKBOX_SELECTED_SPRITE) : (this.isFocused() ? CHECKBOX_HIGHLIGHTED_SPRITE : CHECKBOX_SPRITE);
        guiGraphics.blitSprite(RenderType::guiTextured, sprite, this.getX(), this.getY(), this.width, this.height);
        guiGraphics.drawString(minecraft.font, this.getMessage(), this.getX() + (int)((float)this.width * 1.2f), this.getY() + (this.height - 8) / 2, this.textColor | Mth.ceil((float)(this.alpha * 255.0f)) << 24, false);
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
        narrationElementOutput.add(NarratedElementType.TITLE, (Component)this.createNarrationMessage());
        if (this.active) {
            if (this.isFocused()) {
                narrationElementOutput.add(NarratedElementType.USAGE, (Component)Component.translatable((String)"narration.checkbox.usage.focused"));
            } else {
                narrationElementOutput.add(NarratedElementType.USAGE, (Component)Component.translatable((String)"narration.checkbox.usage.hovered"));
            }
        }
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
        this.onChange.accept(selected);
    }

    public boolean selected() {
        return this.selected;
    }
}

