/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.screen.components;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;

public class PictureButton
extends Button {
    private ItemStack blockToRender = ItemStack.EMPTY;
    private ItemStack itemToRender = ItemStack.EMPTY;
    private ResourceLocation sprite;
    private int drawOffsetX;
    private int drawOffsetY;
    private int drawWidth;
    private int drawHeight;

    public PictureButton(int xPos, int yPos, int width, int height, ItemStack itemToRender) {
        this(xPos, yPos, width, height, itemToRender, b -> {});
    }

    public PictureButton(int xPos, int yPos, int width, int height, ItemStack itemToRender, Button.OnPress onPress) {
        super(xPos, yPos, width, height, (Component)Component.empty(), onPress, DEFAULT_NARRATION);
        if (!itemToRender.isEmpty() && itemToRender.getItem() instanceof BlockItem) {
            this.blockToRender = new ItemStack((ItemLike)Block.byItem((Item)itemToRender.getItem()));
        } else {
            this.itemToRender = new ItemStack((ItemLike)itemToRender.getItem());
        }
    }

    public PictureButton(int xPos, int yPos, int width, int height, ResourceLocation sprite, int drawOffsetX, int drawOffsetY, int drawWidth, int drawHeight, Button.OnPress onPress) {
        super(xPos, yPos, width, height, (Component)Component.empty(), onPress, DEFAULT_NARRATION);
        this.sprite = sprite;
        this.drawOffsetX = drawOffsetX;
        this.drawOffsetY = drawOffsetY;
        this.drawWidth = drawWidth;
        this.drawHeight = drawHeight;
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        if (this.visible) {
            Minecraft mc = Minecraft.getInstance();
            Font font = mc.font;
            this.isHovered = mouseX >= this.getX() && mouseY >= this.getY() && mouseX < this.getX() + this.width && mouseY < this.getY() + this.height;
            guiGraphics.blitSprite(RenderType::guiTextured, SPRITES.get(this.active, this.isHoveredOrFocused()), this.getX(), this.getY(), this.getWidth(), this.getHeight());
            if (!this.blockToRender.isEmpty()) {
                guiGraphics.renderItem(this.blockToRender, this.getX() + 2, this.getY() + 3);
                guiGraphics.renderItemDecorations(font, this.blockToRender, this.getX() + 2, this.getY() + 3, "");
            } else if (!this.itemToRender.isEmpty()) {
                guiGraphics.renderItem(this.itemToRender, this.getX() + 2, this.getY() + 2);
                guiGraphics.renderItemDecorations(font, this.itemToRender, this.getX() + 2, this.getY() + 2, "");
            } else if (this.getSpriteLocation() != null) {
                guiGraphics.blitSprite(RenderType::guiTextured, this.getSpriteLocation(), this.getX() + this.drawOffsetX, this.getY() + this.drawOffsetY, this.drawWidth, this.drawHeight);
            }
        }
    }

    public ResourceLocation getSpriteLocation() {
        return this.sprite;
    }

    public ItemStack getItemStack() {
        return !this.blockToRender.isEmpty() ? this.blockToRender : this.itemToRender;
    }
}

