/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.screen.components;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.List;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.inventory.StateSelectorAccessMenu;
import net.geforcemods.securitycraft.misc.FullbrightBlockAndTintGetter;
import net.geforcemods.securitycraft.screen.components.HoverChecker;
import net.geforcemods.securitycraft.screen.components.ToggleComponentButton;
import net.geforcemods.securitycraft.util.ClientUtils;
import net.geforcemods.securitycraft.util.StandingOrWallType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ComponentPath;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.StandingAndWallBlockItem;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class StateSelector
extends Screen
implements GuiEventListener,
NarratableEntry,
ContainerListener {
    private static final ResourceLocation TEXTURE = SecurityCraft.resLoc("textures/gui/container/state_selector.png");
    private static final int PAGE_LENGTH = 5;
    private static final float ROTATION_SENSITIVITY = 0.1f;
    private static final Vector3f Y_DRAG_ROTATION_VECTOR = new Vector3f((float)(1.0 / Math.sqrt(2.0)), 0.0f, (float)(1.0 / Math.sqrt(2.0)));
    private static final Quaternionf DEFAULT_ROTATION = ClientUtils.fromXYZDegrees(15.0f, -135.0f, 0.0f).rotateAxis(0.5235988f, (Vector3fc)Y_DRAG_ROTATION_VECTOR).mul((Quaternionfc)Axis.YP.rotationDegrees(-180.0f));
    private static final EnumProperty<StandingOrWallType> STANDING_OR_WALL_TYPE_PROPERTY = EnumProperty.create((String)"standing_or_wall", StandingOrWallType.class);
    private static final Vector3f Y_AXIS = new Vector3f(0.0f, 1.0f, 0.0f);
    private final StateSelectorAccessMenu menu;
    private final int xStart;
    private final int yStart;
    private final int slotToCheck;
    private final int previewXTranslation;
    private final int previewYTranslation;
    private final HoverChecker dragHoverChecker;
    private final List<Rect2i> extraAreas = new ArrayList<Rect2i>();
    private FullbrightBlockAndTintGetter fullbrightBlockAndTintGetter;
    private Item blockItem = Items.AIR;
    private BlockState state = Blocks.AIR.defaultBlockState();
    private List<Property<?>> properties = List.of();
    private BlockEntity be = null;
    private BlockEntityRenderer beRenderer = null;
    private List<BlockStatePropertyButton<?>> propertyButtons = new ArrayList();
    private int page;
    private int amountOfPages;
    private Button previousPageButton;
    private Button nextPageButton;
    private Quaternionf dragRotation = new Quaternionf();
    private Quaternionf rotation = new Quaternionf();
    private Vector3f xRotationVector = new Vector3f();
    private Vector3f yRotationVector = new Vector3f();
    private boolean clickedInDragRegion = false;
    private StandingOrWallType standingOrWallType = StandingOrWallType.NONE;

    public StateSelector(StateSelectorAccessMenu menu, Component title, int xStart, int yStart, int slotToCheck, int dragStartX, int dragStartY, int previewXTranslation, int previewYTranslation) {
        super(title);
        this.menu = menu;
        this.xStart = xStart;
        this.yStart = yStart;
        this.slotToCheck = slotToCheck;
        this.previewXTranslation = previewXTranslation;
        this.previewYTranslation = previewYTranslation;
        this.dragHoverChecker = new HoverChecker(dragStartY += yStart, dragStartY + 47, dragStartX += xStart, dragStartX + 47);
        this.copyStateFromMenu();
        menu.addSlotListener(this);
    }

    protected void init() {
        this.previousPageButton = Button.builder((Component)Component.literal((String)"<"), button -> this.turnPage(-1)).bounds(this.xStart + 69, this.yStart + 125, 20, 20).build();
        this.nextPageButton = Button.builder((Component)Component.literal((String)">"), button -> this.turnPage(1)).bounds(this.xStart + 126, this.yStart + 125, 20, 20).build();
        this.updateButtons(true, false);
        this.extraAreas.add(new Rect2i(this.xStart, 0, 193, this.minecraft.getWindow().getGuiScaledHeight()));
        this.fullbrightBlockAndTintGetter = new FullbrightBlockAndTintGetter((BlockAndTintGetter)this.minecraft.level);
    }

    private void copyStateFromMenu() {
        Item item = this.menu.getStateStack().getItem();
        if (item instanceof BlockItem) {
            BlockItem item2 = (BlockItem)item;
            BlockState savedState = this.menu.getSavedState();
            Block blockToCheck = item2.getBlock();
            this.standingOrWallType = this.menu.getStandingOrWallType();
            if (item2 instanceof StandingAndWallBlockItem) {
                StandingAndWallBlockItem sawbi = (StandingAndWallBlockItem)item2;
                if (this.standingOrWallType == StandingOrWallType.WALL) {
                    blockToCheck = sawbi.wallBlock;
                }
            }
            this.state = blockToCheck == savedState.getBlock() ? savedState : item2.getBlock().defaultBlockState();
            this.blockItem = item2;
        }
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        MultiBufferSource.BufferSource bufferSource = this.minecraft.renderBuffers().bufferSource();
        PoseStack pose = guiGraphics.pose();
        DEFAULT_ROTATION.mul((Quaternionfc)this.dragRotation, this.rotation);
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        this.previousPageButton.render(guiGraphics, mouseX, mouseY, partialTick);
        this.nextPageButton.render(guiGraphics, mouseX, mouseY, partialTick);
        pose.pushPose();
        pose.translate((float)(this.xStart + this.previewXTranslation), (float)(this.yStart + this.previewYTranslation), 100.0f);
        pose.scale(-24.0f, -24.0f, -24.0f);
        pose.translate(0.5f, 0.5f, 0.5f);
        pose.mulPose((Quaternionfc)this.rotation.rotateY((float)Math.toRadians(-90.0)));
        pose.translate(-0.5f, -0.5f, -0.5f);
        Lighting.setupForEntityInInventory((Quaternionf)this.rotation);
        this.renderBlockModel(this.state, pose, (MultiBufferSource)bufferSource);
        if (this.beRenderer != null) {
            this.beRenderer.render(this.be, partialTick, pose, (MultiBufferSource)bufferSource, 0xF000F0, OverlayTexture.NO_OVERLAY, this.minecraft.gameRenderer.getMainCamera().getPosition());
        }
        pose.popPose();
        guiGraphics.flush();
        Lighting.setupFor3DItems();
        for (int i = 0; i < this.propertyButtons.size(); ++i) {
            String propertyName = this.propertyButtons.get(i).getProperty().getName();
            guiGraphics.drawString(this.font, propertyName, this.xStart + 91 - this.font.width(propertyName) - 2, this.yStart + i * 23 + 10, 0x404040, false);
        }
        guiGraphics.drawString(this.font, this.page + "/" + this.amountOfPages, this.xStart + 100, this.yStart + 130, 0x404040, false);
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        guiGraphics.blit(RenderType::guiTextured, TEXTURE, this.xStart, this.yStart, 0.0f, 0.0f, 193, 150, 256, 256);
    }

    public void updateButtons(boolean updateInfo, boolean slotChanged) {
        if (updateInfo) {
            this.properties = new ArrayList(this.state.getProperties());
            this.properties.removeIf(arg_0 -> ((BooleanProperty)BlockStateProperties.WATERLOGGED).equals(arg_0));
            if (this.blockItem instanceof StandingAndWallBlockItem) {
                this.properties.add(0, (Property<?>)STANDING_OR_WALL_TYPE_PROPERTY);
                if (slotChanged) {
                    this.standingOrWallType = StandingOrWallType.STANDING;
                }
            } else if (slotChanged) {
                this.standingOrWallType = StandingOrWallType.NONE;
            }
            this.amountOfPages = (int)Math.ceil((float)this.properties.size() / 5.0f);
            this.page = switch (this.amountOfPages) {
                case 0 -> 0;
                default -> 1;
            };
            this.updateBlockEntityInfo(true);
            this.dragRotation.identity();
        }
        int buttonY = 0;
        int pageStartIndex = (this.page - 1) * 5;
        int i = 0;
        this.propertyButtons.forEach(x$0 -> this.removeWidget((GuiEventListener)x$0));
        this.propertyButtons.clear();
        for (Property<?> property : this.properties) {
            if (i < pageStartIndex) {
                ++i;
                continue;
            }
            if (i >= pageStartIndex + 5) break;
            List values = property.getPossibleValues();
            StandingOrWallType defaultValue = property == STANDING_OR_WALL_TYPE_PROPERTY ? this.standingOrWallType : this.state.getValue(property);
            int defaultValueIndex = 0;
            for (Object o : values) {
                if (o == defaultValue) break;
                ++defaultValueIndex;
            }
            this.propertyButtons.add((BlockStatePropertyButton)this.addRenderableWidget((GuiEventListener)new BlockStatePropertyButton(this.xStart + 91, this.yStart + buttonY + 5, 100, 20, defaultValueIndex, property)));
            buttonY += 23;
            ++i;
        }
        if (this.previousPageButton != null) {
            boolean bl = this.previousPageButton.active = this.page > 1;
        }
        if (this.nextPageButton != null) {
            this.nextPageButton.active = this.page != this.amountOfPages;
        }
    }

    public void turnPage(int direction) {
        this.page = (int)((float)this.page + Math.signum(direction));
        if (this.page > this.amountOfPages) {
            this.page = 1;
        } else if (this.page < 1) {
            this.page = this.amountOfPages;
        }
        this.updateButtons(false, false);
    }

    private void updateBlockEntityInfo(boolean reset) {
        if (reset) {
            this.be = null;
            this.beRenderer = null;
        }
        if (this.state.hasBlockEntity()) {
            if (this.be == null) {
                Minecraft mc = Minecraft.getInstance();
                this.be = ((EntityBlock)this.state.getBlock()).newBlockEntity(BlockPos.ZERO, this.state);
                if (this.be != null) {
                    this.be.setLevel((Level)mc.level);
                    this.be.applyComponentsFromItemStack(this.menu.getStateStack());
                    this.beRenderer = mc.getBlockEntityRenderDispatcher().getRenderer(this.be);
                } else {
                    this.beRenderer = null;
                }
            } else {
                this.be.setBlockState(this.state);
            }
        }
    }

    public void renderBlockModel(BlockState state, PoseStack pose, MultiBufferSource bufferSource) {
        if (state.getRenderShape() == RenderShape.MODEL) {
            BlockRenderDispatcher blockRenderer = this.minecraft.getBlockRenderer();
            BlockStateModel blockModel = blockRenderer.getBlockModel(state);
            blockRenderer.getModelRenderer().tesselateWithoutAO((BlockAndTintGetter)this.fullbrightBlockAndTintGetter, blockModel.collectParts((BlockAndTintGetter)this.minecraft.level, BlockPos.ZERO, state, RandomSource.create((long)42L)), state, BlockPos.ZERO, pose, arg_0 -> ((MultiBufferSource)bufferSource).getBuffer(arg_0), false, OverlayTexture.NO_OVERLAY);
        }
    }

    public boolean isMouseOver(double mouseX, double mouseY) {
        boolean isWithinMainScreen = mouseX >= (double)this.xStart && mouseX < (double)(this.xStart + 193) && mouseY >= (double)this.yStart && mouseY < (double)(this.yStart + 150);
        this.clickedInDragRegion = this.dragHoverChecker.checkHover(mouseX, mouseY);
        return isWithinMainScreen || this.clickedInDragRegion;
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (button == 0 && this.clickedInDragRegion) {
            Quaternionf inverted = new Quaternionf((Quaternionfc)this.dragRotation).invert();
            this.dragRotation.mul((Quaternionfc)new Quaternionf().fromAxisAngleRad((Vector3fc)Y_AXIS.rotate((Quaternionfc)inverted, this.xRotationVector), (float)dragX * 0.1f));
            this.dragRotation.mul((Quaternionfc)new Quaternionf().fromAxisAngleRad((Vector3fc)Y_DRAG_ROTATION_VECTOR.rotate((Quaternionfc)inverted, this.yRotationVector), (float)(-dragY) * 0.1f));
            return true;
        }
        return false;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        for (int i = 0; i < this.propertyButtons.size() && !this.propertyButtons.get(i).mouseClicked(mouseX, mouseY, button); ++i) {
        }
        this.previousPageButton.mouseClicked(mouseX, mouseY, button);
        this.nextPageButton.mouseClicked(mouseX, mouseY, button);
        return false;
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        this.clickedInDragRegion = false;
        return false;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        for (int i = 0; i < this.propertyButtons.size() && !this.propertyButtons.get(i).mouseScrolled(mouseX, mouseY, scrollX, scrollY); ++i) {
        }
        return false;
    }

    public void slotChanged(AbstractContainerMenu menu, int slotIndex, ItemStack newStack) {
        if (slotIndex == this.slotToCheck) {
            Item item = newStack.getItem();
            if (item instanceof BlockItem) {
                BlockItem item2 = (BlockItem)item;
                if (this.state == null || item2.getBlock() != this.state.getBlock()) {
                    this.state = item2.getBlock().defaultBlockState();
                    this.blockItem = item2;
                }
            } else {
                this.state = Blocks.AIR.defaultBlockState();
                this.blockItem = Items.AIR;
            }
            this.updateButtons(true, true);
            if (this.menu != null) {
                this.menu.onStateChange(this.state);
            }
        }
    }

    public void changeFocus(ComponentPath path) {
    }

    public List<? extends GuiEventListener> children() {
        return List.of();
    }

    public void dataChanged(AbstractContainerMenu menu, int slotIndex, int value) {
    }

    public void updateNarration(NarrationElementOutput narrationElementOutput) {
    }

    public NarratableEntry.NarrationPriority narrationPriority() {
        return NarratableEntry.NarrationPriority.NONE;
    }

    public BlockState getState() {
        return this.state;
    }

    public StandingOrWallType getStandingOrWallType() {
        return this.standingOrWallType;
    }

    public List<Rect2i> getGuiExtraAreas() {
        return this.extraAreas;
    }

    public class BlockStatePropertyButton<T extends Comparable<T>>
    extends ToggleComponentButton {
        private final Property<T> property;
        private T value;

        public BlockStatePropertyButton(int xPos, int yPos, int width, int height, int initialValue, Property<T> property) {
            super(xPos, yPos, width, height, null, initialValue, property.getPossibleValues().size(), b -> {});
            this.property = property;
            this.onValueChange();
        }

        @Override
        public void onValueChange() {
            if (this.property != null) {
                List values = this.property.getPossibleValues();
                int i = 0;
                for (Comparable t : values) {
                    if (i++ != this.getCurrentIndex()) continue;
                    this.value = t;
                    break;
                }
                this.setMessage((Component)Component.literal((String)this.property.getName(this.value)));
            }
        }

        public void onPress() {
            if (this.property == STANDING_OR_WALL_TYPE_PROPERTY) {
                StateSelector.this.state = StateSelector.this.standingOrWallType.getNewState((StandingAndWallBlockItem)StateSelector.this.blockItem);
                StateSelector.this.standingOrWallType = StateSelector.this.standingOrWallType == StandingOrWallType.STANDING ? StandingOrWallType.WALL : StandingOrWallType.STANDING;
                StateSelector.this.updateButtons(true, false);
                StateSelector.this.updateBlockEntityInfo(true);
            } else {
                StateSelector.this.state = (BlockState)StateSelector.this.state.setValue(this.property, this.value);
                StateSelector.this.updateBlockEntityInfo(false);
            }
            StateSelector.this.menu.onStateChange(StateSelector.this.state);
        }

        public Property<T> getProperty() {
            return this.property;
        }

        public T getValue() {
            return this.value;
        }
    }
}

