/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.geforcemods.securitycraft.ClientHandler;
import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.blockentities.BlockChangeDetectorBlockEntity;
import net.geforcemods.securitycraft.blockentities.SecurityCameraBlockEntity;
import net.geforcemods.securitycraft.blocks.SecurityCameraBlock;
import net.geforcemods.securitycraft.entity.camera.CameraViewAreaExtension;
import net.geforcemods.securitycraft.items.CameraMonitorItem;
import net.geforcemods.securitycraft.misc.BlockEntityTracker;
import net.geforcemods.securitycraft.misc.CameraRedstoneModuleState;
import net.geforcemods.securitycraft.misc.KeyBindings;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShapeRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipProvider;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.event.RenderHandEvent;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import net.neoforged.neoforge.common.ModConfigSpec;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;
import net.neoforged.neoforge.event.level.ChunkEvent;
import net.neoforged.neoforge.registries.DeferredHolder;

@EventBusSubscriber(modid="securitycraft", value={Dist.CLIENT})
public class SCClientEventHandler {
    public static final ResourceLocation BACKGROUND_SPRITE = SecurityCraft.resLoc("hud/camera/background");
    public static final ResourceLocation LIVE_SPRITE = SecurityCraft.resLoc("hud/camera/live");
    public static final ResourceLocation NIGHT_VISION_INACTIVE_SPRITE = SecurityCraft.resLoc("hud/camera/night_vision_inactive");
    public static final ResourceLocation REDSTONE_MODULE_NOT_PRESENT_SPRITE = SecurityCraft.resLoc("hud/camera/redstone_module_not_present");
    public static final ResourceLocation REDSTONE_MODULE_PRESENT_SPRITE = SecurityCraft.resLoc("hud/camera/redstone_module_present");
    public static final ResourceLocation NIGHT_VISION = SecurityCraft.mcResLoc("textures/mob_effect/night_vision.png");
    public static final ItemStack REDSTONE = new ItemStack((ItemLike)Items.REDSTONE);
    private static final Component REDSTONE_NOTE = Utils.localize("gui.securitycraft:camera.toggleRedstoneNote", new Object[0]);
    private static final Component SMART_MODULE_NOTE = Utils.localize("gui.securitycraft:camera.smartModuleNote", new Object[0]);
    private static final CameraKeyInfoEntry[] CAMERA_KEY_INFO_LIST;
    private static final List<DeferredHolder<DataComponentType<?>, ? extends DataComponentType<? extends TooltipProvider>>> COMPONENTS_WITH_GLOBAL_TOOLTIP;
    private static float cameraInfoMessageTime;

    private SCClientEventHandler() {
    }

    @SubscribeEvent
    public static void onClientTickPost(ClientTickEvent.Post event) {
        if (cameraInfoMessageTime >= 0.0f) {
            cameraInfoMessageTime -= 1.0f;
        }
    }

    @SubscribeEvent
    public static void onRenderLevelStage(RenderLevelStageEvent event) {
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_TRIPWIRE_BLOCKS) {
            Vec3 camPos = event.getCamera().getPosition();
            PoseStack pose = event.getPoseStack();
            Minecraft mc = Minecraft.getInstance();
            ClientLevel level = mc.level;
            VertexConsumer consumer = mc.renderBuffers().bufferSource().getBuffer((RenderType)ClientHandler.OVERLAY_LINES);
            for (BlockPos bcdPos : BlockEntityTracker.BLOCK_CHANGE_DETECTOR.getTrackedBlockEntities((Level)level)) {
                BlockChangeDetectorBlockEntity bcd;
                BlockEntity be = level.getBlockEntity(bcdPos);
                if (!(be instanceof BlockChangeDetectorBlockEntity) || !(bcd = (BlockChangeDetectorBlockEntity)be).isShowingHighlights() || !bcd.isOwnedBy((Entity)mc.player)) continue;
                int packedColor = bcd.getColor();
                float r = (float)ARGB.red((int)packedColor) / 255.0f;
                float g = (float)ARGB.green((int)packedColor) / 255.0f;
                float b = (float)ARGB.blue((int)packedColor) / 255.0f;
                for (BlockChangeDetectorBlockEntity.ChangeEntry changeEntry : bcd.getFilteredEntries()) {
                    BlockPos pos = changeEntry.pos();
                    pose.pushPose();
                    pose.translate((double)pos.getX() - camPos.x, (double)pos.getY() - camPos.y, (double)pos.getZ() - camPos.z);
                    ShapeRenderer.renderLineBox((PoseStack)pose, (VertexConsumer)consumer, (double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0, (float)r, (float)g, (float)b, (float)1.0f);
                    pose.popPose();
                }
            }
            mc.renderBuffers().bufferSource().endBatch();
        }
    }

    @SubscribeEvent
    public static void renderHandEvent(RenderHandEvent event) {
        if (ClientHandler.isPlayerMountedOnCamera()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onClickInput(InputEvent.InteractionKeyMappingTriggered event) {
        if (ClientHandler.isPlayerMountedOnCamera()) {
            Minecraft mc = Minecraft.getInstance();
            InteractionHand hand = event.getHand();
            if (mc.player.getItemInHand(hand).is((Item)SCContent.CAMERA_MONITOR.get()) && event.isUseItem()) {
                ((CameraMonitorItem)((Object)SCContent.CAMERA_MONITOR.get())).use((Level)mc.level, (Player)mc.player, hand);
            }
            event.setCanceled(true);
            event.setSwingHand(false);
        }
    }

    @SubscribeEvent
    public static void onChunkUnload(ChunkEvent.Unload event) {
        if (event.getLevel().isClientSide()) {
            ChunkPos pos = ((LevelChunk)event.getChunk()).getPos();
            CameraViewAreaExtension.onChunkUnload(pos.x, pos.z);
        }
    }

    @SubscribeEvent
    public static void onItemTooltip(ItemTooltipEvent event) {
        ItemStack stack = event.getItemStack();
        Item.TooltipContext ctx = event.getContext();
        List tooltip = event.getToolTip();
        TooltipFlag flag = event.getFlags();
        int nextIndex = 0;
        for (int i = 0; i < COMPONENTS_WITH_GLOBAL_TOOLTIP.size(); ++i) {
            TooltipProvider tooltipProvider = (TooltipProvider)stack.get((Supplier)COMPONENTS_WITH_GLOBAL_TOOLTIP.get(i));
            if (tooltipProvider == null) continue;
            int index = nextIndex++ + 1;
            tooltipProvider.addToTooltip(ctx, line -> {
                if (index >= tooltip.size()) {
                    tooltip.add(line);
                } else {
                    tooltip.add(index, line);
                }
            }, flag);
        }
    }

    public static void cameraOverlay(GuiGraphics guiGraphics, DeltaTracker deltaTracker) {
        Minecraft mc = Minecraft.getInstance();
        ClientLevel level = mc.level;
        BlockPos pos = mc.cameraEntity.blockPosition();
        Window window = mc.getWindow();
        int scaledWidth = window.getGuiScaledWidth();
        int scaledHeight = window.getGuiScaledHeight();
        if (mc.options.hideGui || mc.getDebugOverlay().showDebugScreen()) {
            return;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof SecurityCameraBlockEntity)) {
            return;
        }
        SecurityCameraBlockEntity be = (SecurityCameraBlockEntity)blockEntity;
        Font font = Minecraft.getInstance().font;
        Options options = Minecraft.getInstance().options;
        BlockState state = level.getBlockState(pos);
        long dayTime = Minecraft.getInstance().level.getDayTime();
        int hours24 = (int)((float)dayTime / 1000.0f + 6.0f) % 24;
        int hours = hours24 % 12;
        int minutes = (int)((float)dayTime / 16.666666f % 60.0f);
        String time = String.format("%02d:%02d %s", hours < 1 ? 12 : hours, minutes, hours24 < 12 ? "AM" : "PM");
        int timeY = 25;
        if (be.hasCustomName()) {
            Component cameraName = be.getCustomName();
            guiGraphics.drawString(font, cameraName, scaledWidth - font.width((FormattedText)cameraName) - 8, 25, 0xFFFFFF, true);
            timeY += 10;
        }
        guiGraphics.drawString(font, time, scaledWidth - font.width(time) - 4, timeY, 0xFFFFFF, true);
        if (cameraInfoMessageTime >= 0.0f) {
            float fadeOutPartialTick = Math.max(cameraInfoMessageTime + 1.0f - deltaTracker.getGameTimeDeltaPartialTick(false), 1.0f);
            int alpha = (int)Math.ceil(255.0f * Math.min(20.0f, fadeOutPartialTick) / 20.0f);
            int heightOffset = 10;
            for (int i = CAMERA_KEY_INFO_LIST.length - 1; i >= 0; --i) {
                CameraKeyInfoEntry entry = CAMERA_KEY_INFO_LIST[i];
                if (!entry.enabled().get().booleanValue()) continue;
                entry.drawString(options, guiGraphics, font, scaledWidth, scaledHeight, heightOffset, be, alpha);
                heightOffset += 10;
            }
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.blitSprite(RenderType::guiTextured, BACKGROUND_SPRITE, 5, 0, 90, 20);
        guiGraphics.blitSprite(RenderType::guiTextured, LIVE_SPRITE, window.getGuiScaledWidth() - 70, 5, 65, 16);
        if (!mc.player.hasEffect(MobEffects.NIGHT_VISION)) {
            guiGraphics.blitSprite(RenderType::guiTextured, NIGHT_VISION_INACTIVE_SPRITE, 28, 4, 16, 9);
        } else {
            guiGraphics.blit(RenderType::guiTextured, NIGHT_VISION, 27, -1, 0.0f, 0.0f, 18, 18, 18, 18);
        }
        if (state.getSignal((BlockGetter)level, pos, (Direction)state.getValue(SecurityCameraBlock.FACING)) == 0) {
            if (!be.isModuleEnabled(ModuleType.REDSTONE)) {
                CameraRedstoneModuleState.NOT_INSTALLED.render(guiGraphics, 12, 2);
            } else {
                CameraRedstoneModuleState.DEACTIVATED.render(guiGraphics, 12, 2);
            }
        } else {
            CameraRedstoneModuleState.ACTIVATED.render(guiGraphics, 12, 2);
        }
    }

    public static void resetCameraInfoMessageTime() {
        cameraInfoMessageTime = 200.0f;
    }

    static {
        CameraKeyInfoEntry[] cameraKeyInfoEntryArray = new CameraKeyInfoEntry[8];
        cameraKeyInfoEntryArray[0] = new CameraKeyInfoEntry(() -> true, options -> Utils.localize("gui.securitycraft:camera.lookAround", options.keyUp.getTranslatedKeyMessage(), options.keyLeft.getTranslatedKeyMessage(), options.keyDown.getTranslatedKeyMessage(), options.keyRight.getTranslatedKeyMessage()), $ -> true);
        cameraKeyInfoEntryArray[1] = new CameraKeyInfoEntry(() -> true, options -> Utils.localize("gui.securitycraft:camera.exit", options.keyShift.getTranslatedKeyMessage()), $ -> true);
        cameraKeyInfoEntryArray[2] = new CameraKeyInfoEntry(() -> true, $ -> Utils.localize("gui.securitycraft:camera.zoom", KeyBindings.cameraZoomIn.getTranslatedKeyMessage(), KeyBindings.cameraZoomOut.getTranslatedKeyMessage()), $ -> true);
        cameraKeyInfoEntryArray[3] = new CameraKeyInfoEntry(() -> ((ModConfigSpec.BooleanValue)ConfigHandler.SERVER.allowCameraNightVision).get(), $ -> Utils.localize("gui.securitycraft:camera.activateNightVision", KeyBindings.cameraActivateNightVision.getTranslatedKeyMessage()), $ -> true);
        cameraKeyInfoEntryArray[4] = new CameraKeyInfoEntry(() -> true, $ -> Utils.localize("gui.securitycraft:camera.toggleRedstone", KeyBindings.cameraEmitRedstone.getTranslatedKeyMessage()), be -> be.isModuleEnabled(ModuleType.REDSTONE));
        cameraKeyInfoEntryArray[5] = new CameraKeyInfoEntry(() -> true, $ -> REDSTONE_NOTE, be -> be.isModuleEnabled(ModuleType.REDSTONE));
        cameraKeyInfoEntryArray[6] = new CameraKeyInfoEntry(() -> true, $ -> Utils.localize("gui.securitycraft:camera.setDefaultViewingDirection", KeyBindings.setDefaultViewingDirection.getTranslatedKeyMessage()), be -> be.isModuleEnabled(ModuleType.SMART));
        cameraKeyInfoEntryArray[7] = new CameraKeyInfoEntry(() -> true, $ -> SMART_MODULE_NOTE, be -> be.isModuleEnabled(ModuleType.SMART));
        CAMERA_KEY_INFO_LIST = cameraKeyInfoEntryArray;
        COMPONENTS_WITH_GLOBAL_TOOLTIP = List.of(SCContent.OWNER_DATA, SCContent.NOTES);
    }

    public record CameraKeyInfoEntry(Supplier<Boolean> enabled, Function<Options, Component> text, Predicate<SecurityCameraBlockEntity> whiteText) {
        public void drawString(Options options, GuiGraphics guiGraphics, Font font, int scaledWidth, int scaledHeight, int heightOffset, SecurityCameraBlockEntity be, int alpha) {
            Component text = this.text().apply(options);
            int textColor = this.whiteText().test(be) ? 0xFFFFFF : 0xFF3377;
            guiGraphics.drawString(font, text, scaledWidth - font.width((FormattedText)text) - 8, scaledHeight - heightOffset, textColor + (alpha << 24), true);
        }
    }
}

