/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.api;

import net.geforcemods.securitycraft.api.IModuleInventory;
import net.minecraft.world.item.ItemStack;

public interface IModuleInventoryWithContainer
extends IModuleInventory {
    public int getContainerSize();

    public boolean isItemValidForContainer(int var1, ItemStack var2);

    public ItemStack getStackInContainer(int var1);

    public ItemStack removeContainerItem(int var1, int var2, boolean var3);

    public void setContainerItem(int var1, ItemStack var2);

    public boolean isContainerEmpty();

    default public int getContainerStackSize() {
        return 99;
    }

    default public boolean isContainer(int slot) {
        return slot < 100;
    }

    @Override
    default public int getSlots() {
        return this.getContainerSize();
    }

    @Override
    default public ItemStack getStackInSlot(int slot) {
        return this.isContainer(slot) ? this.getStackInContainer(slot) : IModuleInventory.super.getStackInSlot(slot);
    }

    @Override
    default public ItemStack extractItem(int slot, int amount, boolean simulate) {
        return this.isContainer(slot) ? this.removeContainerItem(slot, amount, simulate) : IModuleInventory.super.extractItem(slot, amount, simulate);
    }

    @Override
    default public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        if (this.isContainer(slot)) {
            if (stack.isEmpty()) {
                return ItemStack.EMPTY;
            }
            if (!this.isItemValid(slot, stack)) {
                return stack;
            }
            ItemStack existing = this.getStackInContainer(slot);
            if (!existing.isEmpty() && !ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)existing)) {
                return stack;
            }
            if (!simulate) {
                if (existing.isEmpty()) {
                    this.setContainerItem(slot, stack);
                } else {
                    existing.grow(stack.getCount());
                }
            }
            return ItemStack.EMPTY;
        }
        return IModuleInventory.super.insertItem(slot, stack, simulate);
    }

    @Override
    default public void setStackInSlot(int slot, ItemStack stack) {
        if (this.isContainer(slot)) {
            this.setContainerItem(slot, stack);
        } else {
            IModuleInventory.super.setStackInSlot(slot, stack);
        }
    }

    @Override
    default public int getSlotLimit(int slot) {
        return this.isContainer(slot) ? this.getContainerStackSize() : IModuleInventory.super.getSlotLimit(slot);
    }

    @Override
    default public boolean isItemValid(int slot, ItemStack stack) {
        return this.isContainer(slot) ? this.isItemValidForContainer(slot, stack) : IModuleInventory.super.isItemValid(slot, stack);
    }
}

