/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blockentities;

import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.CustomizableBlockEntity;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.blocks.AlarmBlock;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.misc.SCSounds;
import net.geforcemods.securitycraft.network.client.PlayAlarmSound;
import net.geforcemods.securitycraft.util.AlarmSoundHandler;
import net.geforcemods.securitycraft.util.ITickingBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.network.PacketDistributor;

public class AlarmBlockEntity
extends CustomizableBlockEntity
implements ITickingBlockEntity {
    public static final int MAXIMUM_ALARM_SOUND_LENGTH = 3600;
    private Option.IntOption range;
    private Option.DisabledOption disabled;
    private Option.BooleanOption resetCooldown;
    private int cooldown;
    private boolean isPowered;
    private SoundEvent sound;
    private float pitch;
    private boolean soundPlaying;
    private int soundLength;

    public AlarmBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)SCContent.ALARM_BLOCK_ENTITY.get(), pos, state);
        this.range = new Option.IntOption("range", 17, 0, (Integer)ConfigHandler.getOrDefault(ConfigHandler.SERVER.maxAlarmRange), 1);
        this.disabled = new Option.DisabledOption(false);
        this.resetCooldown = new Option.BooleanOption("resetCooldown", true);
        this.cooldown = 0;
        this.isPowered = false;
        this.sound = SCSounds.ALARM.event;
        this.pitch = 1.0f;
        this.soundPlaying = false;
        this.soundLength = 2;
    }

    @Override
    public void tick(Level level, BlockPos pos, BlockState state) {
        if (level.isClientSide && this.soundPlaying && (this.isDisabled() || !((Boolean)this.getBlockState().getValue((Property)AlarmBlock.LIT)).booleanValue())) {
            this.stopPlayingSound();
        }
        if (!this.isDisabled() && this.isPowered && --this.cooldown <= 0) {
            if (!level.isClientSide) {
                double rangeSqr = Math.pow(((Integer)this.range.get()).intValue(), 2.0);
                Holder soundEventHolder = BuiltInRegistries.SOUND_EVENT.wrapAsHolder((Object)(this.isModuleEnabled(ModuleType.SMART) ? this.sound : SCSounds.ALARM.event));
                for (ServerPlayer player : ((ServerLevel)level).getPlayers(p -> p.blockPosition().distSqr((Vec3i)pos) <= rangeSqr)) {
                    float volume = (float)(1.0 - player.blockPosition().distSqr((Vec3i)pos) / rangeSqr);
                    PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new PlayAlarmSound(this.worldPosition, (Holder<SoundEvent>)soundEventHolder, volume, this.getPitch(), player.getCommandSenderWorld().random.nextLong()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }
            this.setCooldown(this.soundLength * 20);
        }
    }

    @Override
    public void saveAdditional(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        super.saveAdditional(tag, lookupProvider);
        tag.putInt("cooldown", this.cooldown);
        tag.putBoolean("isPowered", this.isPowered);
        tag.putString("sound", this.sound.location().toString());
        tag.putFloat("pitch", this.pitch);
        tag.putInt("delay", this.soundLength);
    }

    @Override
    public void loadAdditional(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        super.loadAdditional(tag, lookupProvider);
        this.cooldown = tag.getInt("cooldown");
        this.isPowered = tag.getBoolean("isPowered");
        if (tag.contains("sound", 8)) {
            this.setSound(ResourceLocation.parse((String)tag.getString("sound")));
        } else {
            this.setSound(SCSounds.ALARM.location);
        }
        this.pitch = tag.contains("pitch") ? tag.getFloat("pitch") : 1.0f;
        this.soundLength = tag.getInt("delay");
    }

    public void setSound(ResourceLocation soundEvent) {
        this.sound = SoundEvent.createVariableRangeEvent((ResourceLocation)soundEvent);
        this.setChanged();
    }

    public SoundEvent getSound() {
        return this.isModuleEnabled(ModuleType.SMART) ? this.sound : SCSounds.ALARM.event;
    }

    public void setPitch(float pitch) {
        this.pitch = pitch;
    }

    public float getPitch() {
        return this.pitch;
    }

    public int getSoundLength() {
        return this.soundLength;
    }

    public void setSoundLength(int soundLength) {
        this.soundLength = Mth.clamp((int)soundLength, (int)1, (int)3600);
        this.setCooldown(0);
        if (this.level.isClientSide) {
            this.stopPlayingSound();
        }
    }

    public void setCooldown(int cooldown) {
        this.cooldown = cooldown;
        this.setChanged();
    }

    public int getCooldown() {
        return this.cooldown;
    }

    public boolean isPowered() {
        return this.isPowered;
    }

    public void setPowered(boolean isPowered) {
        this.isPowered = isPowered;
        if (isPowered && ((Boolean)this.resetCooldown.get()).booleanValue()) {
            this.setCooldown(0);
        }
        this.setChanged();
    }

    public boolean isDisabled() {
        return (Boolean)this.disabled.get();
    }

    @Override
    public ModuleType[] acceptedModules() {
        return new ModuleType[]{ModuleType.SMART};
    }

    @Override
    public Option<?>[] customOptions() {
        return new Option[]{this.range, this.disabled, this.resetCooldown};
    }

    public void setRemoved() {
        super.setRemoved();
        if (this.level.isClientSide && this.soundPlaying) {
            this.stopPlayingSound();
        }
    }

    public void playSound(Level level, double x, double y, double z, Holder<SoundEvent> sound, float volume, float pitch, long seed) {
        AlarmSoundHandler.playSound(this, level, x, y, z, sound, SoundSource.BLOCKS, volume, pitch, seed);
        this.soundPlaying = true;
    }

    public void stopPlayingSound() {
        AlarmSoundHandler.stopCurrentSound(this);
        this.soundPlaying = false;
    }
}

